/*
 * Decompiled with CFR 0.152.
 */
package de.werum.uvkp.plausi;

import de.werum.uvkp.plausi.PlausiResult;
import de.werum.uvkp.plausi.logger.LoggerIfc;
import de.werum.uvkp.plausi.logger.LoggerManager;
import de.werum.uvkp.plausi.runtime.DefaultPlausiError;
import de.werum.uvkp.plausi.runtime.DefaultPlausiResult;
import de.werum.uvkp.plausi.runtime.PlausiPerformer;
import de.werum.uvkp.plausi.runtime.log.ResultLog;
import de.werum.uvkp.plausi.runtime.log.ResultLogFacade;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;

public class PlausiFacade {
    private static final transient LoggerIfc log = LoggerManager.getInstance().getLogger(PlausiFacade.class);
    private static HashMap parameter;
    private static PlausiFacade instance;

    private PlausiFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlausiFacade getInstance() {
        if (instance != null) return instance;
        Class<PlausiFacade> clazz = PlausiFacade.class;
        synchronized (PlausiFacade.class) {
            if (instance != null) return instance;
            instance = new PlausiFacade();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public PlausiResult doPlausi(String string, String string2) {
        PlausiResult plausiResult = null;
        PlausiPerformer plausiPerformer = new PlausiPerformer();
        plausiResult = plausiPerformer.doPlausi(string, string2);
        return plausiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n = -1;
        PlausiFacade plausiFacade = PlausiFacade.getInstance();
        String string = "csv";
        PlausiFacade.initialisierenParameter(stringArray);
        boolean bl = false;
        int n2 = 0;
        String string2 = "";
        String string3 = "";
        if (parameter.keySet().contains("f")) {
            string2 = (String)parameter.get("f");
            if (parameter.keySet().contains("o")) {
                string3 = (String)parameter.get("o");
                bl = true;
            } else {
                System.err.println("Keine Ergebnisdatei mit -o vorgegeben.");
            }
        } else {
            System.err.println("Keine zu pr\u00fcfende Datei mit -f vorgegeben.");
        }
        if (bl) {
            PrintStream printStream = null;
            InputStreamReader inputStreamReader = null;
            try {
                String string4;
                n2 = 0;
                int n3 = 0;
                String string5 = null;
                printStream = new PrintStream(new FileOutputStream(string3));
                ResultLog resultLog = ResultLogFacade.getInstance().getLog(string, printStream);
                resultLog.printHeader();
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string2), PlausiPerformer.DEFAULT_ENCODING);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string4 = bufferedReader.readLine()) != null) {
                    String string6;
                    PlausiResult plausiResult = null;
                    if (++n2 == 1) {
                        if (string4.startsWith("VOSZ")) {
                            if (string4.length() != 105) {
                                plausiResult = PlausiFacade.erzeugeSystemfehler(n2, "VOSZ", null, null, "Vorlaufsatz nicht 104 Zeichen lang.", null);
                            } else {
                                string6 = string4.substring(4, 9);
                                if (string6.equals("UNUVS")) {
                                    string5 = "DSAS";
                                } else if (string6.equals("UNUVL")) {
                                    string5 = "DSLN";
                                } else {
                                    plausiResult = PlausiFacade.erzeugeSystemfehler(n2, "VOSZ", null, null, "Verfahrensmerkmal muss entweder UNUVS oder UNUVL sein.", null);
                                }
                            }
                        } else {
                            plausiResult = PlausiFacade.erzeugeSystemfehler(n2, "VOSZ", null, null, "Satzkennzeichen des Vorlaufsatzes muss \"VOSZ\" sein.", null);
                        }
                    } else if (n2 == 2) {
                        ++n3;
                        log.info("=== Bearbeite Kommunikationsdatensatz: " + n2 + " =====================");
                        try {
                            plausiResult = PlausiFacade.getInstance().doPlausi("DSKO", string4);
                            log.info("Satzkennzeichen: " + plausiResult.getSatzkennzeichen());
                            log.info("Version: " + plausiResult.getVersion());
                            log.info("Maximaler Fehlertyp: " + plausiResult.getMaxErrorType());
                            log.info("Fehleranzahl: " + plausiResult.getErrorCount());
                        }
                        catch (Exception exception) {
                            plausiResult = PlausiFacade.erzeugeSystemfehler(n2, "DSKO", null, null, exception.getMessage(), exception);
                        }
                    } else if (string4.startsWith("NCSZ")) {
                        if (string4.length() != 63) {
                            plausiResult = PlausiFacade.erzeugeSystemfehler(n2, "NCSZ", null, null, "Nachlaufsatz nicht 63 Zeichen lang.", null);
                        } else {
                            string6 = string4.substring(54, 61);
                            try {
                                int n4 = Integer.parseInt(string6);
                                if (n4 != n3) {
                                    plausiResult = PlausiFacade.erzeugeSystemfehler(n2, "NCSZ", null, null, "Nutzdatensatzanzahl nicht korrekt. Ist: " + n4 + " Soll: " + n3, null);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                plausiResult = PlausiFacade.erzeugeSystemfehler(n2, "NCSZ", null, null, "Satzanzahl keine Zahl.", null);
                            }
                        }
                    } else {
                        log.info("=== Bearbeite Nutzdatensatz: " + ++n3 + " =====================");
                        try {
                            plausiResult = PlausiFacade.getInstance().doPlausi(string5, string4);
                            log.info("Satzkennzeichen: " + plausiResult.getSatzkennzeichen());
                            log.info("Version: " + plausiResult.getVersion());
                            log.info("Maximaler Fehlertyp: " + plausiResult.getMaxErrorType());
                            log.info("Fehleranzahl: " + plausiResult.getErrorCount());
                        }
                        catch (Exception exception) {
                            plausiResult = PlausiFacade.erzeugeSystemfehler(n2, null, null, null, exception.getMessage(), exception);
                        }
                    }
                    if (plausiResult == null) continue;
                    resultLog.printResult(n2, plausiResult);
                    if (n >= plausiResult.getMaxErrorType()) continue;
                    n = plausiResult.getMaxErrorType();
                }
                resultLog.printFooter();
            }
            catch (Exception exception) {
                log.error("Fehler bei der Verarbeitung von Datei " + string2 + " Satz " + n2 + ":", exception);
            }
            finally {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
                try {
                    printStream.close();
                }
                catch (Exception exception) {}
            }
        } else {
            PlausiFacade.printUsage();
        }
        System.exit(n);
    }

    public static void printUsage() {
        System.err.println("usage: PlausiFacade -f eingabedatei -o ausgabedatei");
    }

    private static void initialisierenParameter(String[] stringArray) {
        parameter = new HashMap();
        if (stringArray != null && stringArray.length > 0) {
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                if (stringArray[i].charAt(0) == '-') {
                    if (string != null) {
                        parameter.put(string, "");
                    }
                    string = stringArray[i].substring(1);
                    continue;
                }
                if (string == null) continue;
                parameter.put(string, stringArray[i]);
                string = null;
            }
            if (string != null) {
                parameter.put(string, "");
            }
        }
    }

    protected static PlausiResult erzeugeSystemfehler(int n, String string, String string2, String string3, String string4, Throwable throwable) {
        log.info("=== Satz in der Datei: " + n + " =====================");
        log.info("Satz mit Systemfehler");
        DefaultPlausiResult defaultPlausiResult = new DefaultPlausiResult(string, string2, string3);
        DefaultPlausiError defaultPlausiError = null;
        defaultPlausiError = new DefaultPlausiError();
        defaultPlausiError.setErrorCode("SYST001");
        defaultPlausiError.setErrorText("SYST001 " + string4);
        defaultPlausiError.setThrowable(throwable);
        defaultPlausiError.setErrorType(4);
        defaultPlausiResult.addError(defaultPlausiError);
        return defaultPlausiResult;
    }

    static {
        instance = null;
    }
}

