/*
 * Decompiled with CFR 0.152.
 */
package de.werum.uvkp.plausi.record.init;

import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import de.werum.uvkp.plausi.record.init.DataRecord;
import de.werum.uvkp.plausi.runtime.DataFormatException;

public class DataSetWrapper
implements SatzInterface {
    protected DataRecord dataRecord;
    protected String plausiType = null;
    protected String satzkennzeichen = null;
    protected String version = null;
    protected DataFormatException dataFormatException = null;

    public DataSetWrapper(DataRecord dataRecord) {
        this.dataRecord = dataRecord;
    }

    public int getLaenge(FeldDeskriptorInterface feldDeskriptorInterface, int[] nArray) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return this.dataRecord.getAnzahl(feldDeskriptorInterface);
    }

    public boolean hatWert(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        String string = this.dataRecord.getValue(feldDeskriptorInterface);
        return string != null && string.trim().length() > 0;
    }

    public String getString(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        return this.dataRecord.getValue(feldDeskriptorInterface);
    }

    public void setString(FeldDeskriptorInterface feldDeskriptorInterface, String string) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.dataRecord.setValue(feldDeskriptorInterface, string);
    }

    public long getLong(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        long l;
        try {
            l = Long.parseLong(this.dataRecord.getValue(feldDeskriptorInterface).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new WertNichtTypgerechtException("Auslesen einer Ganzzahl: Feld \"" + feldDeskriptorInterface.getFeldNameTB() + "\" Wert: \"" + this.dataRecord.getValue(feldDeskriptorInterface) + "\" kann nicht in eine Ganzzahl geparst werden.");
        }
        return l;
    }

    public void setLong(FeldDeskriptorInterface feldDeskriptorInterface, long l) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.dataRecord.setValue(feldDeskriptorInterface, Long.toString(l));
    }

    public double getDouble(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        double d;
        try {
            d = Double.parseDouble(this.dataRecord.getValue(feldDeskriptorInterface).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new WertNichtTypgerechtException("Auslesen einer Doubles: Feld \"" + feldDeskriptorInterface.getFeldNameTB() + "\" Wert: \"" + this.dataRecord.getValue(feldDeskriptorInterface) + "\" kann nicht in eine Doubles geparst werden.");
        }
        return d;
    }

    public void setDouble(FeldDeskriptorInterface feldDeskriptorInterface, double d) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.dataRecord.setValue(feldDeskriptorInterface, Double.toString(d));
    }

    public boolean getBool(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        boolean bl;
        try {
            bl = Boolean.valueOf(this.dataRecord.getValue(feldDeskriptorInterface).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new WertNichtTypgerechtException("Auslesen einer Booleans: Feld \"" + feldDeskriptorInterface.getFeldNameTB() + "\" Wert: \"" + this.dataRecord.getValue(feldDeskriptorInterface) + "\" kann nicht in eine Booleans geparst werden.");
        }
        return bl;
    }

    public void setBool(FeldDeskriptorInterface feldDeskriptorInterface, boolean bl) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.dataRecord.setValue(feldDeskriptorInterface, Boolean.toString(bl));
    }

    public void setLeerWert(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.dataRecord.setValue(feldDeskriptorInterface, null);
    }

    public SatzInterface getSubSatz(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return this;
    }

    public String getPlausiType() {
        return this.plausiType;
    }

    public void setPlausiType(String string) {
        this.plausiType = string;
    }

    public String getSatzkennzeichen() {
        return this.satzkennzeichen;
    }

    public void setSatzkennzeichen(String string) {
        this.satzkennzeichen = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public DataFormatException getDataFormatException() {
        return this.dataFormatException;
    }

    public void setDataFormatException(DataFormatException dataFormatException) {
        this.dataFormatException = dataFormatException;
    }

    public void debugMap() {
        if (this.dataRecord != null) {
            this.dataRecord.debugMap();
        }
    }
}

