/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui;

import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityEditorConstants;
import de.statspez.pleditor.ui.editor.PLSyntaxTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DetailsWindow
extends JWindow {
    private static final long serialVersionUID = 4680402010738696842L;
    private static int MIN_WIDTH = 200;
    private static int MIN_HEIGHT = 50;
    private static int MAX_WIDTH = 640;
    private static int MAX_HEIGHT = 400;
    private Timer timer;
    private JLabel title;
    private PLSyntaxTextArea code;
    private JPanel titlePanel;
    private JScrollPane scrollPane;

    public DetailsWindow(Component component) {
        super(SwingUtilities.getWindowAncestor(component));
        this.initUI();
    }

    private void initUI() {
        this.setFocusableWindowState(false);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        mainPanel.setBackground(SystemColor.info);
        this.titlePanel = new JPanel(new BorderLayout());
        this.titlePanel.setOpaque(false);
        this.titlePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow));
        this.title = new JLabel();
        this.title.setHorizontalAlignment(2);
        this.title.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        WindowMover mover = new WindowMover();
        this.title.addMouseListener(mover);
        this.title.addMouseMotionListener(mover);
        this.titlePanel.add((Component)this.title, "Center");
        JToolBar titleToolBar = new JToolBar();
        titleToolBar.setFloatable(false);
        titleToolBar.setOpaque(false);
        titleToolBar.setRollover(true);
        JButton closeButton = new JButton(ComplexityEditorConstants.ACTION_ICON_CLOSE);
        closeButton.setToolTipText("Schlie\u00dfen");
        closeButton.setOpaque(false);
        closeButton.setMargin(new Insets(0, 0, 0, 0));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DetailsWindow.this.setVisible(false);
            }
        });
        titleToolBar.add(closeButton);
        this.titlePanel.add((Component)titleToolBar, "East");
        mainPanel.add((Component)this.titlePanel, "North");
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setOpaque(false);
        this.code = new PLSyntaxTextArea(){

            public void scrollRectToVisible(Rectangle rect) {
            }
        };
        this.code.setOpaque(false);
        this.code.setEditable(false);
        this.code.setFont(new Font("Monospaced", 0, 11));
        this.code.setMargin(null);
        contentPanel.add((Component)this.code, "Center");
        this.scrollPane = new JScrollPane(contentPanel);
        this.scrollPane.setBorder(null);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement(200);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.getVerticalScrollBar().setBlockIncrement(200);
        JPanel windowBottomPanel = new JPanel(new BorderLayout());
        windowBottomPanel.setOpaque(false);
        windowBottomPanel.add((Component)new WindowResizer(false, true), "Center");
        windowBottomPanel.add((Component)new WindowResizer(true, true), "East");
        JPanel windowPanel = new JPanel(new BorderLayout());
        windowPanel.setOpaque(false);
        windowPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 0));
        windowPanel.add((Component)this.scrollPane, "Center");
        windowPanel.add((Component)new WindowResizer(true, false), "East");
        windowPanel.add((Component)windowBottomPanel, "South");
        mainPanel.add((Component)windowPanel, "Center");
        this.getContentPane().add(mainPanel);
    }

    public void show(Point point, Icon icon, String title, String code) {
        this.titlePanel.setVisible(true);
        this.title.setIcon(icon);
        this.title.setText(title);
        if (this.stringIsNotEmpty(code)) {
            this.code.setText(code);
            this.code.setVisible(true);
        } else {
            this.code.setText(null);
            this.code.setVisible(false);
        }
        int width = Math.max(Math.min(this.titlePanel.getPreferredSize().width + 4, MAX_WIDTH), MIN_WIDTH);
        int height = this.titlePanel.getPreferredSize().height + (this.code.isVisible() ? this.code.getPreferredSize().height : 0) + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height + 8;
        this.setBounds(point.x, point.y, width, Math.min(height, MAX_HEIGHT));
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.setVisible(true);
    }

    public void close() {
        this.timer.stop();
        if (this.isShowing()) {
            this.setVisible(false);
        }
    }

    private boolean stringIsNotEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    private class WindowMover
    implements MouseListener,
    MouseMotionListener {
        private Point start = null;

        private WindowMover() {
        }

        public void mousePressed(MouseEvent e) {
            this.start = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            this.start = null;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.start != null) {
                Point end = e.getPoint();
                Point location = DetailsWindow.this.getLocation();
                DetailsWindow.this.setLocation(location.x + (end.x - this.start.x), location.y + (end.y - this.start.y));
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class WindowResizer
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private boolean horizontal;
        private boolean vertical;
        private Point start = null;
        private int minWidth;

        public WindowResizer(boolean horizontal, boolean vertical) {
            this.horizontal = horizontal;
            this.vertical = vertical;
            if (horizontal && vertical) {
                this.setCursor(Cursor.getPredefinedCursor(6));
            } else if (horizontal) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (vertical) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            }
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(horizontal ? 3 : 0, vertical ? 3 : 0));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void mousePressed(MouseEvent e) {
            this.start = e.getPoint();
            this.minWidth = DetailsWindow.this.titlePanel.isVisible() ? ((DetailsWindow)DetailsWindow.this).titlePanel.getPreferredSize().width + 2 : MIN_WIDTH;
        }

        public void mouseReleased(MouseEvent e) {
            this.start = null;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.start != null) {
                Point end = e.getPoint();
                Dimension size = DetailsWindow.this.getSize();
                int width = Math.max(size.width + (this.horizontal ? end.x - this.start.x : 0), this.minWidth);
                int height = Math.max(size.height + (this.vertical ? end.y - this.start.y : 0), MIN_HEIGHT);
                DetailsWindow.this.setSize(width, height);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

