/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui;

import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityEditor;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityEditorInitiator;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityNode;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupMenu {
    private Action actionLoadFrequency = null;
    private Action actionSaveFrequency = null;
    private Action actionResetFrequency = null;
    private Action actionOpenElement = null;
    private Action actionExpand = null;
    private Action actionDetails = null;
    private JPopupMenu jPopupMenu;
    private ComplexityEditorInitiator complexityEditorInitiator;

    public PopupMenu(ComplexityEditorInitiator complexityEditorInitiator) {
        this.complexityEditorInitiator = complexityEditorInitiator;
    }

    public JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = this.createPopupMenu();
        }
        return this.jPopupMenu;
    }

    public void setActionDetails(Action actionDetails) {
        this.actionDetails = actionDetails;
    }

    public void setActionExpand(Action actionExpand) {
        this.actionExpand = actionExpand;
    }

    public void setActionLoadFrequency(Action actionLoadFrequency) {
        this.actionLoadFrequency = actionLoadFrequency;
    }

    public void setActionOpenElement(Action actionOpenElement) {
        this.actionOpenElement = actionOpenElement;
    }

    public void setActionResetFrequency(Action actionResetFrequency) {
        this.actionResetFrequency = actionResetFrequency;
    }

    public void setActionSaveFrequency(Action actionSaveFrequency) {
        this.actionSaveFrequency = actionSaveFrequency;
    }

    public void setEnabledForDetails(ComplexityNode selectedNode) {
        if (this.actionDetails != null) {
            ComplexityNode programComplexityNode;
            boolean enable = false;
            if (selectedNode != null && (programComplexityNode = ComplexityEditor.findProgramComplexityNodeFor(selectedNode)) != null) {
                enable = programComplexityNode != null && programComplexityNode.getElement() != null;
            }
            this.actionDetails.setEnabled(enable);
        }
    }

    public void setEnabledForExpand(boolean enable) {
        if (this.actionExpand != null) {
            this.actionExpand.setEnabled(enable);
        }
    }

    public void setEnabledForLoadFrequency(boolean enable) {
        if (this.actionLoadFrequency != null) {
            this.actionLoadFrequency.setEnabled(enable);
        }
    }

    public void setEnabledForOpenElement(ComplexityNode selectedNode) {
        if (this.actionOpenElement != null) {
            boolean enable = false;
            if (selectedNode != null && this.complexityEditorInitiator != null && selectedNode.getElement() != null && this.complexityEditorInitiator.canOpenElement(selectedNode.getElement())) {
                enable = true;
            }
            this.actionOpenElement.setEnabled(enable);
        }
    }

    public void setEnabledForResetFrequency(boolean enable) {
        if (this.actionResetFrequency != null) {
            this.actionResetFrequency.setEnabled(enable);
        }
    }

    public void setEnabledForSaveFrequency(boolean enable) {
        if (this.actionSaveFrequency != null) {
            this.actionSaveFrequency.setEnabled(enable);
        }
    }

    private JPopupMenu createPopupMenu() {
        this.jPopupMenu = new JPopupMenu();
        if (this.actionExpand != null) {
            this.jPopupMenu.add(new JMenuItem(this.actionExpand));
        }
        if (this.actionDetails != null) {
            this.jPopupMenu.add(new JMenuItem(this.actionDetails));
        }
        if (this.actionOpenElement != null) {
            this.jPopupMenu.add(new JMenuItem(this.actionOpenElement));
        }
        if (this.actionResetFrequency != null) {
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(new JMenuItem(this.actionResetFrequency));
        }
        if (this.actionLoadFrequency != null) {
            this.jPopupMenu.add(new JMenuItem(this.actionLoadFrequency));
        }
        if (this.actionSaveFrequency != null) {
            this.jPopupMenu.add(new JMenuItem(this.actionSaveFrequency));
        }
        return this.jPopupMenu;
    }
}

