/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui.datastructure;

import de.statspez.pleditor.generator.codegen.analysis.complexity.datastructure.deleted.DatastructureComplexityResolver;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.datastructure.DatastructureComplexityNode;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DatastructureComplexityNodeBuilder
extends AbstractElementVisitor {
    private static final Icon ICON_MERKMAL;
    private static final Icon ICON_PLAUSI;
    private static final Icon ICON_TB_FELD;
    private static final Icon ICON_TB_FELD_STR;
    private static final Icon ICON_THEMENBEREICH;
    private static final Icon ICON_PLMATERIAL;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_MERKMAL = new ImageIcon(clazz.getResource("/de/statspez/pleditor/generator/images/merkmal.gif"));
        ICON_PLAUSI = null;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_TB_FELD = new ImageIcon(clazz2.getResource("/de/statspez/pleditor/generator/images/tbfeld.gif"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_TB_FELD_STR = new ImageIcon(clazz3.getResource("/de/statspez/pleditor/generator/images/subthemenbereich.gif"));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_THEMENBEREICH = new ImageIcon(clazz4.getResource("/de/statspez/pleditor/generator/images/themenbereich.gif"));
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_PLMATERIAL = new ImageIcon(clazz5.getResource("/de/statspez/pleditor/generator/images/material.gif"));
    }

    public DatastructureComplexityNode build(MetaCustomPlausibilisierung plausi) {
        Resolver resolver = new Resolver();
        resolver.setRootThemenbereich((MetaCustomThemenbereich)plausi.rootThemenbereich());
        plausi.accept(resolver);
        return resolver.rootNode;
    }

    private class Resolver
    extends AbstractElementVisitor {
        private DatastructureComplexityNode rootNode;
        private MetaCustomThemenbereich rootThemenbereich;
        private Stack currentNode;

        private Resolver() {
        }

        public void setRootThemenbereich(MetaCustomThemenbereich rootThemenbereich) {
            this.rootThemenbereich = rootThemenbereich;
        }

        public void visitPlausibilisierung(MetaPlausibilisierung anObject) {
            this.rootNode = new DatastructureComplexityNode(null, anObject, anObject.getPLName(), ICON_PLAUSI, false);
            this.currentNode = new Stack();
            this.currentNode.push(this.rootNode);
            DatastructureComplexityNode merkmaleNode = new DatastructureComplexityNode((DatastructureComplexityNode)this.currentNode.peek(), null, "Merkmale", null, false);
            this.currentNode.push(merkmaleNode);
            this.visitElements(anObject.getMerkmale());
            this.currentNode.pop();
            DatastructureComplexityNode tbsNode = new DatastructureComplexityNode((DatastructureComplexityNode)this.currentNode.peek(), null, "Themenbereiche", null, false);
            this.currentNode.push(tbsNode);
            this.visitElements(anObject.getThemenbereiche());
            this.currentNode.pop();
            DatastructureComplexityNode refmatNode = new DatastructureComplexityNode((DatastructureComplexityNode)this.currentNode.peek(), null, "Materialbeschreibungen", null, false);
            this.currentNode.push(refmatNode);
            this.visitElements(anObject.getPLMaterialien());
            this.currentNode.pop();
        }

        public void visitMerkmal(MetaMerkmal anObject) {
            DatastructureComplexityNode parent = (DatastructureComplexityNode)this.currentNode.peek();
            DatastructureComplexityNode tbNode = new DatastructureComplexityNode(parent, anObject, anObject.getName(), ICON_MERKMAL, false);
            this.currentNode.push(tbNode);
            this.currentNode.pop();
        }

        public void visitThemenbereich(MetaThemenbereich anObject) {
            DatastructureComplexityNode parent = (DatastructureComplexityNode)this.currentNode.peek();
            DatastructureComplexityNode tbNode = new DatastructureComplexityNode((DatastructureComplexityNode)this.currentNode.peek(), anObject, anObject.getName(), ICON_THEMENBEREICH, false);
            this.currentNode.push(tbNode);
            if (anObject == this.rootThemenbereich) {
                tbNode.setRootTB(true);
            }
            if (parent.getElement() == null) {
                this.visitElements(anObject.getFelder());
            }
            this.currentNode.pop();
        }

        public void visitTBFeld(MetaTBFeld anObject) {
            MetaCustomTBFeld metaCustomTBFeld = (MetaCustomTBFeld)anObject;
            Icon icon = anObject.getKlasse() instanceof MetaMerkmal ? ICON_TB_FELD : ICON_TB_FELD_STR;
            boolean frequencyEnabled = anObject.getListe() && DatastructureComplexityResolver.isNDimensional(metaCustomTBFeld.dimensions());
            DatastructureComplexityNode tbFeldNode = new DatastructureComplexityNode((DatastructureComplexityNode)this.currentNode.peek(), anObject, anObject.getName(), icon, frequencyEnabled);
            this.currentNode.push(tbFeldNode);
            anObject.getKlasse().accept(this);
            this.currentNode.pop();
        }

        public void visitPLMaterial(MetaPLMaterial anObject) {
            boolean isErhebung;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("de.statspez.pleditor.generator.meta.MetaCustomPLMaterial");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            boolean bl = isErhebung = clazz.isAssignableFrom(anObject.getClass()) && ((MetaCustomPLMaterial)anObject).istErhebung();
            if (!isErhebung) {
                DatastructureComplexityNode tbNode = new DatastructureComplexityNode((DatastructureComplexityNode)this.currentNode.peek(), anObject, anObject.getName(), ICON_PLMATERIAL, false);
                this.currentNode.push(tbNode);
                anObject.getThemenbereich().accept(this);
                this.currentNode.pop();
            }
        }
    }
}

