/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.AblaufStat;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.codegen.doku.FeldStat;
import de.statspez.pleditor.generator.codegen.doku.FunktionStat;
import de.statspez.pleditor.generator.codegen.doku.KommentarStat;
import de.statspez.pleditor.generator.codegen.doku.MerkmalStat;
import de.statspez.pleditor.generator.codegen.doku.PlausiDokuGenerator;
import de.statspez.pleditor.generator.codegen.doku.PruefungStat;
import de.statspez.pleditor.generator.codegen.doku.TbStat;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;
import java.util.Stack;

public class ThemenbereichDokuGenerator
extends PlausiDokuGenerator {
    private MerkmalStat merkmalStat = null;
    private PruefungStat pruefungStat = null;
    private KommentarStat kommentarStat = null;
    private AblaufStat ablaufStat = null;
    private TbStat tbStat = null;
    private FeldStat feldStat = null;
    private FunktionStat funktionStat = null;
    private Stack nameSpace = new Stack();

    public synchronized void generate(MetaThemenbereich aTb) throws CodegenException {
        this.nameSpace.push(aTb.getName());
        aTb.accept(this);
        this.nameSpace.pop();
        this.checkForErrors();
        this.out.flush();
    }

    public void visitThemenbereich(MetaThemenbereich tb) {
        this.tbStat.add(tb);
        this.kommentarStat.addToTopicAnnotations(tb);
        System.out.println("### verarbeite die Felder des Themenbereichs " + tb.getName());
        this.visitElements(tb.getFelder());
        System.out.println("### verarbeite die Pruefungen des Themenbereichs " + tb.getName());
        this.visitElements(tb.getPruefungen());
        System.out.println("### verarbeite die Ablauefe des Themenbereichs " + tb.getName());
        this.visitElements(tb.getAblaeufe());
        System.out.println("### verarbeite die Funktionen des Themenbereichs " + tb.getName());
        this.visitElements(tb.getFunktionen());
    }

    public void visitTBFeld(MetaTBFeld aFeld) {
        this.feldStat.add(aFeld);
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        String feldKontext = String.valueOf(feld.getThemenbereich().getId()) + "." + feld.getName();
        if (feld.getKlasse() instanceof MetaMerkmal) {
            this.merkmalStat.addReference(feld);
            this.feldStat.addKontext(feld.getId(), String.valueOf(this.currentNamespace()) + "." + feld.getName());
        } else if (feld.getKlasse() instanceof MetaThemenbereich) {
            this.feldStat.putToFeldTbHash(feldKontext, feld.getKlasse().getId());
            DokuElement fde = this.feldStat.getElement(feld.getId());
            this.nameSpace.push(fde.getName());
            feld.getKlasse().accept(this);
            this.nameSpace.pop();
        } else if (feld.getKlasse() == null) {
            this.warning(aFeld, "Das Feld " + feld.getName() + " ist leer.");
        } else {
            this.error(aFeld, "Das Feld " + feld.getName() + " hat eine ungueltige Feld-Klasse (" + aFeld.getKlasse() + ")");
        }
        this.kommentarStat.addToFieldAnnotations(feld);
    }

    public void visitPLPruefung(MetaPLPruefung aPruefung) {
        MetaCustomPruefung pruefung = (MetaCustomPruefung)aPruefung;
        this.pruefungStat.add(pruefung);
        this.kommentarStat.addToCheckAnnotations(pruefung);
    }

    public void visitPLAblauf(MetaPLAblauf ablauf) {
        MetaCustomAblauf a = (MetaCustomAblauf)ablauf;
        System.out.println("### visitPLAblauf " + a.getThemenbereich().getName() + "." + a.getName());
        this.ablaufStat.add(a);
        this.kommentarStat.addToFlowAnnotations(a);
    }

    public void visitPLFunktion(MetaPLFunktion funktion) {
        MetaCustomFunktion f = (MetaCustomFunktion)funktion;
        this.funktionStat.add(f);
        this.kommentarStat.addToFunctionAnnotations(f);
    }

    public void setMerkmalStat(MerkmalStat stat) {
        this.merkmalStat = stat;
    }

    public void setPruefungStat(PruefungStat stat) {
        this.pruefungStat = stat;
    }

    public void setKommentarStat(KommentarStat stat) {
        this.kommentarStat = stat;
    }

    public void setAblaufStat(AblaufStat stat) {
        this.ablaufStat = stat;
    }

    public void setTbStat(TbStat stat) {
        this.tbStat = stat;
    }

    public void setFeldStat(FeldStat stat) {
        this.feldStat = stat;
    }

    public void setFunktionStat(FunktionStat stat) {
        this.funktionStat = stat;
    }

    private String currentNamespace() {
        String result = "";
        Iterator it = this.nameSpace.iterator();
        if (it.hasNext()) {
            result = (String)it.next();
        }
        while (it.hasNext()) {
            result = String.valueOf(result) + "." + (String)it.next();
        }
        return result;
    }
}

