/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.pl;

import de.statspez.pleditor.generator.codegen.pl.HierarchicalCodegenContext;
import de.statspez.pleditor.generator.codegen.pl.HierarchicalStructureConverter;
import de.statspez.pleditor.generator.codegen.pl.PrettyPrinter;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaContextOperator;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalOperator;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaSetStatement;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaSizeTestingOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class HierarchicalCodeConverter
extends PrettyPrinter {
    private HierarchicalCodeConverter superConverter;
    private HierarchicalStructureConverter structureConverter;
    private String namespace;
    private boolean nextElementInGlobalNamespace;
    private Stack localVariableStack;
    private boolean withinStructureAccess;
    private HierarchicalCodegenContext context;

    public HierarchicalCodeConverter() {
        this(null, "");
    }

    protected HierarchicalCodeConverter(HierarchicalCodeConverter superConverter, String namespace) {
        this.superConverter = superConverter;
        this.structureConverter = new HierarchicalStructureConverter(this);
        this.namespace = namespace;
        this.nextElementInGlobalNamespace = false;
        this.withinStructureAccess = false;
        if (this.superConverter != null) {
            this.localVariableStack = superConverter.getLocalVariableStack();
            this.setIndentLevel(this.superConverter.indentLevel());
            this.context = superConverter.getContext();
        } else {
            this.localVariableStack = new Stack();
            this.startNewLocalVariableScope();
            this.context = new HierarchicalCodegenContext();
        }
    }

    protected HierarchicalCodegenContext getContext() {
        return this.context;
    }

    public String getNextGeneratedVariable() {
        return this.context.getNextGeneratedVariable();
    }

    protected String getNamespace() {
        return this.namespace;
    }

    protected void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected void appendNamespace(String subNamespace) {
        if (subNamespace != null && subNamespace.length() > 0) {
            if (this.namespace.length() > 0) {
                this.namespace = String.valueOf(this.namespace) + ".";
            }
            this.namespace = String.valueOf(this.namespace) + subNamespace;
        }
    }

    protected HierarchicalCodeConverter getSuperConverter() {
        return this.superConverter;
    }

    protected void superIndent() {
        this.superConverter.indent();
    }

    protected void superIncreaseIndentLevel() {
        this.superConverter.increaseIndentLevel();
    }

    protected void superDecreaseIndentLevel() {
        this.superConverter.decreaseIndentLevel();
    }

    protected void superNewLine() {
        this.superConverter.newLine();
    }

    protected void superIndentNewLine() {
        this.superConverter.indentNewLine();
    }

    protected void superPrint(String text) {
        this.superConverter.out.print(text);
    }

    protected void printNamespace(boolean appendStructureSeparator) {
        if (!this.nextElementInGlobalNamespace) {
            if (!this.withinStructureAccess && this.namespace.length() > 0) {
                this.print(this.namespace);
                if (appendStructureSeparator) {
                    this.print(".");
                }
            }
        } else {
            this.nextElementInGlobalNamespace = false;
        }
    }

    protected Stack getLocalVariableStack() {
        return this.localVariableStack;
    }

    protected boolean isDefinedInGlobalNamespace(String identifier) {
        if (this.withinStructureAccess) {
            return false;
        }
        int i = 0;
        while (i < this.localVariableStack.size()) {
            Vector localVariables = (Vector)this.localVariableStack.get(i);
            if (localVariables.contains(identifier)) {
                return true;
            }
            ++i;
        }
        return InternalFunctions.instance().isInternalFunction(identifier);
    }

    protected void printIndex(MetaFactor index) {
        boolean prevWithinStructureAccess = this.withinStructureAccess;
        this.withinStructureAccess = false;
        super.printIndex(index);
        this.withinStructureAccess = prevWithinStructureAccess;
    }

    private void startNewLocalVariableScope() {
        this.localVariableStack.push(new Vector());
    }

    private void closeLocalVariableScope() {
        this.localVariableStack.pop();
    }

    private void addLocalVariable(String identifier) {
        ((Vector)this.localVariableStack.peek()).add(identifier);
    }

    private void convertIdenticalOperator(MetaFactor operand) {
        HierarchicalStructureConverter secondStructureConverter = new HierarchicalStructureConverter(this);
        String varName = this.getNextGeneratedVariable();
        String varNameFound = this.getNextGeneratedVariable();
        this.superIndent();
        this.superPrint("VAR ");
        this.superPrint(varName);
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := 0");
        this.superNewLine();
        this.structureConverter.enterStructure(operand);
        this.superIndent();
        this.superPrint("VAR ");
        this.superPrint(varNameFound);
        this.superIndentNewLine();
        this.superPrint(varNameFound);
        this.superPrint(" := FALSCH");
        this.superNewLine();
        secondStructureConverter.enterStructure(operand);
        this.superIndent();
        this.superPrint("WENN ");
        if (this.structureConverter.getIndexVariablesCount() > 0) {
            this.superPrint("(");
            int i = 0;
            while (i < this.structureConverter.getIndexVariablesCount()) {
                if (this.structureConverter.getIndexVariablesCount() > 1) {
                    this.superPrint("(");
                }
                this.superPrint(this.structureConverter.getIndexVariable(i));
                this.superPrint(" /= ");
                this.superPrint(secondStructureConverter.getIndexVariable(i));
                if (this.structureConverter.getIndexVariablesCount() > 1) {
                    this.superPrint(")");
                }
                if (i < this.structureConverter.getIndexVariablesCount() - 1) {
                    this.superPrint(" ODER ");
                }
                ++i;
            }
            this.superPrint(") UND (");
        }
        this.superPrint(this.structureConverter.getStructureField());
        this.superPrint(" = ");
        this.superPrint(secondStructureConverter.getStructureField());
        if (this.structureConverter.getIndexVariablesCount() > 0) {
            this.superPrint(")");
        }
        this.superPrint(" DANN");
        this.superIncreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint(varNameFound);
        this.superPrint(" := WAHR");
        this.superIndentNewLine();
        this.superPrint("ABBRUCH");
        this.superDecreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint("ENDE");
        this.superNewLine();
        secondStructureConverter.leaveStructure(operand);
        this.superIndent();
        this.superPrint("WENN ");
        this.superPrint(varNameFound);
        this.superPrint(" DANN");
        this.superIncreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := ");
        this.superPrint(varName);
        this.superPrint(" + 1");
        this.superDecreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint("ENDE");
        this.superNewLine();
        this.structureConverter.leaveStructure(operand);
        this.print(varName);
    }

    private void convertMinOperator(MetaFactor operand) {
        String varName = this.getNextGeneratedVariable();
        this.superIndent();
        this.superPrint("VAR ");
        this.superPrint(varName);
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := LEER");
        this.superNewLine();
        this.structureConverter.enterStructure(operand);
        this.superIndent();
        this.superPrint("WENN (");
        this.superPrint(varName);
        this.superPrint(" = LEER) ODER (");
        this.superPrint(varName);
        this.superPrint(" > ");
        this.superPrint(this.structureConverter.getStructureField());
        this.superPrint(") DANN");
        this.superIncreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := ");
        this.superPrint(this.structureConverter.getStructureField());
        this.superDecreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint("ENDE");
        this.superNewLine();
        this.structureConverter.leaveStructure(operand);
        this.print(varName);
    }

    private void convertMaxOperator(MetaFactor operand) {
        String varName = this.getNextGeneratedVariable();
        this.superIndent();
        this.superPrint("VAR ");
        this.superPrint(varName);
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := LEER");
        this.superNewLine();
        this.structureConverter.enterStructure(operand);
        this.superIndent();
        this.superPrint("WENN (");
        this.superPrint(varName);
        this.superPrint(" = LEER) ODER (");
        this.superPrint(varName);
        this.superPrint(" < ");
        this.superPrint(this.structureConverter.getStructureField());
        this.superPrint(") DANN");
        this.superIncreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := ");
        this.superPrint(this.structureConverter.getStructureField());
        this.superDecreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint("ENDE");
        this.superNewLine();
        this.structureConverter.leaveStructure(operand);
        this.print(varName);
    }

    private void convertSumOperator(MetaFactor operand) {
        String varName = this.getNextGeneratedVariable();
        this.superIndent();
        this.superPrint("VAR ");
        this.superPrint(varName);
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := LEER");
        this.superNewLine();
        this.structureConverter.enterStructure(operand);
        this.superIndent();
        this.superPrint(varName);
        this.superPrint(" := ");
        this.superPrint(varName);
        this.superPrint(" + ");
        this.superPrint(this.structureConverter.getStructureField());
        this.superNewLine();
        this.structureConverter.leaveStructure(operand);
        this.print(varName);
    }

    private void convertMeanOperator(MetaFactor operand) {
        String varName = this.getNextGeneratedVariable();
        this.convertMeanOperator(operand, varName);
        this.print(varName);
    }

    private void convertMeanOperator(MetaFactor operand, String varName) {
        String varNameOfSum = this.getNextGeneratedVariable();
        String varNameOfSize = this.getNextGeneratedVariable();
        this.superIndent();
        this.superPrint("VAR ");
        this.superPrint(varName);
        this.superPrint(", ");
        this.superPrint(varNameOfSum);
        this.superPrint(", ");
        this.superPrint(varNameOfSize);
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := LEER");
        this.superIndentNewLine();
        this.superPrint(varNameOfSum);
        this.superPrint(" := LEER");
        this.superIndentNewLine();
        this.superPrint(varNameOfSize);
        this.superPrint(" := 0");
        this.superNewLine();
        this.structureConverter.enterStructure(operand);
        this.superIndent();
        this.superPrint(varNameOfSum);
        this.superPrint(" := ");
        this.superPrint(varNameOfSum);
        this.superPrint(" + ");
        this.superPrint(this.structureConverter.getStructureField());
        this.superIndentNewLine();
        this.superPrint(varNameOfSize);
        this.superPrint(" := ");
        this.superPrint(varNameOfSize);
        this.superPrint(" + 1");
        this.superNewLine();
        this.structureConverter.leaveStructure(operand);
        this.superIndent();
        this.superPrint("WENN ");
        this.superPrint(varNameOfSize);
        this.superPrint(" > 0 DANN");
        this.superIncreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := ");
        this.superPrint(varNameOfSum);
        this.superPrint(" / ");
        this.superPrint(varNameOfSize);
        this.superDecreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint("ENDE");
        this.superNewLine();
    }

    private void convertMedianOperator(MetaFactor operand) {
    }

    private void convertVarianceOperator(MetaFactor operand) {
        String varName = this.getNextGeneratedVariable();
        this.convertVarianceOperator(operand, varName);
        this.print(varName);
    }

    private void convertVarianceOperator(MetaFactor operand, String varName) {
        String varNameOfMean = this.getNextGeneratedVariable();
        String varNameOfSum = this.getNextGeneratedVariable();
        String varNameOfSize = this.getNextGeneratedVariable();
        this.convertMeanOperator(operand, varNameOfMean);
        this.superIndent();
        this.superPrint("VAR ");
        this.superPrint(varName);
        this.superPrint(", ");
        this.superPrint(varNameOfSum);
        this.superPrint(", ");
        this.superPrint(varNameOfSize);
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := LEER");
        this.superIndentNewLine();
        this.superPrint(varNameOfSum);
        this.superPrint(" := LEER");
        this.superIndentNewLine();
        this.superPrint(varNameOfSize);
        this.superPrint(" := 0");
        this.superNewLine();
        this.structureConverter.enterStructure(operand);
        this.superIndent();
        this.superPrint(varNameOfSum);
        this.superPrint(" := ");
        this.superPrint(varNameOfSum);
        this.superPrint(" + FUNKTION EXPONENT(");
        this.superPrint(this.structureConverter.getStructureField());
        this.superPrint(" - ");
        this.superPrint(varNameOfMean);
        this.superPrint(", 2)");
        this.superIndentNewLine();
        this.superPrint(varNameOfSize);
        this.superPrint(" := ");
        this.superPrint(varNameOfSize);
        this.superPrint(" + 1");
        this.superNewLine();
        this.structureConverter.leaveStructure(operand);
        this.superIndent();
        this.superPrint("WENN ");
        this.superPrint(varNameOfSize);
        this.superPrint(" > 0 DANN");
        this.superIncreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint(varName);
        this.superPrint(" := ");
        this.superPrint(varNameOfSum);
        this.superPrint(" / ");
        this.superPrint(varNameOfSize);
        this.superDecreaseIndentLevel();
        this.superIndentNewLine();
        this.superPrint("ENDE");
        this.superNewLine();
    }

    private void convertDevationOperator(MetaFactor operand) {
        String varNameOfVariance = this.getNextGeneratedVariable();
        this.convertVarianceOperator(operand, varNameOfVariance);
        this.print("FUNKTION EXPONENT(");
        this.print(varNameOfVariance);
        this.print(", 0.5)");
    }

    public void visitStatementSequence(MetaStatementSequence aSequence) {
        Iterator iter = aSequence.statements();
        while (iter != null && iter.hasNext()) {
            this.indent();
            HierarchicalCodeConverter subConverter = new HierarchicalCodeConverter(this, this.getNamespace());
            this.print(subConverter.generate((MetaElement)iter.next()));
            if (!iter.hasNext()) continue;
            this.newLine();
        }
    }

    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        Iterator iter = aDeclaration.identifiers();
        while (iter.hasNext()) {
            MetaIdentifier identifier = (MetaIdentifier)iter.next();
            this.addLocalVariable(identifier.value());
        }
        super.visitVarDeclaration(aDeclaration);
    }

    public void visitAblaufStatement(MetaAblaufStatement aStatement) {
        boolean wasWithinStructureAccess = this.withinStructureAccess;
        if (aStatement.function().adaptedObject() instanceof MetaStructureAccess) {
            MetaStructureAccess structureAccess = (MetaStructureAccess)aStatement.function().adaptedObject();
            this.print("THEMENBEREICH ");
            structureAccess.structureAccess().accept(this);
            this.print(" MIT ABLAUF ");
            this.withinStructureAccess = true;
            structureAccess.selectedElement().accept(this);
        } else {
            if (!this.nextElementInGlobalNamespace && this.namespace.length() > 0) {
                this.print("THEMENBEREICH ");
                this.printNamespace(false);
                this.print(" MIT ");
            }
            this.print("ABLAUF ");
            this.withinStructureAccess = true;
            aStatement.function().accept(this);
        }
        this.withinStructureAccess = wasWithinStructureAccess;
        this.printParameter(aStatement.parameters());
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        this.startNewLocalVariableScope();
        super.visitConditionalStatement(aStatement);
        this.closeLocalVariableScope();
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        this.startNewLocalVariableScope();
        super.visitForNextLoop(aStatement);
        this.closeLocalVariableScope();
    }

    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.startNewLocalVariableScope();
        super.visitForEachLoop(aStatement);
        this.closeLocalVariableScope();
    }

    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        this.startNewLocalVariableScope();
        this.structureConverter.enterStructure(aStatement.value());
        String currentSuperNamespace = this.superConverter.getNamespace();
        this.superConverter.appendNamespace(this.structureConverter.getStructureField());
        aStatement.loopBody().accept(this.superConverter);
        this.superNewLine();
        this.superConverter.setNamespace(currentSuperNamespace);
        this.structureConverter.leaveStructure(aStatement.value());
        this.closeLocalVariableScope();
    }

    public void visitSetStatement(MetaSetStatement aSetStatemnt) {
        if (CodegenUtil.containsHierarchicalCode(aSetStatemnt.getFactor())) {
            this.structureConverter.enterStructure(aSetStatemnt.getFactor());
            this.superIndent();
            if (aSetStatemnt.getType() == MetaSetStatement.DELETE) {
                this.superPrint("SATZ LOESCHEN ");
            } else {
                this.superPrint("SATZ ANANLEGEN ");
            }
            this.superPrint(this.structureConverter.getStructureField());
            int lastIndex = this.structureConverter.getIndexVariablesCount() - 1;
            if (this.structureConverter.isForNextLoop(lastIndex)) {
                this.superNewLine();
                this.superIndent();
                this.superPrint(this.structureConverter.getIndexVariable(lastIndex));
                this.superPrint(" := ");
                this.superPrint(this.structureConverter.getIndexVariable(lastIndex));
                this.superPrint(" - 1");
            }
            this.superNewLine();
            this.structureConverter.leaveStructure(aSetStatemnt.getFactor());
        } else {
            super.visitSetStatement(aSetStatemnt);
        }
    }

    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        if (CodegenUtil.containsHierarchicalCode(anOperator.operand())) {
            String varName = this.getNextGeneratedVariable();
            this.superIndent();
            this.superPrint("VAR ");
            this.superPrint(varName);
            this.superIndentNewLine();
            this.superPrint(varName);
            this.superPrint(" := 0");
            this.superNewLine();
            this.structureConverter.enterStructure(anOperator.operand());
            this.superIndent();
            this.superPrint(varName);
            this.superPrint(" := ");
            this.superPrint(varName);
            this.superPrint(" + 1");
            this.superNewLine();
            this.structureConverter.leaveStructure(anOperator.operand());
            this.print(varName);
        } else {
            super.visitSizeOfOperator(anOperator);
        }
    }

    public void visitSizeTestingOperator(MetaSizeTestingOperator anOperator) {
        if (CodegenUtil.containsHierarchicalCode(anOperator.secondOperand())) {
            String varName = this.getNextGeneratedVariable();
            String varNameToCompare = this.getNextGeneratedVariable();
            this.superIndent();
            this.superPrint("VAR ");
            this.superPrint(varName);
            this.superPrint(", ");
            this.superPrint(varNameToCompare);
            this.superIndentNewLine();
            this.superPrint(varName);
            this.superPrint(" := 0");
            this.superIndentNewLine();
            this.superPrint(varNameToCompare);
            this.superPrint(" := ");
            anOperator.firstOperand().accept(this.superConverter);
            this.superNewLine();
            this.structureConverter.enterStructure(anOperator.secondOperand());
            this.superIndent();
            this.superPrint(varName);
            this.superPrint(" := ");
            this.superPrint(varName);
            this.superPrint(" + 1");
            this.superIndentNewLine();
            this.superPrint("WENN ");
            this.superPrint(varName);
            this.superPrint(" >");
            if (anOperator.type() == 1) {
                this.superPrint("=");
            }
            this.superPrint(" ");
            this.superPrint(varNameToCompare);
            this.superPrint(" DANN");
            this.superIncreaseIndentLevel();
            this.superIndentNewLine();
            this.superPrint("ABBRUCH");
            this.superDecreaseIndentLevel();
            this.superIndentNewLine();
            this.superPrint("ENDE");
            this.superNewLine();
            this.structureConverter.leaveStructure(anOperator.secondOperand());
            this.print(varName);
            this.print(" ");
            switch (anOperator.type()) {
                case 1: {
                    this.print(">=");
                    break;
                }
                case 2: {
                    this.print("=");
                    break;
                }
                case 3: {
                    this.print("<=");
                }
            }
            this.print(" ");
            this.print(varNameToCompare);
        } else {
            this.print("ANZAHL VON ");
            anOperator.secondOperand().accept(this);
            this.print(" ");
            switch (anOperator.type()) {
                case 1: {
                    this.print(">=");
                    break;
                }
                case 2: {
                    this.print("=");
                    break;
                }
                case 3: {
                    this.print("<=");
                }
            }
            this.print(" ");
            anOperator.firstOperand().accept(this);
        }
    }

    public void visitHierarchicalOperator(MetaHierarchicalOperator anOperator) {
        switch (anOperator.type()) {
            case 1: {
                this.convertIdenticalOperator(anOperator.operand());
                break;
            }
            case 2: {
                this.convertMinOperator(anOperator.operand());
                break;
            }
            case 3: {
                this.convertMaxOperator(anOperator.operand());
                break;
            }
            case 4: {
                this.convertSumOperator(anOperator.operand());
                break;
            }
            case 5: {
                this.convertMeanOperator(anOperator.operand());
                break;
            }
            case 6: {
                this.convertMedianOperator(anOperator.operand());
                break;
            }
            case 7: {
                this.convertVarianceOperator(anOperator.operand());
                break;
            }
            case 8: {
                this.convertDevationOperator(anOperator.operand());
            }
        }
    }

    public void visitContextOperator(MetaContextOperator anOperator) {
        this.nextElementInGlobalNamespace = true;
        anOperator.operand().accept(this);
    }

    public void visitClassificationReference(MetaClassificationReference aReference) {
        this.nextElementInGlobalNamespace = true;
        super.visitClassificationReference(aReference);
    }

    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        this.print("MATERIAL ");
        this.nextElementInGlobalNamespace = true;
        anAccess.material().accept(this);
        this.print("(");
        Iterator iter = anAccess.selectionConditions();
        while (iter != null && iter.hasNext()) {
            MetaTestingOperator testingOperator = (MetaTestingOperator)iter.next();
            this.nextElementInGlobalNamespace = true;
            this.printFactor(testingOperator.firstOperand());
            this.printTestingOperator(testingOperator.type());
            this.printFactor(testingOperator.secondOperand());
            if (iter.hasNext()) {
                this.print(", ");
                continue;
            }
            this.print("; ");
        }
        iter = anAccess.selectedFields();
        while (iter != null && iter.hasNext()) {
            this.nextElementInGlobalNamespace = true;
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(")");
    }

    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        this.printNamespace(true);
        boolean wasWithinStructureAccess = this.withinStructureAccess;
        this.withinStructureAccess = true;
        super.visitStructureAccess(aStructureAccess);
        this.withinStructureAccess = wasWithinStructureAccess;
    }

    public void visitIdentifier(MetaIdentifier anIdentifier) {
        if (!this.isDefinedInGlobalNamespace(anIdentifier.value())) {
            this.printNamespace(true);
        }
        super.visitIdentifier(anIdentifier);
    }
}

