/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import java.util.Stack;

public class StructureTraverser
extends AbstractElementVisitor {
    private MetaStructureAccess structureAccess;
    private Stack traverseStack;

    public StructureTraverser(MetaStructureAccess structureAccess) {
        this.structureAccess = structureAccess;
        this.traverseStack = new Stack();
    }

    public void eachElement(CodeBlock code) {
        this.structureAccess.accept(this);
        while (this.traverseStack.size() > 1) {
            code.doForStructureElement((MetaValueAccess)this.traverseStack.pop());
        }
        code.doForLastStructureElement((MetaValueAccess)this.traverseStack.pop());
    }

    public void visitFieldAccess(MetaFieldAccess anAccess) {
        this.traverseStack.push(anAccess);
    }

    public void visitArrayAccess(MetaArrayAccess anAccess) {
        this.traverseStack.push(anAccess);
    }

    public void visitStructureAccess(MetaStructureAccess anAccess) {
        anAccess.selectedElement().accept(this);
        anAccess.structureAccess().accept(this);
    }

    public static interface CodeBlock {
        public void doForStructureElement(MetaValueAccess var1);

        public void doForLastStructureElement(MetaValueAccess var1);
    }
}

