/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaRawField;
import de.statspez.pleditor.generator.meta.generated.MetaRawSet;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.RawFieldGroupParser;
import de.statspez.pleditor.generator.parser.RawFieldParser;
import de.statspez.pleditor.generator.parser.RawSetParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RawDataSetParser
extends SubParser
implements SuperParser {
    private MetaRawDataSet currentDsb = null;
    private ParserChain parserChain = new ParserChain();
    private RawFieldGroupParser grParser;
    private RawFieldParser feldParser = null;
    private RawSetParser rawSetParser = null;

    public RawDataSetParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.grParser = new RawFieldGroupParser(this, resolver);
        this.parserChain.addParser(this.grParser);
        this.feldParser = new RawFieldParser(this, resolver);
        this.parserChain.addParser(this.feldParser);
        this.rawSetParser = new RawSetParser(this, resolver);
        this.parserChain.addParser(this.rawSetParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "rawDataSet".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("rawDataSet".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentDsb = new MetaRawDataSet();
            this.handleAttributes(namespaceURI, localName, qName, atts);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("rawDataSet".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentDsb;
    }

    public void notifyObjectStarted(SubParser aParser) {
        if (aParser == this.feldParser) {
            this.grParser.disallow();
            this.rawSetParser.disallow();
        } else if (aParser == this.grParser) {
            this.feldParser.disallow();
            this.rawSetParser.disallow();
        } else if (aParser == this.rawSetParser) {
            this.feldParser.disallow();
            this.grParser.disallow();
        }
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.feldParser) {
            this.currentDsb.addToListOfRawField((MetaRawField)aParser.object());
            this.grParser.allow();
            this.rawSetParser.allow();
        } else if (aParser == this.grParser) {
            this.currentDsb.addToListOfRawField((MetaRawField)aParser.object());
            this.feldParser.allow();
            this.rawSetParser.allow();
        } else if (aParser == this.rawSetParser) {
            this.currentDsb.addToListOfRawSet((MetaRawSet)aParser.object());
            this.feldParser.allow();
            this.grParser.allow();
        }
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("rawDataSet".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer die Datensatzbeschreibung ist kein Name definiert!");
            }
            this.currentDsb.setName(name.trim());
            String str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentDsb.setId(str.trim());
            } else {
                this.currentDsb.setId(name);
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = false;
        String chars = this.superParser().charData().toString().trim();
        return handled;
    }

    private void setDsbOfSubParsers(MetaDsbObjekt _dsb) {
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "rawDataSet".equalsIgnoreCase(tag);
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

