/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.refdat.csv;

import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.MaterialDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzFilter;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import de.statspez.pleditor.generator.runtime.refdat.AbstractReferenzDateiZugriff;
import de.statspez.pleditor.generator.runtime.refdat.csv.EinfacherEFSatz;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class CSVReferenzDateiVerwaltung
extends AbstractReferenzDateiZugriff {
    public static final String PATH_SEP = "/";
    public static final String DEFAULT_REFDAT_FILE_EXTENSION = ".refdat";
    public static final String DEFAULT_CSV_SPLIT_STRING = ";";
    public static final String DEFAULT_RES_PATH = "/";
    protected String resourcePath = "/";
    protected String refdatFileExtension = ".refdat";
    protected String csvSplitString = ";";
    protected HashMap referenzDateiHashMap = new HashMap();
    protected HashMap referenzDateiFeldwerteHashMap = new HashMap();

    public CSVReferenzDateiVerwaltung() {
    }

    public CSVReferenzDateiVerwaltung(String resourcePath) {
        this();
        this.resourcePath = resourcePath;
        if (this.resourcePath == null || this.resourcePath.length() == 0) {
            this.resourcePath = "/";
        } else if (!this.resourcePath.endsWith("/")) {
            this.resourcePath = String.valueOf(this.resourcePath) + "/";
        }
    }

    public String getCsvSplitString() {
        return this.csvSplitString;
    }

    public void setCsvSplitString(String csvSplitString) {
        this.csvSplitString = csvSplitString;
    }

    public String getRefdatFileExtension() {
        return this.refdatFileExtension;
    }

    public void setRefdatFileExtension(String refdatFileExtension) {
        this.refdatFileExtension = refdatFileExtension;
    }

    public boolean liefertDenZugriffAuf(MaterialDeskriptorInterface material) {
        boolean erg = false;
        try {
            Vector referenzDatei = this.getReferenzDatei(material);
            if (referenzDatei != null) {
                erg = true;
            }
        }
        catch (Exception e) {
            erg = false;
        }
        return erg;
    }

    private Vector getReferenzDatei(MaterialDeskriptorInterface material) throws NoSuchFieldException {
        Vector<EinfacherEFSatz> referenzDatei = (Vector<EinfacherEFSatz>)this.referenzDateiHashMap.get(this.getMaterialBezeichner(material));
        if (referenzDatei == null) {
            referenzDatei = new Vector<EinfacherEFSatz>();
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(String.valueOf(this.resourcePath) + this.getMaterialBezeichner(material) + this.refdatFileExtension)));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String[] werte = line.split(this.csvSplitString);
                    if (werte == null || werte.length <= 0 || werte[0] == null || werte[0].length() <= 0) continue;
                    referenzDatei.addElement(new EinfacherEFSatz(werte));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchFieldException("Referenzdatei \"" + this.getMaterialBezeichner(material) + "\" konnte im Ressource-Pfad " + this.resourcePath + " nicht gelesen werden: " + e.getMessage());
            }
            this.referenzDateiHashMap.put(this.getMaterialBezeichner(material), referenzDatei);
        }
        return referenzDatei;
    }

    private HashSet getAlleFeldwerte(MaterialDeskriptorInterface material, FeldDeskriptorInterface feld) throws NoSuchFieldException {
        HashSet<String> referenzDateiFeldwerte;
        HashMap referenzDateiWerte = (HashMap)this.referenzDateiFeldwerteHashMap.get(this.getMaterialBezeichner(material));
        if (referenzDateiWerte == null) {
            referenzDateiWerte = new HashMap();
            this.referenzDateiFeldwerteHashMap.put(this.getMaterialBezeichner(material), referenzDateiWerte);
        }
        if ((referenzDateiFeldwerte = (HashSet<String>)referenzDateiWerte.get(feld.getFeldNameTB())) == null) {
            referenzDateiFeldwerte = new HashSet<String>();
            Vector referenzDatei = this.getReferenzDatei(material);
            if (referenzDatei != null) {
                int i = 0;
                while (i < referenzDatei.size()) {
                    EinfacherEFSatz satz = (EinfacherEFSatz)referenzDatei.get(i);
                    try {
                        String wert = satz.getString(feld);
                        if (wert != null && !referenzDateiFeldwerte.contains(wert)) {
                            referenzDateiFeldwerte.add(wert);
                        }
                    }
                    catch (WertNichtTypgerechtException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            referenzDateiWerte.put(feld.getFeldNameTB(), referenzDateiFeldwerte);
        }
        return referenzDateiFeldwerte;
    }

    public boolean wertKombinationGueltig(Value[] werte, FeldDeskriptorInterface[] felder, SatzFilter filter, MaterialDeskriptorInterface material) throws NoSuchFieldException {
        boolean wertKombinationGueltig = false;
        if (this.pr\u00fcfeParameterWertKombinationGueltig(werte, felder, filter, material)) {
            if (werte.length == 1 && (filter == null || filter.getFilterBedingungen() == null || filter.getFilterBedingungen().length == 0)) {
                HashSet referenzDateiFeldwerte = this.getAlleFeldwerte(material, felder[0]);
                String wert = werte[0].asString();
                wertKombinationGueltig = referenzDateiFeldwerte != null && referenzDateiFeldwerte.contains(wert);
            } else {
                EinfacherEFSatz[] saetzeGefiltert = (EinfacherEFSatz[])this.gibSaetzeGefiltert(felder, filter, material);
                int i = 0;
                while (i < saetzeGefiltert.length) {
                    boolean wertKombinationGefunden = true;
                    EinfacherEFSatz satz = saetzeGefiltert[i];
                    int j = 0;
                    while (j < felder.length) {
                        if (felder[j] instanceof FeldDeskriptorImpl) {
                            Value vergleichsWert;
                            FeldDeskriptorImpl refdatFeldDeskriptor = (FeldDeskriptorImpl)felder[j];
                            Value refdatWert = refdatFeldDeskriptor.getValueFrom(satz);
                            if (refdatWert.ne(vergleichsWert = werte[j])) {
                                wertKombinationGefunden = false;
                                break;
                            }
                        } else {
                            throw new NoSuchFieldException("Felddeskriptor f\u00fcr Feld \"" + felder[j].getFeldNameTB() + "\" nicht FeldDeskriptorImpl.");
                        }
                        ++j;
                    }
                    if (wertKombinationGefunden) {
                        wertKombinationGueltig = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return wertKombinationGueltig;
    }

    public SatzInterface[] gibSaetzeGefiltert(FeldDeskriptorInterface[] felder, SatzFilter filter, MaterialDeskriptorInterface material) throws NoSuchFieldException {
        Vector<EinfacherEFSatz> referenzDatei = this.getReferenzDatei(material);
        Vector<EinfacherEFSatz> saetzeGefiltert = null;
        if (filter == null || filter.getFilterBedingungen() == null || filter.getFilterBedingungen().length == 0) {
            saetzeGefiltert = referenzDatei;
        } else {
            saetzeGefiltert = new Vector<EinfacherEFSatz>();
            int i = 0;
            while (i < referenzDatei.size()) {
                EinfacherEFSatz satz = (EinfacherEFSatz)referenzDatei.get(i);
                boolean aufnehmen = true;
                SatzFilter.FilterBedingung[] bedingungen = null;
                if (filter != null) {
                    bedingungen = filter.getFilterBedingungen();
                }
                if (bedingungen != null && bedingungen.length > 0) {
                    int j = 0;
                    while (j < bedingungen.length && aufnehmen) {
                        if (bedingungen[j].feld instanceof FeldDeskriptorImpl) {
                            FeldDeskriptorImpl refdatFeldDeskriptor = (FeldDeskriptorImpl)bedingungen[j].feld;
                            Value refdatWert = refdatFeldDeskriptor.getValueFrom(satz);
                            Value vergleichsWert = bedingungen[j].vergleichsWert;
                            switch (bedingungen[j].operator) {
                                case 1: {
                                    aufnehmen = refdatWert.eq(vergleichsWert);
                                    break;
                                }
                                case 3: {
                                    aufnehmen = refdatWert.gt(vergleichsWert);
                                    break;
                                }
                                case 6: {
                                    aufnehmen = refdatWert.ge(vergleichsWert);
                                    break;
                                }
                                case 2: {
                                    aufnehmen = refdatWert.lt(vergleichsWert);
                                    break;
                                }
                                case 5: {
                                    aufnehmen = refdatWert.le(vergleichsWert);
                                    break;
                                }
                                case 4: {
                                    aufnehmen = refdatWert.ne(vergleichsWert);
                                }
                            }
                        } else {
                            throw new NoSuchFieldException("Felddeskriptor f\u00fcr Referenzdateifeld \"" + bedingungen[j].feld.getFeldNameTB() + "\" nicht FeldDeskriptorImpl.");
                        }
                        ++j;
                    }
                }
                if (aufnehmen) {
                    saetzeGefiltert.addElement(satz);
                }
                ++i;
            }
        }
        if (saetzeGefiltert.size() == 0) {
            return null;
        }
        return saetzeGefiltert.toArray(new EinfacherEFSatz[0]);
    }

    protected String getMaterialBezeichner(MaterialDeskriptorInterface material) {
        String materialbezeichner = null;
        if (material != null) {
            materialbezeichner = material.getMaterialName();
        }
        return materialbezeichner;
    }

    public String getAktuelleVersion(String refdatName) {
        return null;
    }

    public String[] getReferenzdateien() {
        return new String[]{"Alle *" + this.refdatFileExtension + "-Dateien im Ressource-Pfad " + this.resourcePath};
    }
}

