/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test.runtime.export;

import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.test.runtime.RuntimeInfos;
import de.statspez.pleditor.generator.test.runtime.RuntimeInfosUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public abstract class RuntimeInfosExport
extends Traverser {
    static final NumberFormat format = NumberFormat.getNumberInstance();
    protected static final String COLUMN_NAME_PROGRAM = "Programm";
    protected static final String COLUMN_NAME_COMPLEXITY = "Komplexit\u00e4t";
    protected static final String COLUMN_NAME_RUNTIME = "Laufzeit";
    protected static final String COLUMN_NAME_QUOTIENT = "Lz/Kompl.";
    protected static final String COLUMN_NAME_TEST_RUNTIME_MEAN = "Durchschnittdauer";
    protected static final String COLUMN_NAME_TEST_RUNNING_COUNT = "Aufrufanzahl";
    protected static final String COLUMN_NAME_TEST_RUNTIME_TOTAL = "Gesamtdauer";
    public static final int MEAN = 0;
    public static final int MINIMUM = 1;
    private HashMap metaProgramms;
    private MetaThemenbereich currentTB;
    private int type = 0;

    static {
        format.setMaximumFractionDigits(3);
        format.setMinimumFractionDigits(3);
    }

    public abstract void outputProgram(OutputStream var1, String var2, String var3, long var4, int var6, List var7);

    public void outputComplexityRuntimeInfos(OutputStream out, MetaCustomPlausibilisierung plausi, File[] csvFiles) throws FileNotFoundException, Exception {
        this.metaProgramms = new HashMap();
        plausi.accept(this);
        ArrayList<RuntimeInfos> runtimeInfosList = new ArrayList<RuntimeInfos>(csvFiles.length);
        RuntimeInfosUtil runtimeInfosIO = RuntimeInfosUtil.instance();
        int i = 0;
        while (i < csvFiles.length) {
            RuntimeInfos runtimeInfos = runtimeInfosIO.loadRuntimeInfos(new FileInputStream(csvFiles[i]));
            runtimeInfosList.add(runtimeInfos);
            ++i;
        }
        this.printHaeder(out, runtimeInfosList.size());
        this.printBody(out, runtimeInfosList);
        this.printFooter(out);
    }

    public void setType(int type) {
        this.type = type;
    }

    public void visitThemenbereich(MetaThemenbereich anObject) {
        this.currentTB = anObject;
        super.visitThemenbereich(anObject);
        this.currentTB = null;
    }

    public void visitProgram(MetaProgram aProgram) {
        if (!this.metaProgramms.containsValue(aProgram)) {
            String key = aProgram.name();
            if (this.currentTB != null) {
                key = String.valueOf(this.currentTB.getName()) + "." + key;
            }
            this.metaProgramms.put(key, aProgram);
        }
    }

    protected abstract void printHaeder(OutputStream var1, int var2);

    protected abstract void printFooter(OutputStream var1);

    private void printBody(OutputStream out, ArrayList runtimeInfosList) {
        Object[] keys = this.metaProgramms.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            ArrayList<long[]> tmp = new ArrayList<long[]>();
            MetaProgram aProgram = (MetaProgram)this.metaProgramms.get(key);
            if (aProgram.getFunctionalComplexity() != null) {
                long summeLz = 0L;
                long minimumLz = 0L;
                StringBuffer buf = new StringBuffer();
                int j = 0;
                while (j < runtimeInfosList.size()) {
                    RuntimeInfos runtimeInfos = (RuntimeInfos)runtimeInfosList.get(j);
                    long lz = runtimeInfos.gibDurchschnittdauer((String)key);
                    summeLz += lz;
                    if (minimumLz == 0L || minimumLz > lz) {
                        minimumLz = lz;
                    }
                    long[] runtimeValues = new long[]{lz, runtimeInfos.gibAufrufAnzahl((String)key), runtimeInfos.gibGesamtdauer((String)key)};
                    tmp.add(runtimeValues);
                    ++j;
                }
                long durchschnittLz = 0L;
                if (runtimeInfosList.size() > 0) {
                    durchschnittLz = summeLz / (long)runtimeInfosList.size();
                }
                int runtimeToComplexityQuotient = this.type == 0 ? (int)((double)durchschnittLz / aProgram.getFunctionalComplexity()) : (int)((double)minimumLz / aProgram.getFunctionalComplexity());
                String complexity = "";
                Double d = aProgram.getFunctionalComplexity();
                if (d != null) {
                    complexity = format.format(d);
                }
                this.outputProgram(out, (String)key, complexity, durchschnittLz, runtimeToComplexityQuotient, tmp);
                try {
                    out.write(buf.toString().getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
    }
}

