/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui;

import de.statspez.pleditor.generator.meta.MetaElement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class ComplexityNode {
    private static NumberFormat DEFAULT_DOUBLE_FORMAT = NumberFormat.getNumberInstance();
    private ComplexityNode parent;
    private MetaElement element;
    private String name;
    private Icon icon;
    private String plSpezification;
    private List children;
    private boolean frequencyEnabled;
    private boolean rootTB;

    static {
        DEFAULT_DOUBLE_FORMAT.setMaximumFractionDigits(3);
        DEFAULT_DOUBLE_FORMAT.setMinimumFractionDigits(3);
    }

    public ComplexityNode(ComplexityNode parent, MetaElement element, String name, Icon icon, String plSpezification, boolean frequencyEnabled) {
        this.parent = parent;
        this.element = element;
        this.name = name;
        this.icon = icon;
        this.plSpezification = plSpezification;
        this.frequencyEnabled = frequencyEnabled;
        this.rootTB = false;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.children = new ArrayList();
    }

    public ComplexityNode getParent() {
        return this.parent;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public int getChildCount() {
        int childCount = 0;
        childCount = this.children.size();
        return childCount;
    }

    public ComplexityNode getChild(int index) {
        return (ComplexityNode)this.children.get(index);
    }

    public void addChild(ComplexityNode child) {
        this.children.add(child);
    }

    public void removeChild(ComplexityNode child) {
        this.children.remove(child);
    }

    public boolean hasChild(ComplexityNode child) {
        return this.children.contains(child);
    }

    public MetaElement getElement() {
        return this.element;
    }

    public String getPLSpezification() {
        return this.plSpezification;
    }

    public boolean isFrequencyEnabled() {
        return this.frequencyEnabled;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public String toString() {
        return this.name;
    }

    public ComplexityNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected ComplexityNode[] getPathToRoot(ComplexityNode aNode, int depth) {
        ComplexityNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new ComplexityNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public String getName() {
        return this.name;
    }

    public void setRootTB(boolean rootTB) {
        this.rootTB = rootTB;
    }

    public boolean isRootTB() {
        return this.rootTB;
    }
}

