/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppExternalProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppGetArrayRefStrategy;
import de.statspez.pleditor.generator.codegen.cpp.CppGetIteratorValueStrategy;
import de.statspez.pleditor.generator.codegen.cpp.CppGetMerkmalFromAccess;
import de.statspez.pleditor.generator.codegen.cpp.CppGetValueStrategy;
import de.statspez.pleditor.generator.codegen.cpp.CppSetValueStrategy;
import de.statspez.pleditor.generator.codegen.cpp.CppSettings;
import de.statspez.pleditor.generator.codegen.cpp.CppTranslateToMethodStrategy;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.ForEachCheckIterator;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCallStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaElementVisitor;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForEachStatement;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import java.util.Iterator;
import java.util.Stack;

public class CppProgramCodeGenerator
extends CppCodeGenerator {
    public static final String INVOKE_AS_STRING_METHOD = "->asString()";
    public static final String INVOKE_AS_BOOLEAN_METHOD = "->asBool()";
    public static final String INVOKE_AS_INTEGER_METHOD = "->asInteger()";
    public static final String INVOKE_AS_REAL_METHOD = "->asReal()";
    public static final String FUNCTION_PLUS = "Functions::plus(context, ";
    public static final String FUNCTION_MINUS = "Functions::minus(context, ";
    public static final String FUNCTION_MULT = "Functions::mult(context, ";
    public static final String FUNCTION_DIV = "Functions::div(context, ";
    public static final String FUNCTION_NEG = "Functions::neg(context, ";
    public static final String FUNCTION_EQ = "Functions::eq(context, ";
    public static final String FUNCTION_NE = "Functions::ne(context, ";
    public static final String FUNCTION_GT = "Functions::gt(context, ";
    public static final String FUNCTION_GE = "Functions::ge(context, ";
    public static final String FUNCTION_LT = "Functions::lt(context, ";
    public static final String FUNCTION_LE = "Functions::le(context, ";
    public static final String FUNCTION_CONTAINS = "Functions::contains(context, ";
    public static final String FUNCTION_NOT = "Functions::not(context, ";
    private final CppSetValueStrategy SET_STRATEGY;
    private final CppGetValueStrategy GET_NODEREF_STRATEGY;
    private final CppGetValueStrategy GET_VALUE_STRATEGY;
    private final CppGetArrayRefStrategy GET_ARRAY_REF_STRATEGY;
    private final CppTranslateToMethodStrategy TRANSLATE_TO_METHOD_STRATEGY;
    private final MetaElementVisitor STRUCTURE_ACCESS_HELPER = new StructureAccessHelper();
    private static long uniqueIdCounter = 0L;
    private Stack scopeStack = new Stack();
    private Scope scope = null;
    private Stack namespace = new Stack();
    private Stack namespaces = new Stack();
    private int loopCount = 0;
    private Stack structureHelpStack = new Stack();
    private MetaProgram program = null;
    boolean programChecksField = false;
    private boolean errorStatementAllowed = false;
    private Short errorWeight = null;
    private MetaElementVisitor valueAccessStrategy;
    private boolean willGetSize = false;

    public CppProgramCodeGenerator() {
        this.TRANSLATE_TO_METHOD_STRATEGY = new CppTranslateToMethodStrategy(this);
        this.GET_ARRAY_REF_STRATEGY = new CppGetArrayRefStrategy(this);
        this.GET_NODEREF_STRATEGY = new CppGetValueStrategy(0, this);
        this.GET_VALUE_STRATEGY = new CppGetValueStrategy(1, this);
        this.SET_STRATEGY = new CppSetValueStrategy(this);
        this.setValueAccess(this.GET_VALUE_STRATEGY);
    }

    public void generate(MetaProgram aProgram, Scope superScope, boolean isErrorStatementAllowed) {
        this.generate(aProgram, superScope, isErrorStatementAllowed, null);
    }

    public void generate(MetaProgram aProgram, Scope superScope, boolean isErrorStatementAllowed, Short errorWeight) {
        this.program = aProgram.containsHierarchicalFunction() ? CodegenUtil.convertProgramWithHierarchicalCode(aProgram) : aProgram;
        this.scope = superScope;
        this.errorStatementAllowed = isErrorStatementAllowed;
        this.errorWeight = errorWeight;
        this.program.accept(this);
        this.checkForErrors();
    }

    public void visitProgram(MetaProgram aProgram) {
        String programName = StringHelper.getEscapedName(aProgram.name());
        this.programChecksField = false;
        this.indentNewLine();
        if (this.program.isHasToReturnValue() || this.errorStatementAllowed) {
            this.out.print("Value* ");
        } else {
            this.out.print("PL_VOID ");
        }
        this.out.print("prg_");
        this.out.print(programName);
        this.out.print("(");
        this.out.print("RuntimeContext*");
        this.out.print(" context");
        int i = 0;
        while (i < aProgram.numberOfParameters()) {
            MetaProgramParameter aParam = aProgram.parameterAt(i);
            if (!aParam.isList()) {
                this.out.print(", ");
                if (!aParam.byReference()) {
                    this.out.print("Value* param_");
                    this.out.print(StringHelper.getEscapedName(aParam.name().value()));
                } else {
                    this.programChecksField = true;
                    this.out.print("Field* aField");
                }
            } else {
                this.out.print(", Value* param_");
                this.out.print(StringHelper.getEscapedName(aParam.name().value()));
                int dimsize = aParam.dimensions().length;
                int j = 0;
                while (j < dimsize) {
                    this.out.print("[]");
                    ++j;
                }
            }
            ++i;
        }
        this.out.print(")");
        this.startBlock();
        if (this.errorWeight != null) {
            this.indentNewLine();
            this.out.print("if (");
            this.out.print(this.errorWeight);
            this.out.print(" >= context->getProblemWeightLevel())");
            this.openBlock();
        }
        this.startNewSection(aProgram.contextInfos());
        if (this.programChecksField) {
            this.indentNewLine();
            this.out.print("context->setCurrentField(aField);");
            this.indentNewLine();
            this.out.print("FeatureField* feld = new FeatureField(aField);");
        }
        this.indentNewLine();
        this.out.print("try");
        this.openBlock();
        i = 0;
        while (i < aProgram.numberOfParameters()) {
            aProgram.parameterAt(i).accept(this);
            ++i;
        }
        if (aProgram.isExternal()) {
            CppExternalProgramCodeGenerator externalProgramGenerator = new CppExternalProgramCodeGenerator();
            externalProgramGenerator.setOutput(this.out);
            externalProgramGenerator.setIndentLevel(this.indentLevel());
            aProgram.accept(externalProgramGenerator);
        } else {
            aProgram.statements().accept(this);
        }
        if (this.programChecksField) {
            this.indentNewLine();
            this.out.print("context->setCurrentField(PL_NULL);");
            this.indentNewLine();
            this.out.print("delete feld;");
        }
        if (this.errorStatementAllowed || !this.program.isHasToReturnValue()) {
            this.leaveCurrentSection();
        }
        if (this.errorStatementAllowed) {
            this.indentNewLine();
            this.out.print("return context->createBoolValue(PL_FALSE);");
        }
        this.closeBlock();
        this.indentNewLine();
        this.out.print("catch (PlausiException& e)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("context->getLogger()->error() << \"Fehler w\u00e4hrend Ausf\u00fchrung: " + programName + " (\" << e.getMessage() << \")\";");
        if (this.errorStatementAllowed) {
            this.generateErrorStatement(0, true);
        } else {
            if (this.programChecksField) {
                this.indentNewLine();
                this.out.print("context->setCurrentField(PL_NULL);");
                this.indentNewLine();
                this.out.print("delete feld;");
            }
            this.leaveCurrentSection();
            this.indentNewLine();
            this.out.print("throw;");
        }
        this.closeBlock();
        this.indentNewLine();
        this.out.print("catch (...)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("PlausiException e;");
        this.indentNewLine();
        this.out.print("context->getLogger()->error() << \"Fehler w\u00e4hrend Ausf\u00fchrung: " + programName + " (\" << e.getMessage() << \")\";");
        if (this.errorStatementAllowed) {
            this.generateErrorStatement(0, true);
        } else {
            if (this.programChecksField) {
                this.indentNewLine();
                this.out.print("context->setCurrentField(PL_NULL);");
                this.indentNewLine();
                this.out.print("delete feld;");
            }
            this.leaveCurrentSection();
            this.indentNewLine();
            this.out.print("throw;");
        }
        this.closeBlock();
        if (this.errorWeight != null) {
            this.closeBlock();
            this.indentNewLine();
            this.out.print("else");
            this.openBlock();
            this.indentNewLine();
            this.out.print("context->getLogger()->trace() << \"Pruefung wg. Fehlergewichtsschranke ausgelassen: " + programName + "\";");
            this.indentNewLine();
            this.out.print("return context->createBoolValue(PL_FALSE);");
            this.closeBlock();
        }
        this.endBlock();
    }

    public void visitProgramParameter(MetaProgramParameter aParam) {
        String paramName = StringHelper.getEscapedName(aParam.name().value());
        if (!aParam.byReference()) {
            this.indentNewLine();
            this.out.print("LocalVariable ");
            this.out.print(paramName);
            this.out.print("(param_");
            this.out.print(paramName);
            this.out.print(");");
        }
        SymbolDescriptor sd = new GenericSymbolDescriptorFactory().createSymbolDescriptor(aParam);
        if (!aParam.byReference()) {
            ((GenericSymbolDescriptor)sd).setIsLokaleVariable(true);
        }
        this.scope.define(aParam.name(), this.namespace(), sd);
    }

    public void visitStatementSequence(MetaStatementSequence aSequence) {
        Iterator it = aSequence.statements();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    public void visitVarDeclaration(MetaVarDeclaration aDecl) {
        Iterator it = aDecl.identifiers();
        while (it.hasNext()) {
            this.declareLocalVariable((MetaIdentifier)it.next());
        }
    }

    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        this.indentNewLine();
        this.setValueAccess(this.SET_STRATEGY);
        anAssignment.leftValue().accept(this);
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        anAssignment.rightValue().accept(this);
        if (anAssignment.rightValue().value() instanceof MetaFactor && ((MetaFactor)anAssignment.rightValue().value()).adaptedObject() instanceof MetaMaterialAccess) {
            this.out.print("->getFirstValue()");
        }
        this.out.print(");");
    }

    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
        String iteratorVar = "__multiassignment_iterator" + Long.toString(uniqueIdCounter++);
        this.indentNewLine();
        this.out.print("ValueIterator");
        this.out.print("* ");
        this.out.print(iteratorVar);
        this.out.print(" = context->createIterator(");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        anAssignment.rightValue().accept(this);
        this.out.print(");");
        int i = 0;
        while (i < anAssignment.numberOfLeftValues()) {
            this.indentNewLine();
            this.out.print("if (");
            this.out.print(iteratorVar);
            this.out.print("->hasNext())");
            this.openBlock();
            this.indentNewLine();
            this.setValueAccess(this.SET_STRATEGY);
            anAssignment.leftValueAt(i).accept(this);
            this.out.print(iteratorVar);
            this.out.print("->next());");
            this.closeBlock();
            ++i;
        }
    }

    public void visitPrintStatement(MetaPrintStatement aStatement) {
        this.indentNewLine();
        if (aStatement.leftValue() != null) {
            Iterator iter = aStatement.toPrint();
            while (iter.hasNext()) {
                this.setValueAccess(this.SET_STRATEGY);
                aStatement.leftValue().accept(this);
                this.out.print("Functions::KONKATENIEREN(context, ");
                this.setValueAccess(this.GET_VALUE_STRATEGY);
                aStatement.leftValue().accept(this);
                this.out.print(", ");
                ((MetaElement)iter.next()).accept(this);
                this.out.print("));");
                if (!iter.hasNext()) continue;
                this.indentNewLine();
            }
        } else {
            this.out.print("context->getLogger()->info() << ");
            this.printPrintStatementText(aStatement);
            this.out.print(";");
        }
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        this.generateForEachChecks(aStatement.condition());
        this.indentNewLine();
        this.out.print("if (");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        aStatement.condition().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        this.out.print(")");
        this.startBlock();
        aStatement.ifTrue().accept(this);
        this.endBlock();
        if (aStatement.ifFalse().numberOfStatements() > 0) {
            this.indentNewLine();
            this.out.print("else");
            this.startBlock();
            aStatement.ifFalse().accept(this);
            this.endBlock();
        }
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        aStatement.startAssignment().accept(this);
        this.indentNewLine();
        this.out.print("while (true)");
        this.startBlock();
        this.indentNewLine();
        this.out.print("if (");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        aStatement.endCondition().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        this.out.print(")");
        this.startBlock();
        this.indentNewLine();
        this.out.print("break;");
        this.endBlock();
        this.enterLoopBody();
        aStatement.loopBody().accept(this);
        this.indentNewLine();
        this.setValueAccess(this.SET_STRATEGY);
        aStatement.startAssignment().leftValue().accept(this);
        this.out.print(FUNCTION_PLUS);
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        aStatement.startAssignment().leftValue().accept(this);
        this.out.print(", ");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        aStatement.stepExpression().accept(this);
        this.out.print("));");
        this.leaveLoopBody();
        this.closeBlock();
    }

    public void visitForEachLoop(MetaForEachLoop aStatement) {
        String iterator_var = this.declareIteratorVariable(aStatement);
        this.indentNewLine();
        this.out.print("while (");
        this.out.print(iterator_var);
        this.out.print("->hasNext())");
        this.startBlock();
        this.createPerIterationStatements(aStatement, iterator_var);
        this.enterLoopBody();
        aStatement.loopBody().accept(this);
        this.leaveLoopBody();
        this.endBlock();
    }

    public void visitWhileLoop(MetaWhileLoop aStatement) {
        this.indentNewLine();
        this.out.print("while (");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        aStatement.condition().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        this.out.print(")");
        this.startBlock();
        this.enterLoopBody();
        aStatement.loopBody().accept(this);
        this.leaveLoopBody();
        this.endBlock();
    }

    public void visitBreakStatement(MetaBreakStatement aStatement) {
        if (!this.inLoop()) {
            this.error(aStatement, "nicht ausserhalb von Schleifen erlaubt");
        } else {
            this.indentNewLine();
            this.out.print("break;");
        }
    }

    public void visitPruefeStatement(MetaPruefeStatement aStatement) {
        this.createMethodCall(aStatement, aStatement.isStandalone());
    }

    public void visitAblaufStatement(MetaAblaufStatement aStatement) {
        if (aStatement.numberOfParameters() > 0) {
            this.indentNewLine();
            this.TRANSLATE_TO_METHOD_STRATEGY.setForcedMethodName("init");
            if (aStatement.function().adaptedObject() instanceof MetaIdentifier) {
                aStatement.function().accept(this.TRANSLATE_TO_METHOD_STRATEGY);
            } else {
                this.setValueAccess(this.TRANSLATE_TO_METHOD_STRATEGY);
                aStatement.function().accept(this);
            }
            this.TRANSLATE_TO_METHOD_STRATEGY.setForcedMethodName(null);
            SymbolDescriptor ablaufDesc = this.TRANSLATE_TO_METHOD_STRATEGY.lastFunctionDescriptor();
            if (ablaufDesc == null) {
                this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist nicht definiert.");
                return;
            }
            if (ablaufDesc.numberOfFunctionParameters() != aStatement.numberOfParameters()) {
                this.error(aStatement, "falsche Anzahl von Parametern (" + ablaufDesc.numberOfFunctionParameters() + " erwartet, " + aStatement.numberOfParameters() + " bekommen)");
            }
            this.out.print("(context");
            int i = 0;
            while (i < aStatement.numberOfParameters()) {
                this.out.print(", ");
                if (!ablaufDesc.functionParameterAt(i).isArray()) {
                    this.setValueAccess(this.GET_VALUE_STRATEGY);
                    aStatement.parameterAt(i).accept(this);
                } else {
                    this.setValueAccess(this.GET_ARRAY_REF_STRATEGY);
                    aStatement.parameterAt(i).accept(this);
                }
                ++i;
            }
            this.out.print(");");
        }
        this.createMethodCall(aStatement, true);
    }

    public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
        CppGetMerkmalFromAccess merkmalGetter = new CppGetMerkmalFromAccess(this);
        aStatement.field().accept(merkmalGetter);
        SymbolDescriptor merkmalDesc = merkmalGetter.merkmal();
        if (merkmalDesc != null) {
            this.setValueAccess(this.GET_NODEREF_STRATEGY);
            if (merkmalDesc.isArray()) {
                if (!aStatement.isStandalone()) {
                    this.error(aStatement, "Merkmalspr\u00fcfung der Listenfelder darf nur im Standalone-Modus aufgerufen werden.");
                } else {
                    String iterator_var = "__array_iterator" + Long.toString(uniqueIdCounter++);
                    this.indentNewLine();
                    this.out.print("FieldArrayIterator ");
                    this.out.print(iterator_var);
                    this.out.print("(context, ");
                    aStatement.field().accept(this);
                    this.out.print(");");
                    this.indentNewLine();
                    this.out.print("while (");
                    this.out.print(iterator_var);
                    this.out.print(".hasNext())");
                    this.openBlock();
                    this.indentNewLine();
                    this.out.print("prg_");
                    this.out.print("Merkmal_");
                    this.out.print(StringHelper.getEscapedName(merkmalDesc.getMerkmal()));
                    this.out.print("(context, ");
                    this.out.print(iterator_var);
                    this.out.print(".next());");
                    this.closeBlock();
                }
            } else {
                if (aStatement.isStandalone()) {
                    this.indentNewLine();
                }
                this.out.print("prg_");
                this.out.print("Merkmal_");
                this.out.print(StringHelper.getEscapedName(merkmalDesc.getMerkmal()));
                this.out.print("(context, ");
                aStatement.field().accept(this);
                this.out.print(")");
                if (aStatement.isStandalone()) {
                    this.out.print(";");
                }
            }
        }
    }

    public void visitFunctionCall(MetaFunctionCall aStatement) {
        if (aStatement.isStandalone()) {
            this.indentNewLine();
        }
        SymbolDescriptor functionDesc = null;
        if (InternalFunctions.instance().identifiesInternalFunction(aStatement.function())) {
            MetaIdentifier functionId = (MetaIdentifier)aStatement.function().adaptedObject();
            functionDesc = this.scope.symbolDescriptor(functionId, this.namespace());
            this.out.print("Functions::");
            this.out.print(functionId.value());
        } else {
            if (aStatement.function().adaptedObject() instanceof MetaIdentifier) {
                aStatement.function().accept(this.TRANSLATE_TO_METHOD_STRATEGY);
            } else {
                this.setValueAccess(this.TRANSLATE_TO_METHOD_STRATEGY);
                aStatement.function().accept(this);
            }
            functionDesc = this.TRANSLATE_TO_METHOD_STRATEGY.lastFunctionDescriptor();
        }
        if (functionDesc == null) {
            this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist nicht definiert.");
            return;
        }
        if (functionDesc.numberOfFunctionParameters() != aStatement.numberOfParameters()) {
            this.error(aStatement, "falsche Anzahl von Parametern (" + functionDesc.numberOfFunctionParameters() + " erwartet, " + aStatement.numberOfParameters() + " bekommen)");
        }
        this.out.print("(context");
        int i = 0;
        while (i < aStatement.numberOfParameters()) {
            this.out.print(", ");
            if (!functionDesc.functionParameterAt(i).isArray()) {
                this.setValueAccess(this.GET_VALUE_STRATEGY);
                aStatement.parameterAt(i).accept(this);
            } else {
                this.setValueAccess(this.GET_ARRAY_REF_STRATEGY);
                aStatement.parameterAt(i).accept(this);
            }
            ++i;
        }
        this.out.print(")");
        if (aStatement.isStandalone()) {
            this.out.print(";");
        }
    }

    public void visitErrorStatement(MetaErrorStatement aStatement) {
        this.generateErrorStatement(aStatement.errorNumber(), false);
    }

    public void visitReturnStatement(MetaReturnStatement aStatement) {
        this.leaveCurrentSection();
        this.indentNewLine();
        this.out.print("return ");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        aStatement.returnValue().accept(this);
        this.out.print(";");
    }

    public void visitFieldAccess(MetaFieldAccess anAccess) {
        anAccess.accept(this.valueAccessStrategy);
    }

    public void visitArrayAccess(MetaArrayAccess anAccess) {
        if (!this.scope.isDefined(anAccess.accessedArray(), this.namespace())) {
            this.error(anAccess, String.valueOf(anAccess.accessedArray().toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert");
            return;
        }
        this.out.print(StringHelper.getEscapedName(anAccess.accessedArray().value()));
        this.out.print("->");
        if (this.willGetSize) {
            this.out.print("getSize");
            this.willGetSize = false;
        } else {
            this.out.print("getElement");
        }
        this.out.print("(context, ");
        this.out.print(anAccess.numberOfIndices());
        this.out.print(", ");
        MetaElementVisitor oldAccessStrategy = this.valueAccessStrategy;
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        int i = 0;
        while (i < anAccess.numberOfIndices()) {
            this.startNewNamespace();
            this.out.print("PL_NUMBER(");
            anAccess.indexAt(i).accept(this);
            this.out.print(INVOKE_AS_INTEGER_METHOD);
            this.out.print(" - 1)");
            if (i < anAccess.numberOfIndices() - 1) {
                this.out.print(", ");
            }
            this.leaveThisNamespace();
            ++i;
        }
        this.out.print(")");
        this.setValueAccess(oldAccessStrategy);
        anAccess.accept(this.valueAccessStrategy);
    }

    public void visitClassificationReference(MetaClassificationReference anAccess) {
        anAccess.accept(this.valueAccessStrategy);
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accept(this.valueAccessStrategy);
    }

    public void visitStructureAccess(MetaStructureAccess anAccess) {
        if (anAccess.structureAccess() instanceof MetaStructureAccess) {
            this.structureHelpStack.push(anAccess.selectedElement());
            anAccess.structureAccess().accept(this);
        } else {
            this.structureHelpStack.push(anAccess.selectedElement());
            this.structureHelpStack.push(anAccess.structureAccess());
            MetaElementVisitor oldAccessStrategy = this.valueAccessStrategy;
            this.setValueAccess(this.STRUCTURE_ACCESS_HELPER);
            boolean tmpWillGetSize = this.willGetSize;
            this.willGetSize = false;
            int namespaceCount = 0;
            while (this.structureHelpStack.size() > 1) {
                ++namespaceCount;
                ((MetaElement)this.structureHelpStack.pop()).accept(this);
            }
            this.setValueAccess(oldAccessStrategy);
            this.willGetSize = tmpWillGetSize;
            ((MetaElement)this.structureHelpStack.pop()).accept(this);
            int i = 0;
            while (i < namespaceCount) {
                this.leaveSubNamespace();
                ++i;
            }
        }
    }

    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        if (!this.scope.isDefined(anAccess.material(), this.namespace())) {
            this.error(anAccess, "kein Material mit dem Namen '" + anAccess.material().value() + "' in diesem Gueltigkeitsbereich definiert");
            return;
        }
        String materialAttribut = StringHelper.getEscapedName("__material_" + anAccess.material().value());
        this.out.print("context->createMaterial(");
        this.out.print(materialAttribut);
        this.out.print(", ");
        this.out.print(anAccess.numberOfSelectionConditions());
        this.out.print(", ");
        this.out.print(anAccess.numberOfSelectedFields());
        Iterator it = anAccess.selectionConditions();
        while (it.hasNext()) {
            MetaTestingOperator condition = (MetaTestingOperator)it.next();
            this.out.print(", ");
            this.out.print(materialAttribut);
            this.out.print("->");
            this.setValueAccess(this.GET_NODEREF_STRATEGY);
            this.enterSubNamespace(anAccess.material().value());
            condition.firstOperand().accept(this);
            this.leaveSubNamespace();
            this.out.print(", ");
            this.out.print(CppSettings.getRuntimeOperatorType(condition.type()));
            this.out.print(", ");
            this.setValueAccess(this.GET_VALUE_STRATEGY);
            condition.secondOperand().accept(this);
        }
        this.enterSubNamespace(anAccess.material().value());
        int i = 0;
        while (i < anAccess.numberOfSelectedFields()) {
            this.out.print(", ");
            this.out.print(materialAttribut);
            this.out.print("->");
            this.setValueAccess(this.GET_NODEREF_STRATEGY);
            anAccess.selectedFieldAt(i).accept(this);
            ++i;
        }
        this.leaveSubNamespace();
        this.out.print(")");
    }

    public void visitBoolean(MetaBoolean aBoolean) {
        this.error(aBoolean, "unerwarteter bool-Wert");
    }

    public void visitNumber(MetaNumber aNumber) {
        this.error(aNumber, "unerwarteter numerischer Wert");
    }

    public void visitString(MetaString aString) {
        this.error(aString, "unerwartete Zeichenkette");
    }

    public void visitDate(MetaDate aDate) {
        this.out.print("context->createDateValue(");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        aDate.specification().accept(this);
        this.out.print(INVOKE_AS_STRING_METHOD);
        if (aDate.format() != null) {
            this.out.print(", \"");
            this.out.print(StringHelper.getEscapedStringValue(aDate.format()));
            this.out.print("\"");
        }
        this.out.print(")");
    }

    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        if (aRangeSeries.numberOfRanges() > 1) {
            this.out.print("context->createRangeSeries(");
            this.out.print(aRangeSeries.numberOfRanges());
            this.out.print(", ");
        }
        Iterator it = aRangeSeries.ranges();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.out.print(", ");
        }
        if (aRangeSeries.numberOfRanges() > 1) {
            this.out.print(")");
        }
    }

    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        aRange.value().accept(this);
    }

    public void visitInterval(MetaInterval aRange) {
        this.out.print("context->createIntervalRange(");
        aRange.first().accept(this);
        this.out.print(", ");
        aRange.last().accept(this);
        this.out.print(", ");
        this.out.print(CppSettings.getRuntimeIntervalType(aRange.type()));
        this.out.print(")");
    }

    public void visitSequence(MetaSequence aRange) {
        this.out.print("context->createSequenceRange(");
        aRange.first().accept(this);
        this.out.print(", ");
        aRange.second().accept(this);
        this.out.print(", ");
        aRange.last().accept(this);
        this.out.print(")");
    }

    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        this.out.print("context->createBoolValue(");
        anOperator.firstOperand().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        switch (anOperator.type()) {
            case 1: {
                this.out.print(" && ");
                break;
            }
            case 2: {
                this.out.print(" || ");
                break;
            }
            default: {
                this.error(anOperator, "unbekannter Operator " + anOperator.toString());
            }
        }
        anOperator.secondOperand().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        this.out.print(")");
    }

    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        switch (anOperator.type()) {
            case 1: {
                this.out.print(FUNCTION_NOT);
                break;
            }
            default: {
                this.error(anOperator, "unbekannter Operator " + anOperator.toString());
            }
        }
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        anOperator.operand().accept(this);
        this.out.print(")");
    }

    public void visitTestingOperator(MetaTestingOperator anOperator) {
        MetaFactor leftOperand = null;
        MetaFactor rightOperand = null;
        if (anOperator.type() == 7) {
            leftOperand = anOperator.secondOperand();
            rightOperand = anOperator.firstOperand();
        } else {
            leftOperand = anOperator.firstOperand();
            rightOperand = anOperator.secondOperand();
        }
        switch (anOperator.type()) {
            case 1: {
                this.out.print(FUNCTION_EQ);
                break;
            }
            case 6: {
                this.out.print(FUNCTION_GE);
                break;
            }
            case 3: {
                this.out.print(FUNCTION_GT);
                break;
            }
            case 5: {
                this.out.print(FUNCTION_LE);
                break;
            }
            case 2: {
                this.out.print(FUNCTION_LT);
                break;
            }
            case 4: {
                this.out.print(FUNCTION_NE);
                break;
            }
            case 7: {
                this.out.print(FUNCTION_CONTAINS);
                break;
            }
            default: {
                this.error(anOperator, "unbekannter Operator " + anOperator.toString());
            }
        }
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        ((MetaElement)leftOperand).accept(this);
        this.out.print(", ");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        ((MetaElement)rightOperand).accept(this);
        this.out.print(")");
    }

    public void visitTypeCheck(MetaTypeCheck typeCheck) {
        this.out.print("Functions::isTypeConform(context, ");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        typeCheck.value().accept(this);
        this.out.print(", ");
        this.out.print(CppSettings.getRuntimeFieldType(typeCheck.type()));
        if (typeCheck.maske() != null) {
            this.out.print(", \"");
            this.out.print(StringHelper.getEscapedStringValue(typeCheck.maske().value()));
            this.out.print("\"");
        }
        this.out.print(")");
    }

    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        this.willGetSize = true;
        this.out.print("context->createNumberValue(");
        this.setValueAccess(this.GET_ARRAY_REF_STRATEGY);
        anOperator.operand().accept(this);
        if (this.willGetSize) {
            this.out.print("->getSize(context, 0)");
            this.willGetSize = false;
        }
        this.out.print(")");
    }

    public void visitForEachCheck(MetaForEachCheck aCheck) {
        this.out.print(StringHelper.getEscapedName(aCheck.resultVar().value()));
        this.out.print(".get(context)");
    }

    public void visitMathOperator(MetaMathOperator anOperator) {
        switch (anOperator.type()) {
            case 3: {
                this.out.print(FUNCTION_DIV);
                break;
            }
            case 2: {
                this.out.print(FUNCTION_MINUS);
                break;
            }
            case 4: {
                this.out.print(FUNCTION_MULT);
                break;
            }
            case 1: {
                this.out.print(FUNCTION_PLUS);
                break;
            }
            default: {
                this.error(anOperator, "unbekannter Operator " + anOperator.toString());
            }
        }
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        anOperator.firstOperand().accept(this);
        this.out.print(", ");
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        anOperator.secondOperand().accept(this);
        this.out.print(")");
    }

    public void visitSignOperator(MetaSignOperator anOperator) {
        if (anOperator.type() == 2) {
            this.out.print(FUNCTION_NEG);
        }
        this.setValueAccess(this.GET_VALUE_STRATEGY);
        anOperator.operand().accept(this);
        if (anOperator.type() == 2) {
            this.out.print(")");
        }
    }

    public void visitIdentifier(MetaIdentifier anIdentifier) {
        this.out.print(StringHelper.getEscapedName(anIdentifier.value()));
    }

    public Scope hvScope() {
        return this.scope;
    }

    public String hvNamespace() {
        return this.namespace();
    }

    protected void printPrintStatementText(MetaPrintStatement aStatement) {
        Iterator it = aStatement.toPrint();
        while (it.hasNext()) {
            this.setValueAccess(this.GET_VALUE_STRATEGY);
            ((MetaElement)it.next()).accept(this);
            this.out.print(INVOKE_AS_STRING_METHOD);
            if (!it.hasNext()) continue;
            this.out.print(" << ");
        }
    }

    private void generateErrorStatement(int errorNum, boolean becauseOfException) {
        this.indentNewLine();
        this.out.print("prb_");
        this.out.print(StringHelper.getEscapedName(this.program.name()));
        this.out.print("(context, ");
        this.out.print(CppSettings.getRuntimeProblemInfoType(errorNum));
        if (becauseOfException) {
            this.out.print(", e.getMessage()");
        }
        this.out.print(");");
        if (this.programChecksField) {
            this.indentNewLine();
            this.out.print("context->setCurrentField(PL_NULL);");
            this.indentNewLine();
            this.out.print("delete feld;");
        }
        this.leaveCurrentSection();
        this.indentNewLine();
        this.out.print("return context->createBoolValue(PL_TRUE);");
    }

    private void createMethodCall(MetaCallStatement call, boolean isStandalone) {
        if (isStandalone) {
            this.indentNewLine();
        }
        if (call.function().adaptedObject() instanceof MetaIdentifier) {
            call.function().accept(this.TRANSLATE_TO_METHOD_STRATEGY);
        } else {
            this.setValueAccess(this.TRANSLATE_TO_METHOD_STRATEGY);
            call.function().accept(this);
        }
        this.out.print("(context)");
        if (isStandalone) {
            this.out.print(";");
        }
    }

    private void declareLocalVariable(MetaIdentifier id) {
        String varName = StringHelper.getEscapedName(id.value());
        this.indentNewLine();
        this.out.print("LocalVariable ");
        this.out.print(varName);
        this.out.print(";");
        try {
            GenericSymbolDescriptor sd = new GenericSymbolDescriptor();
            sd.setIsLokaleVariable(true);
            sd.setHasGenericType(true);
            this.scope.define(id, this.namespace(), sd);
        }
        catch (IllegalArgumentException exc) {
            this.error(id, exc.getMessage());
        }
    }

    private String declareIteratorVariable(MetaForEachStatement aStatement) {
        String iterator_var = "__loop_iterator" + Long.toString(uniqueIdCounter++);
        this.indentNewLine();
        if (aStatement.restrictions().size() > 0) {
            this.out.print("ArrayValueIterator");
        } else {
            this.out.print("ValueIterator");
        }
        this.out.print("* ");
        this.out.print(iterator_var);
        this.out.print(" = ");
        CppGetIteratorValueStrategy s = new CppGetIteratorValueStrategy(this);
        this.setValueAccess(s);
        this.out.print("context->createIterator(");
        aStatement.value().accept(this);
        this.out.print(");");
        if (aStatement.restrictions().size() > 0) {
            int dimension = 0;
            Iterator it = aStatement.restrictions().iterator();
            while (it.hasNext()) {
                MetaElement aRestriction = (MetaElement)it.next();
                if (aRestriction != null) {
                    this.indentNewLine();
                    this.out.print(iterator_var);
                    this.out.print("->setRestriction(");
                    this.out.print(dimension);
                    this.out.print(", ");
                    this.setValueAccess(this.GET_NODEREF_STRATEGY);
                    aRestriction.accept(this);
                    this.out.print(");");
                }
                ++dimension;
            }
        }
        return iterator_var;
    }

    private void createPerIterationStatements(MetaForEachStatement aStatement, String iteratorVar) {
        int i = 0;
        while (i < aStatement.numberOfVariables()) {
            if (!this.scope.isDefined(aStatement.variableAt(i), this.namespace())) {
                this.declareLocalVariable(aStatement.variableAt(i));
            }
            this.indentNewLine();
            this.out.print(StringHelper.getEscapedName(aStatement.variableAt(i).value()));
            this.out.print(".set(context, ");
            this.out.print(iteratorVar);
            this.out.print("->next());");
            ++i;
        }
    }

    private void generateForEachChecks(MetaElement anElement) {
        final CppProgramCodeGenerator prgCodeGen = this;
        ForEachCheckIterator it = new ForEachCheckIterator(anElement);
        it.eachCheck(new ForEachCheckIterator.CodeBlock(){

            public void doForCheck(MetaForEachCheck aCheck) {
                CppProgramCodeGenerator.this.declareLocalVariable(aCheck.resultVar());
                String resultVarName = StringHelper.getEscapedName(aCheck.resultVar().value());
                CppProgramCodeGenerator.this.indentNewLine();
                CppProgramCodeGenerator.this.out.print(resultVarName);
                CppProgramCodeGenerator.this.out.print(".set(context->createBoolValue(PL_TRUE));");
                String iteratorVar = CppProgramCodeGenerator.this.declareIteratorVariable(aCheck);
                CppProgramCodeGenerator.this.indentNewLine();
                CppProgramCodeGenerator.this.out.print("while (" + iteratorVar + "->hasNext())");
                CppProgramCodeGenerator.this.startBlock();
                CppProgramCodeGenerator.this.indentNewLine();
                CppProgramCodeGenerator.this.createPerIterationStatements(aCheck, iteratorVar);
                CppProgramCodeGenerator.this.indentNewLine();
                CppProgramCodeGenerator.this.out.print(String.valueOf(resultVarName) + ".set(context, ");
                CppProgramCodeGenerator.this.setValueAccess(CppProgramCodeGenerator.this.GET_VALUE_STRATEGY);
                aCheck.condition().accept(prgCodeGen);
                CppProgramCodeGenerator.this.out.print(");");
                CppProgramCodeGenerator.this.indentNewLine();
                CppProgramCodeGenerator.this.out.print("if (");
                CppProgramCodeGenerator.this.out.print(CppProgramCodeGenerator.FUNCTION_NOT);
                CppProgramCodeGenerator.this.out.print(resultVarName);
                CppProgramCodeGenerator.this.out.print(".get(context))");
                CppProgramCodeGenerator.this.out.print(CppProgramCodeGenerator.INVOKE_AS_BOOLEAN_METHOD);
                CppProgramCodeGenerator.this.out.print(")");
                CppProgramCodeGenerator.this.startBlock();
                CppProgramCodeGenerator.this.indentNewLine();
                CppProgramCodeGenerator.this.out.print("break;");
                CppProgramCodeGenerator.this.endBlock();
                CppProgramCodeGenerator.this.endBlock();
            }
        });
    }

    private void startBlock() {
        ScopeImpl blockScope = new ScopeImpl(this.scope);
        this.scopeStack.push(this.scope);
        this.scope = blockScope;
        this.openBlock();
    }

    private void endBlock() {
        this.scope = (Scope)this.scopeStack.pop();
        this.closeBlock();
    }

    private void setValueAccess(MetaElementVisitor strategy) {
        this.valueAccessStrategy = strategy;
    }

    private void enterSubNamespace(String subNamespace) {
        this.namespace.push(subNamespace);
    }

    private String leaveSubNamespace() {
        return (String)this.namespace.pop();
    }

    private void startNewNamespace() {
        this.namespaces.push(this.namespace);
        this.namespace = new Stack();
    }

    private void leaveThisNamespace() {
        this.namespace = (Stack)this.namespaces.pop();
    }

    private String namespace() {
        StringBuffer ns = new StringBuffer("Kontext");
        Iterator it = this.namespace.iterator();
        while (it.hasNext()) {
            ns.append(".");
            ns.append((String)it.next());
        }
        return ns.toString();
    }

    private boolean inLoop() {
        return this.loopCount > 0;
    }

    private void enterLoopBody() {
        ++this.loopCount;
    }

    private void leaveLoopBody() {
        --this.loopCount;
        if (this.loopCount < 0) {
            throw new CodegenException("Fataler Fehler: Inkonsitenz, Schleifen-Tiefe kleiner 0");
        }
    }

    private class StructureAccessHelper
    extends AbstractElementVisitor {
        private StructureAccessHelper() {
        }

        public void visitFieldAccess(MetaFieldAccess anAccess) {
            CppProgramCodeGenerator.this.out.print(StringHelper.getEscapedName(anAccess.accessedField().value()));
            CppProgramCodeGenerator.this.out.print("->");
            CppProgramCodeGenerator.this.enterSubNamespace(anAccess.accessedField().value());
        }

        public void visitArrayAccess(MetaArrayAccess anAccess) {
            CppProgramCodeGenerator.this.enterSubNamespace(anAccess.accessedArray().value());
            CppProgramCodeGenerator.this.out.print("->");
        }

        public void visitLiteralAccess(MetaLiteralAccess anAccess) {
            CppProgramCodeGenerator.this.error(anAccess, "Literale koennen nicht Elemente einer Struktur sein.");
        }

        public void visitStructureAcccess(MetaStructureAccess anAccess) {
            throw new CodegenException("Fataler Fehler: Inkonsitenz, Struktur innerhalb einer Struktur?");
        }
    }
}

