/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.GanzZahlMaskenParser;
import de.statspez.pleditor.generator.masken.KommaZahlMaske;
import de.statspez.pleditor.generator.masken.KommazahlAusdruckList;
import de.statspez.pleditor.generator.masken.MaskeException;
import java.util.regex.Pattern;

public class KommaZahlMaskenParser
extends GanzZahlMaskenParser {
    public AbstractMaske parse(String maske) throws MaskeException {
        KommaZahlMaske zahlMaske = new KommaZahlMaske();
        zahlMaske.setzeMaskeAlsString(maske);
        if (maske == null || maske.length() == 0) {
            throw new MaskeException("Maske soll angegeben werden");
        }
        StringBuffer message = new StringBuffer();
        if (!this.isSegmentGueltig(maske, message) || !this.maskeVollstaendig(maske)) {
            throw new MaskeException("Maske fuer Kommazahl ist falsch beschrieben. " + message.toString());
        }
        maske = this.parseVorzeichen(zahlMaske, maske);
        maske = this.parseAusrichtung(zahlMaske, maske);
        String str = this.erzeugePatternString(zahlMaske, maske);
        Pattern p = Pattern.compile(str);
        zahlMaske.setzePattern(p);
        return zahlMaske;
    }

    protected void initSymbole() {
        this.symbole = new char[]{'L', 'M', 'R', '-', '+', '0', '\\', '#', '.'};
    }

    protected boolean pruefeZahlDefinition(String segment, StringBuffer message) {
        boolean hatMinMaxTrennzeichen = false;
        boolean maskiert = false;
        boolean hatDezimaltrennzeichen = false;
        boolean mit0abgeschlossen = false;
        boolean maskeVollstaendig = false;
        boolean ok = true;
        int i = 0;
        while (ok && i < segment.length()) {
            if (hatDezimaltrennzeichen && mit0abgeschlossen) {
                ok = false;
                if (message == null) break;
                message.append("Das 0-Symbol darf nur am Ende der Definition des Nachkommabereichs vorkommen.");
                break;
            }
            char ch = segment.charAt(i);
            switch (ch) {
                case '0': {
                    if (!maskiert) {
                        if (!hatDezimaltrennzeichen) {
                            if (hatMinMaxTrennzeichen) {
                                ok = false;
                                if (message == null) break;
                                message.append("Zweites 0-Symbol im Vorkommabereich.");
                                break;
                            }
                            hatMinMaxTrennzeichen = true;
                            maskeVollstaendig = false;
                            break;
                        }
                        ok = maskeVollstaendig;
                        if (!ok && message != null) {
                            if (maskeVollstaendig) break;
                            message.append("Nach dem Dezimalpunkt kann nur eine Ziffer definiert werden.");
                            break;
                        }
                        mit0abgeschlossen = true;
                        break;
                    }
                    maskiert = false;
                    maskeVollstaendig = true;
                    break;
                }
                case '\\': {
                    if (maskiert) {
                        ok = false;
                        break;
                    }
                    maskiert = true;
                    break;
                }
                case '#': {
                    if (maskiert) {
                        ok = false;
                        if (message == null) break;
                        message.append("Ung\u00fcltiges Zeichen'\\" + ch + "'.");
                        break;
                    }
                    maskeVollstaendig = true;
                    break;
                }
                case '.': {
                    if (hatDezimaltrennzeichen) {
                        ok = false;
                        if (message == null) break;
                        message.append("Maskendefinition darf nur einen Dezimalpunkt enthalten.");
                        break;
                    }
                    hatDezimaltrennzeichen = true;
                    if (!maskeVollstaendig) {
                        ok = false;
                        if (message == null) break;
                        message.append("Vor und nach dem Dezimalpunkt muss eine Ziffer definiert werden.");
                        break;
                    }
                    maskeVollstaendig = false;
                    break;
                }
                default: {
                    ok = Character.isDigit(ch);
                    if (!ok && message != null) {
                        message.append("Ung\u00fcltiges Zeichen '" + ch + "'.");
                        break;
                    }
                    maskeVollstaendig = true;
                }
            }
            ++i;
        }
        return ok;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String erzeugePatternString(KommaZahlMaske zahlMaske, String maske) throws MaskeException {
        StringBuffer buf = new StringBuffer();
        ParserZustand zustand = new ParserZustand();
        int i = 0;
        while (i < maske.length()) {
            char ch = maske.charAt(i);
            if (zustand.negation) {
                if (ch != '0') throw new MaskeException("Ung\u00fcltiges Zeichen '\\" + ch + "'.");
                zustand.addZeichen(new String(new char[]{ch}));
                zustand.negation = false;
            } else if ('0' == ch) {
                zustand.schalter0();
            } else if ('.' == ch) {
                zustand.punkt();
            } else if ('\\' == ch) {
                if (zustand.negation) {
                    throw new MaskeException("Ung\u00fcltiges Zeichen '\\" + ch + "'.");
                }
                zustand.negation = true;
            } else {
                if ('#' != ch && !Character.isDigit(ch)) throw new MaskeException("Ung\u00fcltiges Zeichen '" + ch + "'.");
                String regularExpression = '#' == ch ? this.gibAusdruckFuerSymbol(ch) : new String(new char[]{ch});
                zustand.addZeichen(regularExpression);
            }
            ++i;
        }
        zahlMaske.setVorkommastellenMax(zustand.vor_max);
        zahlMaske.setVorkommastellenMin(zustand.vor_min);
        zahlMaske.setNachkommastellen(zustand.nach_max);
        int maxLaenge = zustand.vor_max + zustand.nach_max;
        if (zahlMaske.hatVorzeichen()) {
            ++maxLaenge;
        }
        if (zustand.nach_max > 0) {
            ++maxLaenge;
        }
        zahlMaske.setzeMaxLaenge(maxLaenge);
        int minLaenge = 0;
        if (this.vorzeichenTyp == 1 || this.vorzeichenTyp == 3 || this.vorzeichenTyp == 4) {
            ++minLaenge;
        }
        minLaenge += zustand.vor_min;
        if (zustand.nach_min > 0) {
            ++minLaenge;
        }
        zahlMaske.setzeMinLaenge(minLaenge += zustand.nach_min);
        if (zustand.vorkommaMinAn) {
            zahlMaske.setzeFuellzeichen('0');
        }
        zahlMaske.setNachkommaFest(zustand.nach_min == zustand.nach_max);
        buf.append(zustand.list.gibPattern(zustand.vor_min, zustand.vor_max, zustand.nach_min, zustand.nach_max));
        return buf.toString();
    }

    protected boolean maskeVollstaendig(String maske) {
        boolean erg = false;
        if (maske != null && maske.length() > 0) {
            char lastChar = maske.charAt(maske.length() - 1);
            if (lastChar == '#') {
                erg = true;
            } else if (Character.isDigit(lastChar)) {
                boolean hatDezimalpunkt;
                boolean bl = hatDezimalpunkt = maske.indexOf(new String(new char[]{'.'})) != -1;
                erg = lastChar == '0' && !hatDezimalpunkt ? maske.charAt(maske.length() - 2) == '\\' : true;
            } else {
                erg = false;
            }
        }
        return erg;
    }

    class ParserZustand {
        KommazahlAusdruckList list;
        boolean negation = false;
        boolean vorkommaMinAn = false;
        boolean vorkommaBereich = true;
        boolean kommaAnhaengen = true;
        int vor_min;
        int vor_max;
        int nach_min;
        int nach_max;

        private ParserZustand() {
            this.list = new KommazahlAusdruckList(KommaZahlMaskenParser.this.erzeugeVorzeichenRegularExpression());
            this.negation = false;
            this.vorkommaMinAn = false;
            this.vorkommaBereich = true;
            this.kommaAnhaengen = true;
            this.vor_min = 0;
            this.vor_max = 0;
            this.nach_min = 0;
            this.nach_max = 0;
        }

        private void addZeichen(String regularExpression) {
            if (this.negation) {
                this.negation = false;
            }
            if (!this.vorkommaBereich && this.kommaAnhaengen) {
                String kommaRegAusdruk = KommaZahlMaskenParser.this.maskierePatternSymbol('.');
                regularExpression = "(" + kommaRegAusdruk + regularExpression + ")";
                this.kommaAnhaengen = false;
            }
            this.list.fuegeAusdruckHinzu(regularExpression, this.vorkommaBereich);
            if (this.vorkommaBereich) {
                ++this.vor_max;
                if (this.vorkommaMinAn) {
                    ++this.vor_min;
                }
            } else {
                ++this.nach_max;
            }
        }

        private void schalter0() {
            if (this.vorkommaBereich) {
                this.vorkommaMinAn = true;
            } else {
                this.nach_min = this.nach_max;
            }
        }

        private void punkt() {
            this.vorkommaBereich = false;
            if (this.vor_min == 0) {
                this.vor_min = 1;
            }
        }
    }
}

