/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MaterialLinkParser
extends SubParser {
    private MetaTBMaterialReferenz currentRef = null;
    static /* synthetic */ Class class$0;

    public MaterialLinkParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "materialLink".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("materialLink".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentRef = new MetaTBMaterialReferenz();
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("materialLink".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName) && !"http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentRef;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("materialLink".equalsIgnoreCase(localName)) {
            String name = atts.getValue("link-name");
            if (name == null) {
                throw new ILParseException("Fuer die MaterialReferenz ist kein Name definiert");
            }
            this.currentRef.setName(name);
            String matDefName = atts.getValue("materialDefinition-name");
            String id = atts.getValue("materialDefinition-id");
            String key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (matDefName != null && matDefName.trim().length() > 0) {
                key = matDefName;
            }
            if (key != null) {
                Resolver resolver = this.resolver();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.statspez.pleditor.generator.meta.MetaCustomPLMaterial");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resolver.registerForResolve(this.currentRef, key, matDefName, clazz);
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        if ("annotation".equalsIgnoreCase(localName)) {
            String chars = this.superParser().charData().toString();
            if (chars.length() > 0) {
                this.currentRef.setKommentar(chars);
            }
        } else {
            handled = false;
        }
        return handled;
    }
}

