/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.ReplacementUtil;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PruefungParser
extends SubParser
implements SuperParser {
    private static final short DEFAULT_TYPE = 1;
    private static final short DEFAULT_ERROR_WEIGHT = 9;
    private MetaCustomPruefung currentPruefung = null;
    private ParserChain parserChain = new ParserChain();
    private PropertiesParser propertiesParser;
    private ObjectContextParser objectContextParser;
    static /* synthetic */ Class class$0;

    public PruefungParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "check".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("check".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentPruefung = new MetaCustomPruefung();
            this.propertiesParser.setCurrentElement(this.currentPruefung);
            this.objectContextParser.setCurrentElement(this.currentPruefung);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("check".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentPruefung;
    }

    public void notifyObjectAvailable(SubParser aParser) {
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("check".equalsIgnoreCase(localName)) {
            String index;
            String state;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer die Pr\u00fcfung ist kein Name definiert!");
            }
            this.currentPruefung.setPruefschluessel(name.trim());
            String id = atts.getValue("id");
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentPruefung.setId(id.trim());
            } else {
                this.currentPruefung.setId(name);
            }
            String nr = atts.getValue("nr");
            if (nr != null) {
                this.currentPruefung.setLfdNr(Long.parseLong(nr));
            }
            String type = atts.getValue("type");
            this.currentPruefung.setPruefungsart(PruefungParser.typeForName(type));
            String methodid = atts.getValue("method-id");
            if (methodid == null) {
                throw new ILParseException("Fuer die Pr\u00fcfung " + name + " ist keine Methoden-ID definiert!");
            }
            this.currentPruefung.setMethodenKategorieID(Short.parseShort(methodid));
            String correctionid = atts.getValue("correction-id");
            if (correctionid == null) {
                throw new ILParseException("Fuer die Pr\u00fcfung " + name + " ist keine Korrektur-ID definiert!");
            }
            this.currentPruefung.setKorrekturart(Short.parseShort(correctionid));
            String errorw = atts.getValue("error-weight");
            if (errorw == null) {
                this.currentPruefung.setFehlergewicht((short)9);
            } else {
                this.currentPruefung.setFehlergewicht(Short.parseShort(errorw));
            }
            String ref_field = atts.getValue("ref-field");
            StringTokenizer feldNamen = null;
            if (ref_field != null && ref_field.length() > 0) {
                feldNamen = new StringTokenizer(ref_field, ".");
            }
            String ref_field_id = atts.getValue("ref-field-id");
            String key = null;
            if (ref_field_id != null && ref_field_id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = ref_field_id;
            } else if (ref_field != null && ref_field.trim().length() > 0) {
                key = ref_field.trim();
            }
            if (key != null && key.trim().length() > 0) {
                this.currentPruefung.setFieldIds(key);
                Iterator it = this.currentPruefung.getHauptBezugsfeldIds();
                String tmpId = null;
                String tmpName = null;
                while (it != null && it.hasNext() && feldNamen != null && feldNamen.hasMoreTokens()) {
                    tmpId = (String)it.next();
                    tmpName = feldNamen.nextToken();
                    if (tmpId == null || tmpId.length() <= 0) continue;
                    Resolver resolver = this.resolver();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("de.statspez.pleditor.generator.meta.MetaCustomTBFeld");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    resolver.registerForResolve(this.currentPruefung, tmpId, tmpName, clazz);
                }
            }
            if ((state = atts.getValue("state")) != null && state.trim().equals("approved")) {
                this.currentPruefung.setFreigabeStatus((short)1);
            }
            if ((index = atts.getValue("ref-field-index")) != null) {
                this.currentPruefung.setHauptbezugsfeldIndex(Helper.parseDimensionSpec(index.trim()));
                this.currentPruefung.setHauptbezugsfeldIndex(index);
            }
        }
    }

    public static short typeForName(String type) throws ILParseException {
        int result = 1;
        if (type != null) {
            String theType = type.trim();
            if ("mandatory".equals(theType)) {
                result = 1;
            } else if ("optional".equals(theType)) {
                result = 2;
            } else if ("imputation".equals(theType)) {
                result = 3;
            } else {
                throw new ILParseException("Unbekannter Pr\u00fcfungs-Typ '" + theType + "'!");
            }
        }
        return (short)result;
    }

    /*
     * Unable to fully structure code
     */
    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        handled = true;
        chars = this.superParser().charData().toString().trim();
        if ("code".equalsIgnoreCase(localName)) {
            block12: {
                util = ReplacementUtil.getInstance();
                if (util.sollErsetztWerden(this.superParser().getParserKontext().getVersion())) {
                    chars = util.replace(chars);
                }
                this.currentPruefung.setPLSpezifikation(chars);
                spez = null;
                try {
                    spez = Helper.metaStructureFor(this.getMessageContext(null), chars);
                    break block12;
                }
                catch (SpecLangParseException e) {
                    mit = e.messageIterator();
                    ** while (mit.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    aMsg = (AbstractMessage)mit.next();
                    this.error(aMsg);
                    continue;
                }
lbl18:
                // 1 sources

                spez = new MetaProgram("Pr\u00fcfung " + this.currentPruefung.getPruefschluessel(), new MetaStatementSequence());
            }
            spez.setName(this.currentPruefung.getPruefschluessel());
            this.currentPruefung.setMetaSpezifikation(spez);
        } else if ("errorShort".equalsIgnoreCase(localName)) {
            this.currentPruefung.setFehlertextKurz(chars);
            this.currentPruefung.setFehlerTextKurzProgram(Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Fehlertext kurz)")));
        } else if ("errorLong".equalsIgnoreCase(localName)) {
            this.currentPruefung.setFehlertextLang(chars);
            this.currentPruefung.setFehlerTextLangProgram(Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Fehlertext lang)")));
        } else if ("correctionDescription".equalsIgnoreCase(localName)) {
            this.currentPruefung.setKorrekturhinweis(chars);
            this.currentPruefung.setKorrekturhinweisProgram(Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Korrekturhinweis)")));
        } else {
            handled = false;
        }
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && (tag.equalsIgnoreCase("code") || tag.equalsIgnoreCase("errorShort") || tag.equalsIgnoreCase("errorLong") || tag.equalsIgnoreCase("correctionDescription"));
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }

    protected MessageContextInterface getMessageContext(String hint) {
        return new ElementMessageContext(1, this.currentPruefung.getId(), this.currentPruefung.getPruefschluessel(), hint);
    }
}

