/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaCustomRawField;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RawFieldParser
extends SubParser {
    private MetaCustomRawField field = null;

    public RawFieldParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "rawField".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("rawField".equalsIgnoreCase(localName)) {
            this.enable();
            this.field = new MetaCustomRawField();
            this.handleAttributes(namespaceURI, localName, qName, atts);
            this.notifyObjectStarted();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("rawField".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        }
    }

    public MetaElement object() {
        return this.field;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("rawField".equalsIgnoreCase(localName)) {
            String source;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer das RawField ist kein Name definiert!");
            }
            this.field.setName(name.trim());
            String id = atts.getValue("id");
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.field.setId(id.trim());
            } else {
                this.field.setId(name);
            }
            String typ = atts.getValue("type");
            if (typ == null) {
                throw new ILParseException("Fuer das RawField ist kein Typ definiert!");
            }
            this.field.setTyp(typ.trim());
            String dimensions = atts.getValue("dimensions");
            if (dimensions != null && dimensions.length() > 0) {
                this.field.setDimension(dimensions);
                this.field.setDimensions(Helper.parseDimensionSpec(dimensions.trim()));
            }
            if ((source = atts.getValue("source")) != null) {
                this.field.setDSBName(source.trim());
            }
        }
        if (this.superParser() != null && this.superParser() instanceof SubParser && ((SubParser)((Object)this.superParser())).object() != null) {
            this.field.setRawParent(((SubParser)((Object)this.superParser())).object());
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = false;
        String chars = this.superParser().charData().toString().trim();
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "rawField".equalsIgnoreCase(tag);
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

