/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;

public class InvalidValue
extends Value {
    private static final double INVALID_NUMBER_VALUE = 0.0;
    private static final boolean INVALID_BOOLEAN_VALUE = false;
    private static final String INVALID_STRING_VALUE = "";
    private static InvalidValue theInstance;

    public static InvalidValue instance() {
        if (theInstance == null) {
            theInstance = new InvalidValue();
        }
        return theInstance;
    }

    public boolean isValid() {
        return false;
    }

    public double asDouble() throws ValueConversionException {
        return 0.0;
    }

    public long asLong() throws ValueConversionException {
        return 0L;
    }

    public boolean asBoolean() throws ValueConversionException {
        return false;
    }

    public String asString() throws ValueConversionException {
        return INVALID_STRING_VALUE;
    }

    protected int operatorLevel() {
        return 100;
    }

    protected boolean eqImpl(Value aValue) {
        return !aValue.isValid();
    }

    protected boolean ltImpl(Value aValue) {
        return false;
    }

    protected boolean leImpl(Value aValue) {
        return false;
    }

    protected boolean gtImpl(Value aValue) {
        return false;
    }

    protected boolean geImpl(Value aValue) {
        return false;
    }

    protected boolean neImpl(Value aValue) {
        return aValue.isValid();
    }

    protected boolean containsImpl(Value aValue) {
        return !aValue.isValid();
    }

    private InvalidValue() {
    }
}

