/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.highligher;

import de.statspez.pleditor.ui.highligher.PLToken;
import java.util.Hashtable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class PLTokenScanner {
    private String scannedString;
    private int textLength;
    private int position;
    private int endPosition;
    private int state;
    private boolean initState = false;
    private char lookahead;
    private Hashtable keywordHashtable;
    private Hashtable miscSymbolHashtable;
    private Hashtable operatorSymbol;
    private Hashtable operatorKeywordHashtable;
    private PLToken token = new PLToken();
    private static final int STATE_STRING = 0;
    private static final int STATE_WORD = 1;
    private static final int STATE_COMMENT = 2;
    private static final int STATE_WHITESPACE = 5;
    private static final int STATE_NUMBER = 6;
    private static final int STATE_OPERATOR_OR_MISC = 7;
    private static final int STATE_INIT = 9;

    private boolean isStateActive(int state) {
        return state >= 0 && state <= 5;
    }

    public void setKeywords(String[] keywords) {
        this.keywordHashtable = new Hashtable(keywords.length);
        int i = 0;
        while (i < keywords.length) {
            this.keywordHashtable.put(keywords[i], Boolean.TRUE);
            ++i;
        }
    }

    public void setOperatorKeyword(String[] operatorKeyword) {
        this.operatorKeywordHashtable = new Hashtable(operatorKeyword.length);
        int i = 0;
        while (i < operatorKeyword.length) {
            this.operatorKeywordHashtable.put(operatorKeyword[i], Boolean.TRUE);
            ++i;
        }
    }

    public void setMiscSymbol(String[] miscSymbol) {
        this.operatorSymbol = new Hashtable(miscSymbol.length);
        int i = 0;
        while (i < miscSymbol.length) {
            this.operatorSymbol.put(miscSymbol[i], Boolean.TRUE);
            ++i;
        }
    }

    public void setOperatorSymbol(String[] operatorSymbol) {
        this.miscSymbolHashtable = new Hashtable(operatorSymbol.length);
        int i = 0;
        while (i < operatorSymbol.length) {
            this.miscSymbolHashtable.put(operatorSymbol[i], Boolean.TRUE);
            ++i;
        }
    }

    public int getCurrentPos() {
        return this.position;
    }

    public boolean endOfText() {
        return this.position >= this.textLength;
    }

    public boolean endOfLine() {
        return this.scannedString.charAt(this.position) == '\n';
    }

    public void setInterval(int start, int end) {
        this.position = start;
        this.endPosition = end;
    }

    public void setDocument(Document value) {
        this.textLength = value.getLength();
        try {
            this.scannedString = value.getText(0, this.textLength);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setState(int tokenId, int tokenStart) {
        this.state = tokenId;
        this.token.setId(this.isStateActive(tokenId) ? tokenId : 9);
        this.token.setStart(tokenStart);
        this.token.setEnd(-1);
        this.initState = true;
    }

    public PLToken getToken() {
        return this.token;
    }

    private boolean isKeyword(String word) {
        return this.keywordHashtable.containsKey(word);
    }

    private boolean isOperatorKeyword(String word) {
        return this.operatorKeywordHashtable.containsKey(word);
    }

    private boolean isMiscSymbol(String word) {
        return this.miscSymbolHashtable.containsKey(word);
    }

    private boolean isOperatorSymbol(String word) {
        return this.operatorSymbol.containsKey(word);
    }

    private boolean isNumber(String word) {
        return word.matches("^[-+]?[0-9]*(\\.)?[0-9]+$");
    }

    private void next() {
        ++this.position;
        this.lookahead = this.position >= this.textLength ? (char)'\u0000' : this.scannedString.charAt(this.position);
    }

    public boolean nextToken() {
        if (this.position >= this.textLength) {
            return false;
        }
        this.lookahead = this.scannedString.charAt(this.position);
        if (this.position >= this.endPosition && (this.lookahead == '\r' || this.lookahead == '\n')) {
            return false;
        }
        if (!this.initState) {
            this.token.setId(9);
            this.token.setStart(-1);
            this.token.setEnd(-1);
            this.state = 9;
        } else {
            this.initState = false;
        }
        while (true) {
            if (this.position == this.endPosition && !this.token.isMultiline()) {
                this.lookahead = '\u0000';
            }
            switch (this.state) {
                case 9: {
                    switch (this.lookahead) {
                        case '\'': {
                            this.state = 0;
                            this.token.setStart(this.position);
                            this.token.setId(0);
                            this.next();
                            break;
                        }
                        case '\"': {
                            this.state = 2;
                            this.token.setStart(this.position);
                            this.token.setId(2);
                            this.next();
                            break;
                        }
                        case '\u0000': {
                            return false;
                        }
                        default: {
                            if (this.lookahead >= 'A' && this.lookahead <= 'Z' || this.lookahead >= 'a' && this.lookahead <= 'z') {
                                this.state = 1;
                                this.token.setStart(this.position);
                                this.token.setId(1);
                            } else if (this.lookahead >= '0' && this.lookahead <= '9') {
                                this.state = 6;
                                this.token.setStart(this.position);
                                this.token.setId(6);
                            } else if (this.lookahead >= '(' && this.lookahead <= '/' || this.lookahead >= ':' && this.lookahead <= '>' || this.lookahead >= '[' || this.lookahead >= ']' || this.lookahead >= '{' || this.lookahead >= '}' || this.lookahead >= '&') {
                                this.state = 7;
                                this.token.setStart(this.position);
                            } else {
                                this.token.setStart(this.position);
                                this.token.setId(5);
                                this.state = 5;
                            }
                            this.next();
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    String operator;
                    if (this.lookahead == '=' || this.lookahead == '.' || this.lookahead == '+' || this.lookahead == '-') {
                        this.next();
                    }
                    if (this.isOperatorSymbol(operator = this.scannedString.substring(this.token.getStart(), this.position))) {
                        this.token.setEnd(this.position - 1);
                        this.token.setId(8);
                        this.state = 9;
                        return true;
                    }
                    if (this.isMiscSymbol(operator)) {
                        this.token.setEnd(this.position - 1);
                        this.token.setId(7);
                        this.state = 9;
                        return true;
                    }
                    this.token.setId(5);
                    this.state = 5;
                    break;
                }
                case 5: {
                    if (this.lookahead == '\'' || this.lookahead == '\"' || this.lookahead == '\n' || this.lookahead == '\u0000' || this.lookahead >= 'A' && this.lookahead <= 'Z' || this.lookahead >= 'a' && this.lookahead <= 'z' || this.lookahead >= '(' && this.lookahead <= '>' || this.lookahead >= '[' || this.lookahead >= ']' || this.lookahead >= '{' || this.lookahead >= '}') {
                        this.token.setEnd(this.position - 1);
                        this.state = 9;
                        return true;
                    }
                    this.next();
                    break;
                }
                case 6: {
                    if (this.lookahead >= '0' && this.lookahead <= '9' || this.lookahead == '.') {
                        this.next();
                        break;
                    }
                    String numer = this.scannedString.substring(this.token.getStart(), this.position);
                    if (this.isNumber(numer)) {
                        this.state = 9;
                        this.token.setId(6);
                        this.token.setEnd(this.position - 1);
                        return true;
                    }
                    this.token.setId(5);
                    this.state = 5;
                    break;
                }
                case 1: {
                    if (this.lookahead >= 'A' && this.lookahead <= 'Z' || this.lookahead >= 'a' && this.lookahead <= 'z' || this.lookahead >= '0' && this.lookahead <= '9' || this.lookahead == '_' || this.lookahead == '$' || this.lookahead == '#') {
                        this.next();
                        break;
                    }
                    String word = this.scannedString.substring(this.token.getStart(), this.position);
                    if (this.isKeyword(word)) {
                        this.state = 9;
                        this.token.setId(3);
                        this.token.setEnd(this.position - 1);
                        return true;
                    }
                    if (this.isOperatorKeyword(word)) {
                        this.state = 9;
                        this.token.setId(4);
                        this.token.setEnd(this.position - 1);
                        return true;
                    }
                    if (this.isMiscSymbol(word)) {
                        this.state = 9;
                        this.token.setId(7);
                        this.token.setEnd(this.position - 1);
                        return true;
                    }
                    if (this.isOperatorSymbol(word)) {
                        this.state = 9;
                        this.token.setId(8);
                        this.token.setEnd(this.position - 1);
                        return true;
                    }
                    this.token.setId(5);
                    this.state = 5;
                    break;
                }
                case 0: {
                    switch (this.lookahead) {
                        case '\'': {
                            this.state = 9;
                            this.token.setEnd(this.position);
                            this.next();
                            return true;
                        }
                        case '\u0000': 
                        case '\n': {
                            this.state = 9;
                            this.token.setEnd(this.position - 1);
                            return true;
                        }
                    }
                    this.next();
                    break;
                }
                case 2: {
                    switch (this.lookahead) {
                        case '\"': {
                            this.state = 9;
                            this.token.setEnd(this.position);
                            this.next();
                            return true;
                        }
                        case '\u0000': {
                            this.state = 9;
                            this.token.setEnd(this.position - 1);
                            return true;
                        }
                    }
                    this.next();
                }
            }
        }
    }
}

