
package kernpruefung;

/**
 * Das Interface Kernpruefung enthlt als einzige Methode, die Methode zur
 * Kernprfung eines Datensatzes.
 * <p>
 * Fr die Implementierung des Interfaces in der einheitlichen Kernprfung
 * gilt folgendes Namensschema:<br>
 * <pre>
 *           KernpruefungXYZDummyImpl  (Dummy-Impementierung fr XYZ-Verfahren)
 *           KernpruefungXYZImpl       (Implementierung fr XYZ = Verfahrensname).
 * 
 * Beispiel: KernpruefungZAVDummyImpl  (Dummy-Implementierung fr das Zahlstellenmeldeverfahren)
 *           KernpruefungZAVImpl       (Implementierung fr das Zahlstellenmeldeverfahren) 
 * </pre><p>
 * Die Prfungen fr die einzelnen Verfahren, knnen aus der Implementierung der Schnittstelle
 * entnommen werden.
 * <p>
 * @author  Uwe Loske (Knappschaft-Bahn-See)
 * @version 1.0
 */
public interface Kernpruefung
{
  /**
   * Der eingegebene Datensatz wird mithilfe des Vorlaufsatzes kerngeprft.
   *
   * @param  datensatz   (der zu prfende Satz)
   * @param  vorlaufsatz (Vorlaufsatz aus der Meldung)
   * @return Rueckgabe   (siehe Interface)
   */
  public Rueckgabe pruefe(String datensatz, String vorlaufsatz);

}
