/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaElement;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class DiffStructure {
    private Map metaElementMap = Collections.synchronizedMap(new TreeMap());
    private MetaCustomPlausibilisierung plausibilisierung = null;

    DiffStructure() {
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.metaElementMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            MetaElement element = (MetaElement)entry.getValue();
            buffer.append(name);
            buffer.append(" (");
            String classname = element.getClass().getName();
            buffer.append(classname.substring(classname.lastIndexOf(46) + 1));
            buffer.append(")");
            buffer.append("\n");
        }
        return buffer.toString();
    }

    void addMetaElement(String context, MetaElement metaElement) {
        if (context == null || context.equals("")) {
            throw new IllegalArgumentException("Kontext darf nicht null oder leer sein!");
        }
        if (metaElement == null) {
            throw new NullPointerException();
        }
        if (this.metaElementMap.containsKey(context)) {
            throw new IllegalArgumentException("Es ist bereits ein Element unter dem Kontext '" + context + "' eingetragen!");
        }
        this.metaElementMap.put(context, metaElement);
    }

    Map getMetaElementMap() {
        return new TreeMap(this.metaElementMap);
    }

    MetaCustomPlausibilisierung getMetaPlausibilisierung() {
        return this.plausibilisierung;
    }

    void setMetaPlausibilisierung(MetaCustomPlausibilisierung plausibilisierung) {
        if (plausibilisierung == null) {
            throw new NullPointerException();
        }
        this.plausibilisierung = plausibilisierung;
    }
}

