/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.codegen.doku.KlassifikationStat;
import de.statspez.pleditor.generator.codegen.doku.MerkmalStat;
import de.statspez.pleditor.generator.codegen.doku.XMLCodeGenerator;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.parser.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ClassificationDokuGenerator
extends XMLCodeGenerator {
    private KlassifikationStat klassifikationStat = null;
    private MerkmalStat merkmalStat = null;
    private int index;

    public ClassificationDokuGenerator(KlassifikationStat klassifikationStat, MerkmalStat merkmalStat) {
        this.klassifikationStat = klassifikationStat;
        this.merkmalStat = merkmalStat;
    }

    public void generate(List statVarIds) {
        this.beginBlock("doc:classifications");
        ArrayList tmpList = this.klassifikationStat.resolveStatVarIds(statVarIds);
        Collections.sort(tmpList);
        Iterator it = tmpList.iterator();
        while (it.hasNext()) {
            this.out.flush();
            this.index = 0;
            DokuElement de = (DokuElement)it.next();
            MetaAuspraegungsgruppe mag = (MetaAuspraegungsgruppe)de.getElement();
            HashSet tmpSet = this.klassifikationStat.getFromIdAccessedByTable(de.getId());
            ArrayList mList = this.merkmalStat.resolveIds(tmpSet);
            Collections.sort(mList);
            this.beginElementBlock(de.getName(), de.getId(), "classification", de.getZusatz());
            this.appendBlock("doc:description", mag.getBeschreibung());
            this.appendBlock("doc:annotation", mag.getKommentar());
            this.appendBlock("doc:objectPackage", Tags.dekodierePunkten(mag.getMetaObjectContext().getObjectPakage()));
            this.appendList("doc:accessingVariables", "statisticVariable", mList);
            this.beginBlock("doc:classificationElements");
            this.visitElements(mag.getAuspraegungsComps().getAuspraegungen());
            this.endBlock("doc:classificationElements");
            this.endElementBlock();
        }
        this.endBlock("doc:classifications");
        this.out.flush();
    }

    public void visitPLAuspraegung(MetaPLAuspraegung anObject) {
        this.out.flush();
        MetaCustomAuspraegung mce = (MetaCustomAuspraegung)anObject;
        this.beginElementBlock(mce.getName(), "classificationElement");
        this.appendBlock("doc:index", ++this.index);
        this.appendBlock("doc:code", mce.getKode());
        this.appendBlock("doc:classificationTextShort", mce.getKurztext());
        this.appendBlock("doc:classificationText", mce.getLangtext());
        this.visitElements(mce.getAuspraegungen());
        this.endElementBlock();
    }
}

