/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.HelperVisitor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;

class GetArrayRefStrategy
extends HelperVisitor {
    private ProgramCodeGenerator generator;

    public GetArrayRefStrategy(ProgramCodeGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public void visitFieldAccess(MetaFieldAccess anAccess) {
        SymbolDescriptor sd = this.checkIfExistsAndArray(anAccess.accessedField());
        String name = StringHelper.getEscapedName(anAccess.accessedField().value());
        if (!this.generator.withinStructureAccess() && this.generator.withinSegment()) {
            if (sd.isLokaleVariable() || sd.isParameter()) {
                this.out().print("context.getArray(\"");
                this.out().print(name);
                this.out().print("\")");
            } else {
                this.generator.printTopicAccess();
                this.out().print(name);
            }
        } else {
            this.out().print(name);
        }
    }

    public void visitArrayAccess(MetaArrayAccess anAccess) {
        this.checkIfExistsAndArray(anAccess.accessedArray());
    }

    public void visitStructureAccess(MetaStructureAccess anAccess) {
        throw new CodegenException("Fatal Fehler: Zugriff auf Strukturen wird hier nicht unterstuetzt!");
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        this.error(anAccess, "ein Literal kann nie eine Liste sein");
    }

    private SymbolDescriptor checkIfExistsAndArray(MetaIdentifier anId) {
        if (!this.scope().isDefined(anId, this.namespace())) {
            this.error(anId, String.valueOf(anId.toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert " + "(Scope:" + this.namespace() + ")");
            return null;
        }
        SymbolDescriptor sd = this.scope().symbolDescriptor(anId, this.namespace());
        if (!sd.isArray()) {
            this.error(anId, String.valueOf(anId.toString()) + " ist keine Liste");
        }
        return sd;
    }
}

