/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.support.AbstractCodeGenerator;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaString;
import java.util.Iterator;

public class JavaScriptCodeGenerator
extends AbstractCodeGenerator {
    public static final String CONTEXT_KEY = "contextKey";
    protected CodegenContext context;

    protected void setCodegenContext(CodegenContext context) {
        this.context = context;
    }

    protected boolean hasContext() {
        String programContext = (String)this.context.getContextInfo(CONTEXT_KEY);
        return programContext != null && programContext.length() > 0;
    }

    protected void printContextAsPrefix() {
        String programContext = (String)this.context.getContextInfo(CONTEXT_KEY);
        if (programContext != null && programContext.length() > 0) {
            this.print(StringHelper.getEscapedName(programContext));
            this.print("_");
        }
    }

    protected void openBlock() {
        this.indentNewLine();
        this.out.print("{");
        this.increaseIndentLevel();
    }

    protected void closeBlock() {
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("}");
    }

    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        this.print("normArray([");
        Iterator iter = aRangeSeries.ranges();
        while (iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print("])");
    }

    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        aRange.value().accept(this);
    }

    public void visitInterval(MetaInterval aInterval) {
        this.print("new Interval(");
        aInterval.first().accept(this);
        this.print(", ");
        aInterval.last().accept(this);
        this.print(", ");
        switch (aInterval.type()) {
            case 1: {
                this.print(1);
                break;
            }
            case 2: {
                this.print(2);
                break;
            }
            case 3: {
                this.print(3);
                break;
            }
            case 4: {
                this.print(4);
            }
        }
        this.print(")");
    }

    public void visitSequence(MetaSequence aRange) {
        this.print("new Sequence(");
        aRange.first().accept(this);
        this.print(", ");
        aRange.second().accept(this);
        this.print(", ");
        aRange.last().accept(this);
        this.print(")");
    }

    public void visitLiteralAccess(MetaLiteralAccess aLiteralAccess) {
        aLiteralAccess.accessedLiteral().accept(this);
    }

    public void visitNumber(MetaNumber aNumber) {
        if (aNumber.value() == (double)aNumber.value().longValue()) {
            this.print("" + aNumber.value().longValue());
        } else {
            this.print("" + aNumber.value());
        }
    }

    public void visitSignOperator(MetaSignOperator anOperator) {
        if (anOperator.type() == 2) {
            this.print("-");
        }
        anOperator.operand().accept(this);
    }

    public void visitString(MetaString aString) {
        this.print("\"");
        this.print(StringHelper.getEscapedStringValue(aString.value()));
        this.print("\"");
    }

    public void visitDate(MetaDate aDate) {
        this.print("getAsDate");
        if (aDate.format() != null && aDate.format().length() > 0) {
            this.print("Mask");
        }
        this.print("(");
        aDate.specification().accept(this);
        if (aDate.format() != null && aDate.format().length() > 0) {
            this.print(", \"");
            this.print(aDate.format());
            this.print("\"");
        }
        this.print(")");
    }

    public void visitBoolean(MetaBoolean aBoolean) {
        if (aBoolean.value().equals(Boolean.TRUE)) {
            this.print("true");
        } else {
            this.print("false");
        }
    }

    public void visitNoValue(MetaNoValue value) {
        this.print("null");
    }
}

