/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.pl;

import de.statspez.pleditor.generator.codegen.pl.PrettyPrinterUtil;
import de.statspez.pleditor.generator.codegen.support.AbstractCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCanBeFactor;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaContextOperator;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachIndexOperator;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalOperator;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaIndexOfOperator;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaKeywordLocation;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMapStatement;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSelfAccess;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSetStatement;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaSizeTestingOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Stack;

public class PrettyPrinter
extends AbstractCodeGenerator {
    private String code;
    private PrettyPrinterUtil prettyPrinterUtil;
    private String indentSpace = "   ";
    private Stack characterPosition = null;
    private int visitedCodePosition = 0;
    private boolean lineAfterReturnToken = false;
    private int actualCharPos;

    public void setLineAfterReturnToken(boolean lineAfterReturnToken) {
        this.lineAfterReturnToken = lineAfterReturnToken;
    }

    public String generate(MetaElement program) {
        return this.generate(program, null);
    }

    public String generate(MetaElement program, String code) {
        this.code = code;
        this.characterPosition = new Stack();
        this.prettyPrinterUtil = new PrettyPrinterUtil(this.code);
        StringWriter writer = new StringWriter();
        this.setOutput(writer);
        program.accept(this);
        this.flush();
        return writer.toString();
    }

    public void print(int number) {
        super.print(number);
        this.actualCharPos += String.valueOf(number).length();
    }

    public void print(String text) {
        super.print(text);
        this.actualCharPos += text.length();
    }

    protected void newLine() {
        super.newLine();
        this.actualCharPos = 0;
    }

    protected void printParameter(Iterator parameter) {
        if (parameter != null && parameter.hasNext()) {
            this.print("(");
            while (parameter.hasNext()) {
                ((MetaElement)parameter.next()).accept(this);
                if (!parameter.hasNext()) continue;
                this.print(", ");
            }
            this.print(")");
        }
    }

    protected void printFactor(MetaFactor operand) {
        MetaKeywordLocation position;
        int i;
        Stack bracesStack = null;
        if (operand.hasBraces()) {
            bracesStack = operand.getBracesStack();
        }
        if (bracesStack != null) {
            i = bracesStack.size() - 1;
            while (i >= 0) {
                position = (MetaKeywordLocation)bracesStack.get(i);
                this.printCommentsBeforeElement(position);
                this.print("(");
                --i;
            }
        }
        operand.accept(this);
        if (bracesStack != null) {
            i = 0;
            while (i < bracesStack.size()) {
                position = (MetaKeywordLocation)bracesStack.get(i);
                this.print(")");
                this.printCommentsAfterElement(position);
                ++i;
            }
        }
    }

    protected void printTestingOperator(int type) {
        this.print(" ");
        switch (type) {
            case 1: {
                this.print("=");
                break;
            }
            case 4: {
                this.print("/=");
                break;
            }
            case 3: {
                this.print(">");
                break;
            }
            case 6: {
                this.print(">=");
                break;
            }
            case 2: {
                this.print("<");
                break;
            }
            case 5: {
                this.print("<=");
                break;
            }
            case 7: {
                this.print("IN");
            }
        }
        this.print(" ");
    }

    public void visitProgram(MetaProgram aProgram) {
        aProgram.statements().accept(this);
    }

    protected int printCommentsBeforeElement(MetaElement metaElement) {
        return this.printCommentsBeforeElement(new MetaKeywordLocation(metaElement.startLine(), metaElement.startColumn(), metaElement.endLine(), metaElement.endColumn(), false));
    }

    protected int printCommentsBeforeElement(MetaKeywordLocation location) {
        int result = -1;
        if (this.code != null) {
            int findTokenEnd;
            String allCommentsPreviousToken;
            int startColumn;
            int startLine = location.getStartLine();
            int charetPosition = this.getCharetPosition(startLine, startColumn = location.getStartColumn());
            if (charetPosition > this.visitedCodePosition && (allCommentsPreviousToken = this.prettyPrinterUtil.getAllCommentsPreviousToken(charetPosition, true)).trim().length() > 0) {
                String[] split = allCommentsPreviousToken.split("\n");
                result = split.length;
                int i = 0;
                while (i < split.length) {
                    String trim = split[i].trim();
                    this.print(trim);
                    if (i + 1 < split.length || i + 1 == split.length && allCommentsPreviousToken.charAt(allCommentsPreviousToken.length() - 1) == '\n') {
                        this.indentNewLine();
                    }
                    ++i;
                }
            }
            if ((findTokenEnd = this.prettyPrinterUtil.findTokenEnd(charetPosition)) >= this.visitedCodePosition) {
                this.visitedCodePosition = findTokenEnd;
            }
        }
        return result;
    }

    protected int printCommentsAfterElement(MetaElement metaElement) {
        return this.printCommentsAfterElement(new MetaKeywordLocation(metaElement.startLine(), metaElement.startColumn(), metaElement.endLine(), metaElement.endColumn(), false));
    }

    protected int printCommentsAfterElement(MetaKeywordLocation location) {
        int startColumn;
        int startLine;
        int charetPosition;
        int result = -1;
        if (this.code != null && (charetPosition = this.getCharetPosition(startLine = location.getEndLine(), startColumn = location.getEndColumn())) == this.visitedCodePosition) {
            String allCommentsAfterToken = this.prettyPrinterUtil.getAllCommentsAfterToken(charetPosition + 1, true);
            if (allCommentsAfterToken.trim().length() > 0) {
                String[] split = allCommentsAfterToken.split("\n");
                result = split.length;
                int i = 0;
                while (i < split.length) {
                    String trim = split[i].trim();
                    this.print(trim);
                    if (i + 1 < split.length && i != split.length - 1 && trim != "") {
                        this.indentNewLine();
                    }
                    ++i;
                }
            }
            this.visitedCodePosition = this.prettyPrinterUtil.findNextTokenPosition(charetPosition + 1);
        }
        return result;
    }

    protected void printCommentsInEmptyBraces() {
        if (this.code != null) {
            MetaStatementSequence element = new MetaStatementSequence();
            int startLine = 1;
            int startColumn = 1;
            int i = 0;
            while (i < this.visitedCodePosition) {
                char c = this.code.charAt(i);
                if (c == '\n') {
                    ++startLine;
                    startColumn = 1;
                } else {
                    ++startColumn;
                }
                ++i;
            }
            element.setSourceLocation(startLine, startColumn, startLine, startColumn);
            this.printCommentsAfterElement(element);
        }
    }

    protected int printCommentsAfterStatements(MetaElement metaElement) {
        int result = -1;
        if (this.code != null) {
            int startColumn = metaElement.endColumn();
            int startLine = metaElement.endLine();
            int charetPosition = this.getCharetPosition(startLine, startColumn);
            if (charetPosition > this.visitedCodePosition) {
                String allCommentsAfterToken = this.prettyPrinterUtil.getAllCommentsAfterToken(charetPosition + 1, false);
                if (allCommentsAfterToken.trim().length() > 0) {
                    this.indentNewLine();
                    result = 1;
                }
                this.print(allCommentsAfterToken);
                this.visitedCodePosition = this.prettyPrinterUtil.findNextTokenPosition(charetPosition + 1);
            }
        }
        return result;
    }

    protected int printCommentsBeforeStatements(MetaElement metaElement) {
        int startColumn;
        int startLine;
        int charetPosition;
        int result = -1;
        if (this.code != null && (charetPosition = this.getCharetPosition(startLine = metaElement.startLine(), startColumn = metaElement.startColumn())) > this.visitedCodePosition) {
            String allCommentsPreviousToken = this.prettyPrinterUtil.getAllCommentsPreviousToken(charetPosition, false);
            this.print(allCommentsPreviousToken);
            if (allCommentsPreviousToken.trim().length() > 0) {
                this.indentNewLine();
                result = 1;
            }
            this.visitedCodePosition = this.prettyPrinterUtil.findTokenEnd(charetPosition);
        }
        return result;
    }

    public void visitStatementSequence(MetaStatementSequence aSequence) {
        Iterator iter = aSequence.statements();
        while (iter != null && iter.hasNext()) {
            this.indent();
            MetaElement metaElement = (MetaElement)iter.next();
            this.printCommentsBeforeStatements(metaElement);
            metaElement.accept(this);
            this.printCommentsAfterStatements(metaElement);
            if (!iter.hasNext()) continue;
            this.newLine();
        }
    }

    private int getCharetPosition(int startLine, int startColumn) {
        int line = 1;
        if (line == startLine) {
            if (startColumn == 0) {
                return 0;
            }
            return startColumn - 1;
        }
        int i = 0;
        while (i < this.code.length()) {
            if (line == startLine) {
                return i + startColumn - 1;
            }
            if (this.code.charAt(i) == '\n') {
                ++line;
            }
            ++i;
        }
        return 0;
    }

    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        this.print("VAR ");
        Iterator iter = aDeclaration.identifiers();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
    }

    public void visitErrorStatement(MetaErrorStatement aStatement) {
        this.printCommentsBeforeElement(aStatement);
        this.print("FEHLER");
        this.printCommentsAfterElement(aStatement);
        if (aStatement.errorNumber() != 0) {
            this.print(" ");
            MetaNumber metaNumber = aStatement.getMetaNumber();
            if (metaNumber != null) {
                this.printCommentsBeforeElement(metaNumber);
            }
            this.print(aStatement.errorNumber());
            if (metaNumber != null) {
                this.printCommentsAfterElement(metaNumber);
            }
        }
    }

    public void visitMapStatement(MetaMapStatement aStatement) {
        this.print("MAPPEN");
    }

    public void visitReturnStatement(MetaReturnStatement aStatement) {
        this.print("RUECKGABE");
        if (this.lineAfterReturnToken) {
            this.newLine();
        } else {
            this.print(" ");
        }
        aStatement.returnValue().accept(this);
    }

    public void visitPrintStatement(MetaPrintStatement aStatement) {
        this.print("GIB ");
        Iterator iter = aStatement.toPrint();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(" AUS");
        if (aStatement.leftValue() != null) {
            this.print(" NACH ");
            aStatement.leftValue().accept(this);
        }
    }

    public void visitFunctionCall(MetaFunctionCall aStatement) {
        this.printCommentsBeforeElement(aStatement);
        if (aStatement.isProperty()) {
            if (aStatement.isUsingPropertyKeyword()) {
                this.print("EIGENSCHAFT ");
            } else {
                this.print("IST ");
            }
            aStatement.function().accept(this);
        } else {
            if (aStatement.isUsingAmpersand()) {
                this.print("&");
            } else {
                this.print("FUNKTION ");
            }
            aStatement.function().accept(this);
            this.print("(");
            Iterator iter = aStatement.parameters();
            if (!iter.hasNext()) {
                this.printCommentsInEmptyBraces();
            }
            while (iter != null && iter.hasNext()) {
                ((MetaElement)iter.next()).accept(this);
                if (!iter.hasNext()) continue;
                this.print(", ");
            }
            this.print(")");
            this.printCommentsAfterElement(aStatement);
        }
    }

    public void visitAblaufStatement(MetaAblaufStatement aStatement) {
        if (aStatement.function().adaptedObject() instanceof MetaStructureAccess) {
            MetaStructureAccess structureAccess = (MetaStructureAccess)aStatement.function().adaptedObject();
            this.print("THEMENBEREICH ");
            structureAccess.structureAccess().accept(this);
            MetaKeywordLocation locationForKeywordWidth = aStatement.getLocationForKeywordWidth();
            this.printCommentsBeforeElement(locationForKeywordWidth);
            this.print(" MIT");
            this.printCommentsAfterElement(locationForKeywordWidth);
            this.print(" ABLAUF ");
            structureAccess.selectedElement().accept(this);
        } else {
            this.print("ABLAUF ");
            aStatement.function().accept(this);
        }
        this.printParameter(aStatement.parameters());
    }

    public void visitPruefeStatement(MetaPruefeStatement aStatement) {
        this.print("PRUEFE ");
        aStatement.function().accept(this);
    }

    public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
        this.print("FELD ");
        aStatement.field().accept(this);
    }

    public void visitWhileLoop(MetaWhileLoop aStatement) {
        this.printCommentsBeforeElement(aStatement);
        this.print("WIEDERHOLE");
        this.printCommentsAfterElement(aStatement);
        this.print(" SOLANGE ");
        aStatement.condition().accept(this);
        this.increaseIndentLevel();
        this.newLine();
        aStatement.loopBody().accept(this);
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("ENDE");
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        MetaNumber number;
        MetaLiteralAccess literalAccess;
        this.print("WIEDERHOLE");
        this.printCommentsAfterElement(aStatement);
        this.print(" ");
        this.print("FUER ");
        aStatement.startAssignment().accept(this);
        this.print(" BIS ");
        aStatement.endCondition().accept(this);
        boolean defaultStepExpression = false;
        if (aStatement.stepExpression().adaptedObject() instanceof MetaLiteralAccess && (literalAccess = (MetaLiteralAccess)aStatement.stepExpression().adaptedObject()).accessedLiteral() instanceof MetaNumber && (number = (MetaNumber)literalAccess.accessedLiteral()).value() == 1.0) {
            defaultStepExpression = true;
        }
        if (!defaultStepExpression) {
            this.print(" SCHRITTWEITE ");
            aStatement.stepExpression().accept(this);
        }
        this.increaseIndentLevel();
        this.newLine();
        aStatement.loopBody().accept(this);
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("ENDE");
    }

    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.print("FUER ");
        MetaKeywordLocation locationKeywordEvery = aStatement.getLocationKeywordEvery();
        this.printCommentsBeforeElement(locationKeywordEvery);
        this.print("JEDES ");
        this.printCommentsAfterElement(locationKeywordEvery);
        Iterator iter = aStatement.variables();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(" IN ");
        aStatement.value().accept(this);
        if (aStatement.restrictions() != null && !aStatement.restrictions().isEmpty()) {
            this.print(" ");
            iter = aStatement.restrictions().iterator();
            while (iter != null && iter.hasNext()) {
                MetaElement restriction = (MetaElement)iter.next();
                if (restriction != null) {
                    restriction.accept(this);
                } else {
                    this.print("ALLE");
                }
                if (!iter.hasNext()) continue;
                this.print(", ");
            }
        }
        this.increaseIndentLevel();
        this.newLine();
        aStatement.loopBody().accept(this);
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("ENDE");
    }

    public void visitForEachCheck(MetaForEachCheck aStatement) {
        this.printCommentsBeforeElement(aStatement);
        this.print("FUER ");
        MetaKeywordLocation locationKeywordEvery = aStatement.getLocationKeywordEvery();
        this.printCommentsBeforeElement(locationKeywordEvery);
        this.print("JEDES ");
        this.printCommentsAfterElement(locationKeywordEvery);
        Iterator iter = aStatement.variables();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(" IN ");
        aStatement.value().accept(this);
        if (aStatement.restrictions() != null && !aStatement.restrictions().isEmpty()) {
            this.print(" ");
            iter = aStatement.restrictions().iterator();
            while (iter != null && iter.hasNext()) {
                MetaElement restriction = (MetaElement)iter.next();
                if (restriction != null) {
                    restriction.accept(this);
                } else {
                    this.print("ALLE");
                }
                if (!iter.hasNext()) continue;
                this.print(", ");
            }
        }
        MetaKeywordLocation locationKeywordGilt = aStatement.getLocationKeywordGilt();
        this.printCommentsBeforeElement(locationKeywordGilt);
        this.print(" GILT");
        this.printCommentsAfterElement(locationKeywordGilt);
        this.print(" (");
        aStatement.condition().accept(this);
        this.print(")");
        this.printCommentsAfterElement(aStatement);
    }

    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        this.print("FUER ");
        aStatement.value().accept(this);
        this.increaseIndentLevel();
        this.newLine();
        aStatement.loopBody().accept(this);
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("ENDE");
    }

    public void visitBreakStatement(MetaBreakStatement aStatement) {
        this.print("ABBRUCH");
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        this.print("WENN ");
        aStatement.condition().accept(this);
        MetaKeywordLocation thenLocation = aStatement.getThenLocation();
        if (thenLocation != null) {
            this.printCommentsBeforeElement(thenLocation);
        }
        this.print(" DANN");
        this.increaseIndentLevel();
        this.newLine();
        aStatement.ifTrue().accept(this);
        this.decreaseIndentLevel();
        if (aStatement.ifFalse().numberOfStatements() > 0) {
            this.indentNewLine();
            this.print("SONST");
            this.increaseIndentLevel();
            this.newLine();
            aStatement.ifFalse().accept(this);
            this.decreaseIndentLevel();
        }
        this.indentNewLine();
        this.print("ENDE");
    }

    protected void printAssignmentLeftValue(MetaValueAccess leftValue) {
        leftValue.accept(this);
    }

    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        this.printAssignmentLeftValue(anAssignment.leftValue());
        this.print(" := ");
        if (anAssignment.rightValue().value() instanceof MetaFactor) {
            this.printFactor((MetaFactor)anAssignment.rightValue().value());
        } else {
            anAssignment.rightValue().accept(this);
        }
    }

    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
        Iterator iter = anAssignment.leftValues();
        while (iter != null && iter.hasNext()) {
            this.printAssignmentLeftValue((MetaValueAccess)iter.next());
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(" := ");
        if (anAssignment.rightValue().value() instanceof MetaFactor) {
            this.printFactor((MetaFactor)anAssignment.rightValue().value());
        } else {
            anAssignment.rightValue().accept(this);
        }
    }

    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        boolean breakLine = false;
        if (anOperator.firstOperand().adaptedObject() instanceof MetaBooleanOperator) {
            MetaCanBeFactor secOperator;
            MetaBooleanOperator operator = (MetaBooleanOperator)anOperator.firstOperand().adaptedObject();
            if (operator.type() == anOperator.type() || operator.firstOperand().adaptedObject() instanceof MetaBooleanOperator && ((MetaBooleanOperator)operator.firstOperand().adaptedObject()).type() != 0) {
                breakLine = true;
            }
            if (operator.secondOperand() != null && operator.secondOperand().adaptedObject() instanceof MetaBooleanOperator && !((secOperator = operator.secondOperand().adaptedObject()) instanceof MetaTestingOperator)) {
                breakLine = true;
            }
        } else if (this.characterPosition.empty()) {
            this.characterPosition.push(new Integer(this.actualCharPos));
        }
        this.printFactor(anOperator.firstOperand());
        if (breakLine) {
            this.indentNewLine();
            this.charIndent();
        } else {
            this.print(" ");
        }
        boolean removeFromStack = false;
        switch (anOperator.type()) {
            case 1: {
                this.characterPosition.push(new Integer(5));
                this.print("UND");
                removeFromStack = true;
                break;
            }
            case 2: {
                this.characterPosition.push(new Integer(5));
                this.print("ODER");
                removeFromStack = true;
            }
        }
        this.print(" ");
        this.printFactor(anOperator.secondOperand());
        if (removeFromStack) {
            this.characterPosition.pop();
        }
    }

    public void charIndent() {
        Iterator iterator = this.characterPosition.iterator();
        int position = 0;
        while (iterator.hasNext()) {
            Integer character = (Integer)iterator.next();
            position += character.intValue();
        }
        int i = 0;
        while (i < position) {
            this.print(" ");
            ++i;
        }
    }

    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        int startColumn = anOperator.startColumn();
        int startLine = anOperator.startLine();
        MetaKeywordLocation keywordLocation = new MetaKeywordLocation(startLine, startColumn, startLine, startColumn + "NICHT".length() - 1, false);
        this.printCommentsBeforeElement(anOperator);
        this.print("NICHT ");
        this.printCommentsAfterElement(keywordLocation);
        this.printFactor(anOperator.operand());
    }

    public void visitTestingOperator(MetaTestingOperator anOperator) {
        this.printFactor(anOperator.firstOperand());
        this.printTestingOperator(anOperator.type());
        this.printFactor(anOperator.secondOperand());
    }

    public void visitMathOperator(MetaMathOperator anOperator) {
        this.printFactor(anOperator.firstOperand());
        this.print(" ");
        switch (anOperator.type()) {
            case 1: {
                this.print("+");
                break;
            }
            case 2: {
                this.print("-");
                break;
            }
            case 4: {
                this.print("*");
                break;
            }
            case 3: {
                this.print("/");
            }
        }
        this.print(" ");
        this.printFactor(anOperator.secondOperand());
    }

    public void visitSignOperator(MetaSignOperator anOperator) {
        this.printCommentsBeforeElement(anOperator);
        if (anOperator.type() == 2) {
            this.print("-");
        }
        this.printFactor(anOperator.operand());
    }

    public void visitTypeCheck(MetaTypeCheck anOperator) {
        anOperator.value().accept(this);
        this.printCommentsBeforeElement(anOperator);
        this.print(" HAT");
        this.printCommentsAfterElement(anOperator);
        this.print(" TYP ");
        MetaKeywordLocation constantLocation = anOperator.getConstantLocation();
        if (constantLocation != null) {
            this.printCommentsBeforeElement(constantLocation);
        }
        switch (anOperator.type()) {
            case 1: {
                this.print("KOMMAZAHL");
                break;
            }
            case 5: {
                this.print("GANZZAHL");
                break;
            }
            case 2: {
                this.print("ZEICHENKETTE");
                break;
            }
            case 3: 
            case 4: {
                this.print("DATUM");
                break;
            }
            case 6: {
                this.print("KATEGORIE");
                break;
            }
            case 7: {
                this.print("WAHRHEITSWERT");
            }
        }
        if (constantLocation != null) {
            this.printCommentsAfterElement(constantLocation);
        }
        if (anOperator.maske() != null) {
            this.print("(");
            MetaKeywordLocation maskLocation = anOperator.getMaskLocation();
            if (maskLocation != null) {
                this.printCommentsBeforeElement(maskLocation);
            }
            anOperator.maske().accept(this);
            if (maskLocation != null) {
                this.printCommentsAfterElement(maskLocation);
            }
            this.print(")");
        }
    }

    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        MetaKeywordLocation keywordLocation = new MetaKeywordLocation(anOperator.startLine(), anOperator.startColumn(), anOperator.startLine(), anOperator.startColumn() + "ANZAHL".length() - 1, false);
        this.printCommentsBeforeElement(keywordLocation);
        this.print("ANZAHL");
        this.printCommentsAfterElement(keywordLocation);
        this.print(" VON ");
        anOperator.operand().accept(this);
    }

    public void visitSetStatement(MetaSetStatement aSetStatemnt) {
        String statement = "";
        if (aSetStatemnt.getType() == MetaSetStatement.APPEND) {
            statement = " ANLEGEN ";
        } else if (aSetStatemnt.getType() == MetaSetStatement.DELETE) {
            statement = " LOESCHEN ";
        }
        MetaKeywordLocation keywordLocation = new MetaKeywordLocation(aSetStatemnt.startLine(), aSetStatemnt.startColumn(), aSetStatemnt.startLine(), aSetStatemnt.startColumn() + "SATZ".length() - 1, false);
        this.printCommentsBeforeElement(keywordLocation);
        this.print("SATZ");
        this.printCommentsAfterElement(keywordLocation);
        this.print(statement);
        aSetStatemnt.getFactor().accept(this);
    }

    public void visitSizeTestingOperator(MetaSizeTestingOperator anOperator) {
        MetaNumber number;
        MetaLiteralAccess literalAccess;
        MetaKeywordLocation existenceLocation = anOperator.getExistenceLocation();
        if (existenceLocation != null) {
            this.printCommentsBeforeElement(existenceLocation);
        }
        this.print("EXISTIERT ");
        if (existenceLocation != null) {
            this.printCommentsAfterElement(existenceLocation);
        }
        boolean defaultTestingOperator = false;
        if (anOperator.type() == 1 && anOperator.firstOperand().adaptedObject() instanceof MetaLiteralAccess && (literalAccess = (MetaLiteralAccess)anOperator.firstOperand().adaptedObject()).accessedLiteral() instanceof MetaNumber && (number = (MetaNumber)literalAccess.accessedLiteral()).value() == 1.0) {
            defaultTestingOperator = true;
        }
        if (!defaultTestingOperator) {
            switch (anOperator.type()) {
                case 1: {
                    this.print("MINDESTENS");
                    break;
                }
                case 2: {
                    this.print("GENAU");
                    break;
                }
                case 3: {
                    this.print("HOECHSTENS");
                }
            }
            this.print(" ");
            anOperator.firstOperand().accept(this);
            this.print(" ");
        }
        anOperator.secondOperand().accept(this);
    }

    public void visitHierarchicalOperator(MetaHierarchicalOperator anOperator) {
        MetaKeywordLocation operatorLocation = anOperator.getOperatorLocation();
        if (operatorLocation != null) {
            this.printCommentsBeforeElement(operatorLocation);
        }
        switch (anOperator.type()) {
            case 1: {
                this.print("IDENTISCH");
                break;
            }
            case 2: {
                this.print("MIN");
                break;
            }
            case 3: {
                this.print("MAX");
                break;
            }
            case 4: {
                this.print("SUMME");
                break;
            }
            case 5: {
                this.print("MITTEL");
                break;
            }
            case 6: {
                this.print("MEDIAN");
                break;
            }
            case 7: {
                this.print("VARIANZ");
                break;
            }
            case 8: {
                this.print("STABW");
            }
        }
        if (operatorLocation != null) {
            this.printCommentsAfterElement(operatorLocation);
        }
        this.print(" ");
        anOperator.operand().accept(this);
    }

    public void visitIndexOfOperator(MetaIndexOfOperator anOperator) {
        this.printCommentsBeforeElement(anOperator);
        this.print("INDEX ");
        MetaKeywordLocation locationKeywordVon = anOperator.getLocationKeywordVon();
        this.printCommentsBeforeElement(locationKeywordVon);
        this.print("VON");
        this.printCommentsAfterElement(locationKeywordVon);
        this.print(" ");
        anOperator.operand().accept(this);
    }

    public void visitContextOperator(MetaContextOperator anOperator) {
        if (anOperator.type() == 1) {
            MetaKeywordLocation operatorLocation = anOperator.getOperatorLocation();
            this.printCommentsBeforeElement(operatorLocation);
            this.print("GLOBAL ");
            this.printCommentsAfterElement(operatorLocation);
        }
        anOperator.operand().accept(this);
    }

    protected void printStructureSelectedElement(MetaStructureAccess aStructureAccess) {
        aStructureAccess.selectedElement().accept(this);
    }

    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        aStructureAccess.structureAccess().accept(this);
        this.print(".");
        this.printStructureSelectedElement(aStructureAccess);
    }

    protected void printIndex(MetaFactor index) {
        this.print("[");
        MetaKeywordLocation braces = null;
        if (index.getBracesStack().size() > 0) {
            braces = (MetaKeywordLocation)index.getBracesStack().pop();
        }
        if (braces != null) {
            this.printCommentsBeforeElement(braces);
        }
        if (index != null) {
            this.printFactor(index);
        }
        this.print("]");
        if (braces != null) {
            this.printCommentsAfterElement(braces);
        }
    }

    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        anArrayAccess.accessedArray().accept(this);
        Iterator iter = anArrayAccess.indices();
        while (iter != null && iter.hasNext()) {
            this.printIndex((MetaFactor)iter.next());
        }
    }

    public void visitForEachIndexOperand(MetaForEachIndexOperator aForEachIndexOperand) {
        this.printCommentsBeforeElement(aForEachIndexOperand);
        this.print("ALLE");
        this.printCommentsAfterElement(aForEachIndexOperand);
    }

    public void visitWithOperator(MetaWithOperator anOperator) {
        this.printCommentsBeforeElement(anOperator);
        this.print("MIT ");
        anOperator.operand().accept(this);
        this.printCommentsAfterElement(anOperator);
    }

    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        this.printCommentsBeforeElement(aFieldAccess);
        aFieldAccess.accessedField().accept(this);
        this.printCommentsAfterElement(aFieldAccess);
    }

    public void visitSelfAccess(MetaSelfAccess aSelfAccess) {
        this.printCommentsBeforeElement(aSelfAccess);
        this.print("WERT");
        this.printCommentsAfterElement(aSelfAccess);
    }

    public void visitClassificationReference(MetaClassificationReference aReference) {
        this.printCommentsBeforeElement(aReference);
        this.print("#");
        Iterator iter = aReference.levels();
        while (iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(".");
        }
        this.printCommentsAfterElement(aReference);
    }

    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        this.printCommentsBeforeElement(anAccess);
        this.print("MATERIAL ");
        anAccess.material().accept(this);
        this.print("(");
        Iterator iter = anAccess.selectionConditions();
        if (!iter.hasNext() && !anAccess.selectedFields().hasNext()) {
            this.printCommentsInEmptyBraces();
        }
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (iter.hasNext()) {
                this.print(", ");
                continue;
            }
            this.print("; ");
        }
        iter = anAccess.selectedFields();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(")");
        this.printCommentsAfterElement(anAccess);
    }

    public void visitIdentifier(MetaIdentifier anIdentifier) {
        this.printCommentsBeforeElement(anIdentifier);
        this.print(anIdentifier.value());
        this.printCommentsAfterElement(anIdentifier);
    }

    public void visitLiteralAccess(MetaLiteralAccess aLiteralAccess) {
        this.printCommentsBeforeElement(aLiteralAccess);
        aLiteralAccess.accessedLiteral().accept(this);
        this.printCommentsAfterElement(aLiteralAccess);
    }

    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        this.printCommentsBeforeElement(aRangeSeries);
        if (aRangeSeries.isKeywordPresent()) {
            this.print("REIHE");
            MetaKeywordLocation bracePosition = aRangeSeries.getBracePosition();
            this.printCommentsBeforeElement(bracePosition);
            this.print("(");
            this.printCommentsAfterElement(bracePosition);
        } else {
            this.print("{");
        }
        Iterator iter = aRangeSeries.ranges();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        if (aRangeSeries.isKeywordPresent()) {
            this.print(")");
        } else {
            this.print("}");
        }
        this.printCommentsAfterElement(aRangeSeries);
    }

    public void visitInterval(MetaInterval anInterval) {
        anInterval.first().accept(this);
        switch (anInterval.type()) {
            case 4: {
                this.print("++");
                break;
            }
            case 3: {
                this.print("+-");
                break;
            }
            case 2: {
                this.print("-+");
                break;
            }
            case 1: {
                this.print("--");
            }
        }
        anInterval.last().accept(this);
    }

    public void visitSequence(MetaSequence aSequence) {
        aSequence.first().accept(this);
        this.print(", ");
        aSequence.second().accept(this);
        this.print("..");
        aSequence.last().accept(this);
    }

    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        aRange.value().accept(this);
    }

    public void visitNumber(MetaNumber aNumber) {
        this.printCommentsBeforeElement(aNumber);
        this.print(aNumber.getMyStringValue());
        this.printCommentsAfterElement(aNumber);
    }

    public void visitString(MetaString aString) {
        this.printCommentsBeforeElement(aString);
        this.print("'");
        this.print(CodegenUtil.getEscapedStringLiteral(aString.value()));
        this.print("'");
        this.printCommentsAfterElement(aString);
    }

    public void visitBoolean(MetaBoolean aBoolean) {
        this.printCommentsBeforeElement(aBoolean);
        if (aBoolean.value().booleanValue()) {
            this.print("WAHR");
        } else {
            this.print("FALSCH");
        }
        this.printCommentsAfterElement(aBoolean);
    }

    public void visitDate(MetaDate aDate) {
        this.printCommentsBeforeElement(aDate);
        this.print("DATUMSWERT");
        MetaKeywordLocation leftParenLocation = aDate.getLeftParenLocation();
        this.printCommentsBeforeElement(leftParenLocation);
        this.print("(");
        this.printCommentsAfterElement(leftParenLocation);
        aDate.specification().accept(this);
        if (aDate.format() != null && aDate.format().length() > 0) {
            this.print(", ");
            MetaKeywordLocation formatLocation = aDate.getFormatLocation();
            this.printCommentsBeforeElement(formatLocation);
            this.print("'");
            this.print(CodegenUtil.getEscapedStringLiteral(aDate.format()));
            this.print("'");
            this.printCommentsAfterElement(formatLocation);
        }
        this.print(")");
        this.printCommentsAfterElement(aDate);
    }

    public void visitNoValue(MetaNoValue value) {
        this.printCommentsBeforeElement(value);
        this.print("LEER");
        this.printCommentsAfterElement(value);
    }

    protected void indent() {
        int i = 0;
        while (i < this.indentLevel()) {
            this.out.print(this.indentSpace);
            ++i;
        }
    }

    public void setIndentSpace(String indentSpace) {
        this.indentSpace = indentSpace;
    }

    public String getIndentSpace() {
        return this.indentSpace;
    }
}

