/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Array;
import de.statspez.pleditor.generator.runtime.BasePlausi;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.GlobalVariable;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.ProgramSectionContext;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.Variable;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.Logger;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.HashMap;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;

public class PlausiRuntimeContext {
    private static final String LINE_SEPARATOR;
    private BasePlausi plausi = null;
    private SatzInterface satz = null;
    private PlausiKontext plausiKontext = null;
    private FeldDeskriptorImpl currentField = null;
    private Stack sectionContextStack = new Stack();
    private HashMap globalValues = new HashMap();
    private boolean checkArrayIndices = true;
    private boolean readConstArrayLength = false;
    private boolean accessValueAsString = false;
    private Random random;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.runtime.PlausiRuntimeContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        LINE_SEPARATOR = System.getProperty("line.separator");
    }

    public PlausiRuntimeContext(BasePlausi plausi) {
        if (!$assertionsDisabled && plausi == null) {
            throw new AssertionError((Object)"plausi ist null");
        }
        this.plausi = plausi;
    }

    public BasePlausi getPlausi() {
        return this.plausi;
    }

    public PlausiKontext getPlausiKontext() {
        return this.plausiKontext;
    }

    public SatzInterface getSatz() {
        return this.satz;
    }

    public void setPlausiKontext(PlausiKontext kontext) {
        this.plausiKontext = kontext;
    }

    public void setSatz(SatzInterface satz) {
        this.satz = satz;
    }

    public void setCurrentField(FeldDeskriptorImpl field) {
        this.currentField = field;
    }

    public FeldDeskriptorImpl getCurrentField() {
        return this.currentField;
    }

    public boolean isCheckArrayIndices() {
        boolean isCheckArrayIndices = this.checkArrayIndices;
        if (this.plausiKontext != null) {
            isCheckArrayIndices = this.plausiKontext.isPruefeArrayIndexZugriffe();
        }
        return isCheckArrayIndices;
    }

    public void setCheckArrayIndices(boolean checkArrayIndices) {
        this.checkArrayIndices = checkArrayIndices;
    }

    public boolean isReadConstArrayLength() {
        return this.readConstArrayLength;
    }

    public void setReadConstArrayLength(boolean readConstArrayLength) {
        this.readConstArrayLength = readConstArrayLength;
    }

    public FeldDeskriptorInterface lastAccessedField() {
        ProgramSectionContext currentSection = this.currentSectionContext();
        FeldDeskriptorInterface field = null;
        while (field == null && currentSection != null) {
            field = currentSection.lastAccessedField();
            currentSection = currentSection.parentContext();
        }
        return field;
    }

    public Logger getLogger() {
        Logger logger = null;
        if (this.plausiKontext != null) {
            logger = this.plausiKontext.getLogger();
        }
        if (logger == null) {
            logger = this.plausi.logger();
        }
        return logger;
    }

    public ProgramSectionContext currentSectionContext() {
        ProgramSectionContext context = null;
        if (this.sectionContextStack.size() > 0) {
            context = (ProgramSectionContext)this.sectionContextStack.peek();
        }
        return context;
    }

    public void startNewPruefSection(String section) {
        ProgramSectionContext context = new ProgramSectionContext(section, this.currentSectionContext(), true);
        this.sectionContextStack.push(context);
        this.getLogger().trace("--> " + context.section());
    }

    public void startNewSection(String section) {
        ProgramSectionContext context = new ProgramSectionContext(section, this.currentSectionContext());
        this.sectionContextStack.push(context);
        this.getLogger().trace("--> " + context.section());
    }

    public void leaveCurrentSection() {
        if (!$assertionsDisabled && this.sectionContextStack.isEmpty()) {
            throw new AssertionError((Object)"Keine Abschnitts-Kontexte mehr.");
        }
        ProgramSectionContext context = (ProgramSectionContext)this.sectionContextStack.pop();
        this.getLogger().trace("<-- " + context.section());
    }

    public void writeSectionInfosToError(PlausiFehler error) {
        ProgramSectionContext context = this.currentSectionContext();
        Vector<String> abschnitte = new Vector<String>();
        ProgramSectionContext currentContext = context;
        while (currentContext != null) {
            String abschnittInfo = currentContext.section();
            if (abschnittInfo == null) {
                abschnittInfo = "Unbekannter Plausi-Abschnitt";
            }
            abschnitte.add(abschnittInfo);
            currentContext = currentContext.parentContext();
        }
        error.setAbschnittInfos(abschnitte.toArray(new String[0]));
        error.setFelder(context.felderSortiertNachZugriff());
    }

    public void defineVariable(String name, Variable variable) {
        if (!$assertionsDisabled && this.sectionContextStack.isEmpty()) {
            throw new AssertionError((Object)"Keine Abschnitts-Kontext definiert.");
        }
        this.currentSectionContext().defineVariable(name, variable);
    }

    public Variable getVariable(String name) {
        if (!$assertionsDisabled && this.sectionContextStack.isEmpty()) {
            throw new AssertionError((Object)"Keine Abschnitts-Kontext definiert.");
        }
        return this.currentSectionContext().getVariable(name);
    }

    public void defineArray(String name, Array array) {
        if (!$assertionsDisabled && this.sectionContextStack.isEmpty()) {
            throw new AssertionError((Object)"Keine Abschnitts-Kontext definiert.");
        }
        this.currentSectionContext().defineArray(name, array);
    }

    public Array getArray(String name) {
        if (!$assertionsDisabled && this.sectionContextStack.isEmpty()) {
            throw new AssertionError((Object)"Keine Abschnitts-Kontext definiert.");
        }
        return this.currentSectionContext().getArray(name);
    }

    public void setGlobalValue(GlobalVariable variable, Value value) {
        this.globalValues.put(variable, value);
    }

    public Value getGlobalValue(GlobalVariable variable) {
        Value globalValue = (Value)this.globalValues.get(variable);
        if (globalValue == null) {
            globalValue = NilValue.instance();
        }
        return globalValue;
    }

    public void print(String aString) {
        this.getLogger().trace(aString);
    }

    public void println(String aString) {
        this.getLogger().trace(String.valueOf(aString) + LINE_SEPARATOR);
    }

    public void printErr(String aString) {
        this.getLogger().error(aString);
    }

    public void printlnErr(String aString) {
        this.getLogger().error(String.valueOf(aString) + LINE_SEPARATOR);
    }

    public void setAccessValueAsString(boolean accessValueAsString) {
        this.accessValueAsString = accessValueAsString;
    }

    public boolean isAccessValueAsString() {
        return this.accessValueAsString;
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }
}

