/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test;

import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import java.io.FileReader;
import junit.framework.TestCase;

public class ILParserTest
extends TestCase {
    public static final String TEST_FILE = "src/de/statspez/pleditor/generator/test/ILTestDocument.xml";
    private MetaPlausibilisierung plausi = null;

    public ILParserTest(String arg0) {
        super(arg0);
    }

    public void test_01_plausi() {
        ILParserTest.assertTrue((boolean)(this.plausi instanceof MetaCustomPlausibilisierung));
        ILParserTest.assertEquals((String)"EinfachePlausi", (String)this.plausi.getPLName());
        ILParserTest.assertEquals((int)1, (int)this.plausi.sizeOfMerkmale());
        ILParserTest.assertEquals((int)3, (int)this.plausi.sizeOfThemenbereiche());
        ILParserTest.assertSame((Object)((MetaCustomPlausibilisierung)this.plausi).rootThemenbereich(), (Object)this.plausi.getFromThemenbereiche(0));
    }

    public void test_02_merkmal1() {
        MetaMerkmal merkmal = this.plausi.getFromMerkmale(0);
        ILParserTest.assertEquals((String)"EineZahl", (String)merkmal.getName());
        ILParserTest.assertEquals((int)1, (int)merkmal.getTyp());
        ILParserTest.assertEquals((long)8L, (long)merkmal.getLaenge());
        ILParserTest.assertEquals((String)"Wie lautet Ihre Lieblingszahl?", (String)merkmal.getFrage());
        ILParserTest.assertEquals((String)"Lieblings-Zahl", (String)merkmal.getBezeichnung());
        ILParserTest.assertEquals((boolean)true, (boolean)merkmal.getLeer());
        ILParserTest.assertEquals((boolean)false, (boolean)merkmal.getVerweigerung());
        ILParserTest.assertEquals((boolean)true, (boolean)merkmal.getNichtWissen());
        ILParserTest.assertEquals((String)"Ihre Lieblings-Zahl ist ungueltig.", (String)merkmal.getFehlertextKurz());
        ILParserTest.assertEquals((String)"Ihre Lieblingszahl ist ungueltig, weil sie ausserhalb des gueltigen Wertebereichs liegt.", (String)merkmal.getFehlertextLang());
        ILParserTest.assertEquals((String)"Sie muessen sich leider eine neue Lieblingszahl ausdenken, die innerhalb des Wertebereichs liegt.", (String)merkmal.getKorrekturhinweis());
    }

    public void test_04_themenbereich1() {
        ILParserTest.assertTrue((boolean)(this.plausi.getFromThemenbereiche(0) instanceof MetaCustomThemenbereich));
        MetaCustomThemenbereich tb = (MetaCustomThemenbereich)this.plausi.getFromThemenbereiche(0);
        ILParserTest.assertEquals((String)"EinThemenbereich", (String)tb.getName());
        ILParserTest.assertEquals((int)1, (int)tb.sizeOfFunktionen());
        ILParserTest.assertEquals((int)1, (int)tb.sizeOfAblaeufe());
        ILParserTest.assertEquals((int)2, (int)tb.sizeOfFelder());
        ILParserTest.assertEquals((int)1, (int)tb.sizeOfPruefungen());
        ILParserTest.assertEquals((int)4, (int)tb.sizeOfVariablen());
        ILParserTest.assertEquals((int)2, (int)tb.sizeOfInitialisierungswerte());
    }

    public void test_05_themenbreich2() {
        ILParserTest.assertTrue((boolean)(this.plausi.getFromThemenbereiche(1) instanceof MetaCustomThemenbereich));
        MetaCustomThemenbereich tb = (MetaCustomThemenbereich)this.plausi.getFromThemenbereiche(1);
    }

    public void test_06_tb1_feld1() {
        ILParserTest.assertTrue((boolean)(this.plausi.getFromThemenbereiche(0).getFromFelder(0) instanceof MetaCustomTBFeld));
        MetaCustomTBFeld feld = (MetaCustomTBFeld)this.plausi.getFromThemenbereiche(0).getFromFelder(0);
        MetaThemenbereich refTb = this.plausi.getFromThemenbereiche(1);
        ILParserTest.assertSame((Object)feld.getThemenbereich(), (Object)this.plausi.getFromThemenbereiche(0));
        ILParserTest.assertEquals((String)"EinFeld", (String)feld.getName());
        ILParserTest.assertEquals((int)2, (int)feld.getArt());
        ILParserTest.assertNotNull((Object)feld.getKlasse());
        ILParserTest.assertTrue((feld.getKlasse() == refTb ? 1 : 0) != 0);
    }

    public void test_07_tb1_feld2() {
        ILParserTest.assertTrue((boolean)(this.plausi.getFromThemenbereiche(0).getFromFelder(1) instanceof MetaCustomTBFeld));
        MetaCustomTBFeld feld = (MetaCustomTBFeld)this.plausi.getFromThemenbereiche(0).getFromFelder(1);
        MetaMerkmal refMerkmal = this.plausi.getFromMerkmale(0);
        ILParserTest.assertSame((Object)feld.getThemenbereich(), (Object)this.plausi.getFromThemenbereiche(0));
        ILParserTest.assertEquals((String)"Zahl", (String)feld.getName());
        ILParserTest.assertEquals((int)1, (int)feld.getArt());
        ILParserTest.assertNotNull((Object)feld.getKlasse());
        ILParserTest.assertTrue((feld.getKlasse() == refMerkmal ? 1 : 0) != 0);
    }

    public void test_08_tb1_pruefung1() {
        ILParserTest.assertTrue((boolean)(this.plausi.getFromThemenbereiche(0).getFromPruefungen(0) instanceof MetaCustomPruefung));
        MetaCustomPruefung pruefung = (MetaCustomPruefung)this.plausi.getFromThemenbereiche(0).getFromPruefungen(0);
        ILParserTest.assertSame((Object)pruefung.getThemenbereich(), (Object)this.plausi.getFromThemenbereiche(0));
        ILParserTest.assertEquals((String)"PRUEF01", (String)pruefung.getPruefschluessel());
        ILParserTest.assertEquals((long)1L, (long)pruefung.getLfdNr());
        ILParserTest.assertEquals((int)1, (int)pruefung.getMethodenKategorieID());
        ILParserTest.assertEquals((int)1, (int)pruefung.getPruefungsart());
        ILParserTest.assertEquals((int)9, (int)pruefung.getFehlergewicht());
        ILParserTest.assertNotNull((Object)pruefung.getPLSpezifikation());
        ILParserTest.assertTrue((pruefung.getPLSpezifikation().trim().length() > 0 ? 1 : 0) != 0);
        ILParserTest.assertEquals((String)"Fehler in Pruefung PRUEF01.", (String)pruefung.getFehlertextKurz());
        ILParserTest.assertEquals((String)"Es ist ein ganz ganz schwerer Fehler in der Pruefung PRUEF01 aufgetreten.", (String)pruefung.getFehlertextLang());
        ILParserTest.assertEquals((int)1, (int)pruefung.getKorrekturart());
        ILParserTest.assertEquals((String)"Lehnen Sie sich zurueck, entspannen Sie und ueberlegen Sie dann mal, was Sie wohl falsch gemacht haben.", (String)pruefung.getKorrekturhinweis());
    }

    public void test_09_tb1_variable1() {
        MetaPLVariable tmp = this.plausi.getFromThemenbereiche(0).getFromVariablen(0);
        ILParserTest.assertNotNull((Object)tmp);
        ILParserTest.assertTrue((boolean)(tmp instanceof MetaCustomVariable));
        MetaCustomVariable var = (MetaCustomVariable)tmp;
        ILParserTest.assertSame((Object)var.getThemenbereich(), (Object)this.plausi.getFromThemenbereiche(0));
        ILParserTest.assertEquals((String)"temporaer1", (String)var.getName());
        ILParserTest.assertEquals((long)5L, (long)var.getLaenge());
        ILParserTest.assertTrue((boolean)var.getPersistent());
        ILParserTest.assertNotNull((Object)var.getMetaBelegung());
        ILParserTest.assertEquals((String)"init__var__temporaer1", (String)var.getMetaBelegung().name());
    }

    public void test_10_tb1_variable2() {
        MetaPLVariable tmp = this.plausi.getFromThemenbereiche(0).getFromVariablen(1);
        ILParserTest.assertNotNull((Object)tmp);
        ILParserTest.assertTrue((boolean)(tmp instanceof MetaCustomVariable));
        MetaCustomVariable var = (MetaCustomVariable)tmp;
        ILParserTest.assertSame((Object)var.getThemenbereich(), (Object)this.plausi.getFromThemenbereiche(0));
        ILParserTest.assertEquals((String)"string", (String)var.getName());
        ILParserTest.assertEquals((long)100L, (long)var.getLaenge());
        ILParserTest.assertFalse((boolean)var.getPersistent());
    }

    public void test_11_tb1_funktion1() {
        MetaPLFunktion tmp = this.plausi.getFromThemenbereiche(0).getFromFunktionen(0);
        ILParserTest.assertNotNull((Object)tmp);
        ILParserTest.assertTrue((boolean)(tmp instanceof MetaCustomFunktion));
        MetaCustomFunktion funktion = (MetaCustomFunktion)tmp;
        ILParserTest.assertSame((Object)funktion.getThemenbereich(), (Object)this.plausi.getFromThemenbereiche(0));
        ILParserTest.assertEquals((String)"dividiere", (String)funktion.getName());
        ILParserTest.assertEquals((String)"function", (String)funktion.getArt());
        ILParserTest.assertEquals((int)1, (int)funktion.getRueckgabeTyp());
        ILParserTest.assertEquals((int)2, (int)funktion.sizeOfParameter());
        MetaPLParameter param1 = funktion.getFromParameter(0);
        MetaPLParameter param2 = funktion.getFromParameter(1);
        ILParserTest.assertEquals((String)"wert1", (String)param1.getName());
        ILParserTest.assertEquals((int)1, (int)param1.getTyp());
        ILParserTest.assertEquals((String)"wert2", (String)param2.getName());
        ILParserTest.assertEquals((int)1, (int)param2.getTyp());
        ILParserTest.assertNotNull((Object)funktion.getMetaSpezifikation());
        ILParserTest.assertTrue((boolean)(funktion.getMetaSpezifikation() instanceof MetaProgram));
        ILParserTest.assertEquals((String)funktion.getName(), (String)funktion.getMetaSpezifikation().name());
    }

    protected void setUp() throws Exception {
        super.setUp();
        IntermediateLanguageParser parser = new IntermediateLanguageParser();
        FileReader fin = new FileReader(TEST_FILE);
        this.plausi = (MetaPlausibilisierung)parser.parse(fin);
        fin.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

