/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.datastructure.deleted;

import de.statspez.pleditor.generator.codegen.analysis.complexity.datastructure.DataField;
import de.statspez.pleditor.generator.codegen.analysis.complexity.datastructure.deleted.DatastructureGeneratorIfc;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DatastructureComplexityResolver {
    public static final double DEFAULT_FREQUENCY_FOR_NDIMENSION = 100.0;
    private List resolvedElements;
    private DatastructureGeneratorIfc datastructureGeneratorIfc;

    public DatastructureComplexityResolver(DatastructureGeneratorIfc datastructureGeneratorIfc) {
        this(datastructureGeneratorIfc, new ArrayList());
    }

    public DatastructureComplexityResolver(DatastructureGeneratorIfc datastructureGeneratorIfc, List calculatedElements) {
        this.datastructureGeneratorIfc = datastructureGeneratorIfc;
        this.resolvedElements = calculatedElements;
    }

    public void resolveComplexity(MetaCustomPlausibilisierung plausi) {
        Resolver resolver = new Resolver();
        plausi.accept(resolver);
    }

    public void resolveComplexity(MetaThemenbereich themenbereich, boolean rootThemenbereich) {
        Resolver resolver = new Resolver();
        resolver.rootTB = rootThemenbereich;
        themenbereich.accept(resolver);
    }

    private boolean isNotResolved(Object obj) {
        return !this.resolvedElements.contains(obj);
    }

    public static boolean isNDimensional(int[] dimensions) {
        boolean nDimensional = false;
        int i = 0;
        while (i < dimensions.length) {
            if (dimensions[i] < 0) {
                nDimensional = true;
                break;
            }
            ++i;
        }
        return nDimensional;
    }

    private class Resolver
    extends AbstractElementVisitor {
        private int initialDataFieldsLength = 0;
        private int additionalDataFieldsLength = 0;
        private int additionalMainDataFieldsLength = 0;
        private boolean rootTB = false;

        private Resolver() {
            DataField[] initialDataFields = DatastructureComplexityResolver.this.datastructureGeneratorIfc.getInitialDataFields();
            int i = 0;
            while (initialDataFields != null && i < initialDataFields.length) {
                this.initialDataFieldsLength += this.getSqlStorage(initialDataFields[i].getSqlType(), null, DatastructureComplexityResolver.this.datastructureGeneratorIfc);
                ++i;
            }
            DataField[] additionalDataFields = DatastructureComplexityResolver.this.datastructureGeneratorIfc.getAdditionalDataFields();
            int i2 = 0;
            while (additionalDataFields != null && i2 < additionalDataFields.length) {
                this.additionalDataFieldsLength += this.getSqlStorage(additionalDataFields[i2].getSqlType(), null, DatastructureComplexityResolver.this.datastructureGeneratorIfc);
                ++i2;
            }
            DataField[] additionalMainDataFields = DatastructureComplexityResolver.this.datastructureGeneratorIfc.getAdditionalMainDataFields();
            int i3 = 0;
            while (additionalMainDataFields != null && i3 < additionalMainDataFields.length) {
                this.additionalMainDataFieldsLength += this.getSqlStorage(additionalMainDataFields[i3].getSqlType(), null, DatastructureComplexityResolver.this.datastructureGeneratorIfc);
                ++i3;
            }
        }

        public void visitPlausibilisierung(MetaPlausibilisierung anObject) {
            MetaCustomThemenbereich originalTB = (MetaCustomThemenbereich)((MetaCustomPlausibilisierung)anObject).rootThemenbereich();
            MetaCustomThemenbereich tb = DatastructureComplexityResolver.this.datastructureGeneratorIfc.getThemenbereichForDatastructureGeneration(originalTB);
            this.rootTB = true;
            tb.accept(this);
        }

        public void visitMerkmal(MetaMerkmal anObject) {
            if (DatastructureComplexityResolver.this.isNotResolved(anObject)) {
                MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject;
                merkmal.setFunctionalComplexity(null);
                DatastructureComplexityResolver.this.resolvedElements.add(merkmal);
                int byteAnzahl = this.getSpeicherbedarf(anObject, DatastructureComplexityResolver.this.datastructureGeneratorIfc);
                merkmal.setDatastructureComplexity(new Double(byteAnzahl));
            }
        }

        public void visitThemenbereich(MetaThemenbereich anObject) {
            if (DatastructureComplexityResolver.this.isNotResolved(anObject)) {
                double size = 0.0;
                size += (double)this.initialDataFieldsLength;
                size += (double)this.additionalDataFieldsLength;
                if (this.rootTB) {
                    size += (double)this.additionalMainDataFieldsLength;
                    this.rootTB = false;
                }
                Iterator it = anObject.getFelder();
                while (it != null && it.hasNext()) {
                    MetaCustomTBFeld field = (MetaCustomTBFeld)it.next();
                    field.accept(this);
                    size += field.getFunctionalComplexity().doubleValue();
                    if (!(field.getKlasse() instanceof MetaThemenbereich)) continue;
                    size += (double)this.getSqlStorage(DatastructureComplexityResolver.this.datastructureGeneratorIfc.getSqlTypeForRelation(), null, DatastructureComplexityResolver.this.datastructureGeneratorIfc);
                }
                anObject.setFunctionalComplexity(new Double(size));
            }
        }

        public void visitTBFeld(MetaTBFeld anObject) {
            MetaCustomTBFeld field = (MetaCustomTBFeld)anObject;
            if (DatastructureComplexityResolver.this.isNotResolved(field.getKlasse())) {
                if (field.getKlasse() instanceof MetaThemenbereich) {
                    DatastructureComplexityResolver subResolver = new DatastructureComplexityResolver(DatastructureComplexityResolver.this.datastructureGeneratorIfc);
                    subResolver.resolveComplexity((MetaThemenbereich)field.getKlasse(), false);
                } else {
                    field.getKlasse().accept(this);
                }
            }
            if (field.getListe()) {
                int[] dimensions = field.dimensions();
                if (DatastructureComplexityResolver.isNDimensional(dimensions)) {
                    if (anObject.getFunctionalFrequency() == null) {
                        anObject.setFunctionalFrequency(new Double(100.0));
                    }
                } else {
                    double frequency = 0.0;
                    int i = 0;
                    while (i < dimensions.length) {
                        frequency = i == 0 ? (double)dimensions[i] : (frequency *= (double)dimensions[i]);
                        ++i;
                    }
                    anObject.setFunctionalFrequency(new Double(frequency));
                }
            } else {
                anObject.setFunctionalFrequency(new Double(1.0));
            }
            double complexity = field.getKlasse().getFunctionalComplexity();
            anObject.setFunctionalComplexity(new Double(complexity *= anObject.getFunctionalFrequency().doubleValue()));
        }

        private int getSpeicherbedarf(MetaMerkmal merkmal, DatastructureGeneratorIfc converter) {
            int sqlDataType = converter.getSqlType(merkmal);
            return this.getSqlStorage(sqlDataType, merkmal, converter);
        }

        private int getSqlStorage(int sqlDataType, MetaMerkmal merkmal, DatastructureGeneratorIfc converter) {
            int result;
            switch (sqlDataType) {
                case -5: {
                    result = 8;
                    break;
                }
                case 8: {
                    result = 8;
                    break;
                }
                case -7: {
                    result = 8;
                    break;
                }
                case 12: {
                    result = 1 + converter.getVarcharSize(merkmal);
                    break;
                }
                case -1: {
                    result = 12;
                    break;
                }
                default: {
                    new IllegalArgumentException("Unbekannter Felddaten-Typ!");
                    result = -1;
                }
            }
            return result;
        }
    }
}

