/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui.datastructure;

import de.statspez.pleditor.generator.codegen.analysis.complexity.datastructure.SimpleDatastructureComplexityResolver;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityChangeListener;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityNode;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityUITreeCellRenderer;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.DoubleCellRenderer;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.PopupMenu;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.datastructure.DatastructureComplexityNode;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.datastructure.DatastructureComplexityNodeBuilder;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.datastructure.DatastructureComplexityTreeTableModel;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.treetable.TreeTable;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class DatastructureComplexityPanel
extends JPanel {
    private static final long serialVersionUID = 2405409406531500869L;
    private TreeTable table = new TreeTable();
    private DatastructureComplexityTreeTableModel treeTableModel;
    private List complexityChangeListeners;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DatastructureComplexityPanel() {
        super(new BorderLayout());
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setSelectionMode(0);
        this.table.getTree().getSelectionModel().setSelectionMode(1);
        this.table.getTree().setRootVisible(false);
        this.table.setGridColor(SystemColor.control);
        this.table.setRowHeight(18);
        this.table.getTableHeader().setReorderingAllowed(false);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.analysis.complexity.ui.datastructure.DatastructureComplexityTreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.table.setDefaultRenderer(clazz, this.table.getTreeTableCellRenderer());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.table.setDefaultRenderer(clazz2, new DoubleCellRenderer());
        this.table.setTreeCellRenderer(new ComplexityUITreeCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)scrollPane, "Center");
        this.complexityChangeListeners = new ArrayList();
    }

    public void addComplexityChangeListener(ComplexityChangeListener listener) {
        if (listener != null) {
            this.complexityChangeListeners.add(listener);
        }
    }

    public void removeComplexityChangeListener(ComplexityChangeListener listener) {
        if (listener != null) {
            this.complexityChangeListeners.remove(listener);
        }
    }

    public void addPopupMenu(final PopupMenu popupMenu) {
        MouseAdapter mousListener = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                int selectedRow;
                if (e.isPopupTrigger() && (selectedRow = DatastructureComplexityPanel.this.table.getSelectedRow()) >= 0) {
                    ComplexityNode selectedNode = DatastructureComplexityPanel.this.getSelectedComplexityNode();
                    boolean expandEnable = false;
                    if (!DatastructureComplexityPanel.this.table.getTree().isExpanded(selectedRow)) {
                        expandEnable = selectedNode != null && !selectedNode.isLeaf();
                    }
                    popupMenu.setEnabledForExpand(expandEnable);
                    popupMenu.setEnabledForOpenElement(selectedNode);
                    popupMenu.setEnabledForDetails(selectedNode);
                    popupMenu.getJPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.table.addMouseListener(mousListener);
    }

    public void setPlausibilisierung(MetaCustomPlausibilisierung plausi, boolean editable) {
        if (plausi == null) {
            throw new IllegalArgumentException("Plausibilisierung muss angegeben werden.");
        }
        DatastructureComplexityNodeBuilder builder = new DatastructureComplexityNodeBuilder();
        DatastructureComplexityNode rootNode = builder.build(plausi);
        this.treeTableModel = new DatastructureComplexityTreeTableModel(rootNode, editable);
        this.treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeStructureChanged(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
            }

            public void treeNodesChanged(TreeModelEvent e) {
                DatastructureComplexityPanel.this.doCalculateComplexity();
            }
        });
        this.table.setModel(this.treeTableModel);
        this.table.setTreeCellRenderer(new ComplexityUITreeCellRenderer());
        this.doCalculateComplexity();
    }

    public void doCalculateComplexity() {
        MetaCustomPlausibilisierung plausi = this.getPlausi();
        if (plausi != null) {
            SimpleDatastructureComplexityResolver resolver = new SimpleDatastructureComplexityResolver();
            resolver.resolveComplexity(plausi);
            this.fireComplexityChanged();
            this.table.repaint();
        }
    }

    public MetaElement getSelectedMetaElement() {
        MetaElement result = null;
        ComplexityNode selectedNode = this.getSelectedComplexityNode();
        if (selectedNode != null) {
            result = selectedNode.getElement();
        }
        return result;
    }

    public ComplexityNode getSelectedComplexityNode() {
        ComplexityNode result = null;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            TreePath selectedPath = this.table.getTree().getPathForRow(selectedRow);
            result = (ComplexityNode)selectedPath.getLastPathComponent();
        }
        return result;
    }

    private MetaCustomPlausibilisierung getPlausi() {
        ComplexityNode rootNode;
        MetaCustomPlausibilisierung plausi = null;
        if (this.treeTableModel != null && (rootNode = (ComplexityNode)this.treeTableModel.getRoot()) != null) {
            plausi = (MetaCustomPlausibilisierung)rootNode.getElement();
        }
        return plausi;
    }

    public final void expandAll(boolean expand) {
        ComplexityNode root = (ComplexityNode)this.table.getTree().getModel().getRoot();
        this.expandAll(new TreePath(root), expand);
    }

    public final void expandAll(TreePath parent, boolean expand) {
        ComplexityNode node = (ComplexityNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            int i = 0;
            while (i < node.getChildCount()) {
                ComplexityNode n = node.getChild(i);
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
                ++i;
            }
        }
        if (expand) {
            this.table.getTree().expandPath(parent);
        } else {
            this.table.getTree().collapsePath(parent);
        }
    }

    public void expand() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            TreePath selectedPath = this.table.getTree().getPathForRow(selectedRow);
            this.expandAll(selectedPath, true);
        }
    }

    private void fireComplexityChanged() {
        int i = 0;
        while (i < this.complexityChangeListeners.size()) {
            ((ComplexityChangeListener)this.complexityChangeListeners.get(i)).complexityChanged();
            ++i;
        }
    }
}

