/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.DiffElement;
import de.statspez.pleditor.generator.codegen.diff.DiffResult;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementAdded;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementChanged;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementRemoved;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementTypeChanged;
import de.statspez.pleditor.generator.codegen.diff.DiffResultPlausiDiffers;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTree;
import de.statspez.pleditor.generator.codegen.diff.DiffUITreeNode;
import de.statspez.pleditor.generator.codegen.diff.StatusIcon;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DiffUITreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon ICON_ADDED;
    private static final Icon ICON_CHANGED;
    private static final Icon ICON_ERROR;
    private static final Icon ICON_NO_CHANGE;
    private static final Icon ICON_REFERENCE_CHANGED;
    private static final Icon ICON_REMOVED;
    private static final Icon ICON_WARNING;
    private static final long serialVersionUID = -5221089452868297393L;
    private DiffConfig diffConfig = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffUITreeCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_ADDED = new ImageIcon(clazz.getResource("images/added.gif"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffUITreeCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_CHANGED = new ImageIcon(clazz2.getResource("images/changed.gif"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffUITreeCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_ERROR = new ImageIcon(clazz3.getResource("images/error.gif"));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffUITreeCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_NO_CHANGE = new ImageIcon(clazz4.getResource("images/no_change.gif"));
        ICON_REFERENCE_CHANGED = null;
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffUITreeCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_REMOVED = new ImageIcon(clazz5.getResource("images/removed.gif"));
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffUITreeCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_WARNING = new ImageIcon(clazz6.getResource("images/warning.gif"));
    }

    DiffUITreeCellRenderer(DiffConfig diffConfig) {
        this.diffConfig = diffConfig;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.setText(null);
        this.setIcon(null);
        if (value instanceof DiffUITreeNode) {
            List rootDiffResults;
            DiffResultTree resultTree;
            DiffUITreeNode node = (DiffUITreeNode)value;
            List diffResults = node.getDiffResultTreeNode().getDiffResults();
            Icon status = null;
            Icon type = null;
            Icon error = null;
            if (!node.getDiffResultTreeNode().isHeaderNode()) {
                MetaElement element;
                MetaElement element1 = node.getDiffResultTreeNode().getMetaElement1();
                MetaElement element2 = node.getDiffResultTreeNode().getMetaElement2();
                MetaElement metaElement = element1 != null ? element1 : (element = element2 != null ? element2 : null);
                if (element == null) {
                    throw new NullPointerException();
                }
                type = DiffElement.getDiffElement(element).getIcon();
            }
            if (!node.getDiffResultTreeNode().isHeaderNode() && diffResults.size() != 0) {
                if (diffResults.size() == 1) {
                    DiffResult diffResult = (DiffResult)diffResults.get(0);
                    if (diffResult instanceof DiffResultElementAdded) {
                        status = ICON_ADDED;
                    } else if (diffResult instanceof DiffResultElementRemoved) {
                        status = ICON_REMOVED;
                    } else if (diffResult instanceof DiffResultElementChanged) {
                        status = ICON_CHANGED;
                    } else {
                        boolean cfr_ignored_0 = diffResult instanceof DiffResultElementTypeChanged;
                    }
                } else {
                    status = ICON_CHANGED;
                }
            }
            if (this.diffConfig != null && this.diffConfig.isShowErrorStatusIcon()) {
                Iterator iterator = diffResults.iterator();
                while (iterator.hasNext()) {
                    DiffResult diffResult = (DiffResult)iterator.next();
                    int errorLevel = this.diffConfig.getErrorLevel(diffResult);
                    if (errorLevel == 2) {
                        error = ICON_ERROR;
                        break;
                    }
                    if (errorLevel != 1) continue;
                    error = ICON_WARNING;
                }
            }
            if (type != null) {
                StatusIcon icon = new StatusIcon(type);
                icon.setStatusIcon(2, status, 2, -3);
                icon.setStatusIcon(3, error, 2, -3);
                this.setIcon(icon);
            }
            if ((resultTree = node.getDiffResultTreeNode().getDiffResultTree()).getRootNode().equals(node.getDiffResultTreeNode()) && (rootDiffResults = node.getDiffResultTreeNode().getDiffResults()).size() == 1 && rootDiffResults.get(0) instanceof DiffResultPlausiDiffers) {
                this.setIcon(ICON_ERROR);
            }
            this.setText(this.generateText(node));
            if (diffResults != null && diffResults.size() > 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("<html>");
                if (diffResults.size() == 1) {
                    buffer.append("Ein Unterschied");
                } else {
                    buffer.append(diffResults.size());
                    buffer.append(" Unterschiede");
                }
                buffer.append("</html>");
                this.setToolTipText(buffer.toString());
            } else {
                this.setToolTipText(null);
            }
        }
        return this;
    }

    private String generateText(DiffUITreeNode node) {
        String text = node.toString();
        MetaElement element1 = node.getDiffResultTreeNode().getMetaElement1();
        MetaElement element2 = node.getDiffResultTreeNode().getMetaElement2();
        if (element1 != null && element1 instanceof MetaThemenbereich || element2 != null && element2 instanceof MetaThemenbereich) {
            if (element1 != null && element2 != null) {
                MetaThemenbereich tb1 = (MetaThemenbereich)element1;
                MetaThemenbereich tb2 = (MetaThemenbereich)element2;
                text = tb1.getName().equals(tb2.getName()) ? tb1.getName() : String.valueOf(tb1.getName()) + " => " + tb2.getName();
            } else {
                text = element1 != null ? ((MetaThemenbereich)element1).getName() : ((MetaThemenbereich)element2).getName();
            }
        }
        return text;
    }
}

