/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;

public class StatusIcon
implements Icon,
Serializable,
Accessible {
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 3;
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    private static final long serialVersionUID = 2101398298964005711L;
    private int height = 0;
    private Insets insets = null;
    private int leftCorrection = 0;
    private int[] newX = null;
    private int[] newY = null;
    private int[] spacingsX = null;
    private int[] spacingsY = null;
    private Icon statusIcon = null;
    private Icon[] statusIcons = null;
    private int topCorrection = 0;
    private int width = 0;

    public StatusIcon(Icon base) {
        this(base, null, null, null, null);
    }

    public StatusIcon(Icon base, Icon[] statusIcons) {
        this(base, statusIcons, null, null, null);
    }

    public StatusIcon(Icon base, Icon[] statusIcons, Insets insets) {
        this(base, statusIcons, null, null, insets);
    }

    public StatusIcon(Icon base, Icon[] statusIcons, int[] spacingsX, int[] spacingsY) {
        this(base, statusIcons, spacingsX, spacingsY, null);
    }

    public StatusIcon(Icon base, Icon[] statusIcons, int[] spacingsX, int[] spacingsY, Insets insets) {
        if (base == null) {
            throw new IllegalArgumentException("Base darf nicht null sein!");
        }
        if (statusIcons != null && statusIcons.length != 4) {
            throw new IllegalArgumentException("Anzahl der StatusIcons muss 4 sein!");
        }
        if (spacingsX != null && spacingsX.length != 4 || spacingsY != null && spacingsY.length != 4) {
            throw new IllegalArgumentException("Anzahl der Spacings muss 4 sein!");
        }
        if (statusIcons == null) {
            this.statusIcons = new Icon[4];
        } else {
            this.statusIcons = new Icon[4];
            this.statusIcons[0] = statusIcons[0];
            this.statusIcons[3] = statusIcons[3];
            this.statusIcons[1] = statusIcons[1];
            this.statusIcons[2] = statusIcons[2];
        }
        if (spacingsX == null) {
            this.spacingsX = new int[4];
        } else {
            this.spacingsX = new int[4];
            this.spacingsX[0] = spacingsX[0];
            this.spacingsX[3] = spacingsX[3];
            this.spacingsX[1] = spacingsX[1];
            this.spacingsX[2] = spacingsX[2];
        }
        if (spacingsY == null) {
            this.spacingsY = new int[4];
        } else {
            this.spacingsY = new int[4];
            this.spacingsY[0] = spacingsY[0];
            this.spacingsY[3] = spacingsY[3];
            this.spacingsY[1] = spacingsY[1];
            this.spacingsY[2] = spacingsY[2];
        }
        this.statusIcon = base;
        this.height = this.statusIcon.getIconHeight();
        this.width = this.statusIcon.getIconWidth();
        this.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        this.newX = new int[4];
        this.newY = new int[4];
        this.setStatusIcon(0, this.statusIcons[0], this.spacingsX[0], this.spacingsY[0]);
        this.setStatusIcon(1, this.statusIcons[1], this.spacingsX[1], this.spacingsY[1]);
        this.setStatusIcon(2, this.statusIcons[2], this.spacingsX[2], this.spacingsY[2]);
        this.setStatusIcon(3, this.statusIcons[3], this.spacingsX[3], this.spacingsY[3]);
    }

    public StatusIcon(Icon base, Insets insets) {
        this(base, null, null, null, insets);
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component component, Graphics graphics, int x, int y) {
        Icon icon;
        this.statusIcon.paintIcon(component, graphics, this.leftCorrection + x, this.topCorrection + y);
        if (this.statusIcons[0] != null) {
            icon = this.statusIcons[0];
            icon.paintIcon(component, graphics, this.newX[0] + x, this.newY[0] + y);
        }
        if (this.statusIcons[1] != null) {
            icon = this.statusIcons[1];
            icon.paintIcon(component, graphics, this.newX[1] + x, this.newY[1] + y);
        }
        if (this.statusIcons[2] != null) {
            icon = this.statusIcons[2];
            icon.paintIcon(component, graphics, this.newX[2] + x, this.newY[2] + y);
        }
        if (this.statusIcons[3] != null) {
            icon = this.statusIcons[3];
            icon.paintIcon(component, graphics, this.newX[3] + x, this.newY[3] + y);
        }
    }

    public void setStatusIcon(int position, Icon icon) {
        this.setStatusIcon(position, icon, 0, 0);
    }

    public void setStatusIcon(int position, Icon icon, int spacingX, int spacingY) {
        if (position < 0 || position > 3) {
            throw new IllegalArgumentException("Position ung\u00fcltig. Erlaubt sind BOTTOM_LEFT, BOTTOM_RIGHT, TOP_LEFT, TOP_RIGTH");
        }
        this.statusIcons[position] = icon;
        this.spacingsX[position] = spacingX;
        this.spacingsY[position] = spacingY;
        this.calculateSize();
    }

    protected void calculateSize() {
        int dummyY;
        int dummyX;
        int newY;
        int newX;
        Icon icon;
        int x = 0;
        int y = 0;
        int xCorrectionTop = 0;
        if (this.statusIcons[1] != null) {
            xCorrectionTop = this.statusIcons[1].getIconWidth() / 2;
            xCorrectionTop += this.spacingsX[1];
        }
        int xCorrectionBottom = 0;
        if (this.statusIcons[0] != null) {
            xCorrectionBottom = this.statusIcons[0].getIconWidth() / 2;
            xCorrectionBottom += this.spacingsX[0];
        }
        this.leftCorrection = xCorrectionBottom > xCorrectionTop ? xCorrectionBottom : xCorrectionTop;
        this.leftCorrection += this.insets.left;
        int xCorrectionLeft = 0;
        if (this.statusIcons[1] != null) {
            xCorrectionLeft = this.statusIcons[1].getIconHeight() / 2;
            xCorrectionLeft += this.spacingsY[1];
        }
        int xCorrectionRight = 0;
        if (this.statusIcons[2] != null) {
            xCorrectionRight = this.statusIcons[2].getIconHeight() / 2;
            xCorrectionRight += this.spacingsY[2];
        }
        this.topCorrection = xCorrectionLeft > xCorrectionRight ? xCorrectionLeft : xCorrectionRight;
        this.topCorrection += this.insets.top;
        x += this.leftCorrection;
        y += this.topCorrection;
        int totalXLeftAdd = 0;
        int totalXRightAdd = 0;
        int totalYTopAdd = 0;
        int totalYBottomAdd = 0;
        if (this.statusIcons[0] != null) {
            icon = this.statusIcons[0];
            newX = x - icon.getIconWidth() / 2 - this.spacingsX[0];
            newY = y + this.statusIcon.getIconHeight() - icon.getIconHeight() / 2 + this.spacingsY[0];
            dummyX = x > newX ? x - newX : 0;
            totalXLeftAdd = totalXLeftAdd > dummyX ? totalXLeftAdd : dummyX;
            totalYBottomAdd = dummyY = y < newY ? newY - y - this.statusIcon.getIconHeight() + this.statusIcons[0].getIconHeight() : 0;
            this.newX[0] = newX;
            this.newY[0] = newY;
        }
        if (this.statusIcons[1] != null) {
            icon = this.statusIcons[1];
            newX = x - icon.getIconWidth() / 2 - this.spacingsX[1];
            newY = y - icon.getIconHeight() / 2 - this.spacingsY[1];
            dummyX = x > newX ? x - newX : 0;
            totalXLeftAdd = totalXLeftAdd > dummyX ? totalXLeftAdd : dummyX;
            dummyY = y > newY ? y - newY : 0;
            totalYTopAdd = totalYTopAdd > dummyY ? totalYTopAdd : dummyY;
            this.newX[1] = newX;
            this.newY[1] = newY;
        }
        if (this.statusIcons[2] != null) {
            icon = this.statusIcons[2];
            newX = x + this.statusIcon.getIconWidth() - icon.getIconWidth() / 2 + this.spacingsX[2];
            newY = y - icon.getIconHeight() / 2 - this.spacingsY[2];
            totalXRightAdd = dummyX = x < newX ? newX - this.statusIcon.getIconWidth() - x + this.statusIcons[2].getIconWidth() : 0;
            dummyY = y > newY ? y - newY : 0;
            totalYTopAdd = totalYTopAdd > dummyY ? totalYTopAdd : dummyY;
            this.newX[2] = newX;
            this.newY[2] = newY;
        }
        if (this.statusIcons[3] != null) {
            icon = this.statusIcons[3];
            newX = x + this.statusIcon.getIconWidth() - icon.getIconWidth() / 2 + this.spacingsX[3];
            newY = y + this.statusIcon.getIconHeight() - icon.getIconHeight() / 2 + this.spacingsY[3];
            dummyX = x < newX ? newX - this.statusIcon.getIconWidth() - x + this.statusIcons[3].getIconWidth() : 0;
            totalXRightAdd = totalXRightAdd > dummyX ? totalXRightAdd : dummyX;
            dummyY = y < newY ? newY - y - this.statusIcon.getIconHeight() + this.statusIcons[3].getIconHeight() : 0;
            totalYBottomAdd = totalYBottomAdd > dummyY ? totalYBottomAdd : dummyY;
            this.newX[3] = newX;
            this.newY[3] = newY;
        }
        int totalXAdd = totalXRightAdd + totalXLeftAdd;
        int totalYAdd = totalYTopAdd + totalYBottomAdd;
        this.width = this.statusIcon.getIconWidth() + this.insets.right + this.insets.left + totalXAdd;
        this.height = this.statusIcon.getIconHeight() + this.insets.top + this.insets.bottom + totalYAdd;
    }
}

