/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import java.io.Writer;
import java.util.Iterator;

public class ClassificationCodeGenerator
extends JavaCodeGenerator {
    private static final String CLASSI_VAR = "classi";
    private static final String CLASSI_REG_METHOD = "registerClassifications";
    private static final String PLAUSI_VAR = "plausi";
    private CodegenContext context;
    private int numOfDeclarations;
    private String currentFilename;
    private Writer currentWriter;

    public synchronized void generate(CodegenContext aContext) {
        this.context = aContext;
        this.numOfDeclarations = 0;
        this.currentFilename = null;
        this.currentWriter = null;
        this.preGenerate();
        this.visitElements(this.context.getPlausi().getAuspraegungsgruppen());
        this.closeCurrentSegmentIfNecessary();
    }

    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe classificationGroup) {
        this.startNewSegmentIfNecessary();
        this.createBeginClassificationCode("ClassificationGroup");
        this.out.print("ValueFactory.instance().valueFor(");
        this.out.print("\"");
        this.out.print(classificationGroup.getName());
        this.out.print("\")");
        this.createEndClassificationCode(classificationGroup.getName(), "#" + classificationGroup.getName(), null);
        this.indentNewLine();
        Iterator it = classificationGroup.getAuspraegungsComps().getAuspraegungen();
        while (it.hasNext()) {
            ((MetaAuspraegung)it.next()).accept(this);
        }
    }

    public void visitPLAuspraegung(MetaPLAuspraegung classification) {
        this.startNewSegmentIfNecessary();
        MetaCustomAuspraegung myClassi = (MetaCustomAuspraegung)classification;
        String classificationClass = myClassi.sizeOfAuspraegungen() > 0 ? "ClassificationGroup" : "Classification";
        this.createBeginClassificationCode(classificationClass);
        myClassi.getKodeSpezifikation().accept(this);
        this.createEndClassificationCode(myClassi.getName(), myClassi.getHierachicalCode(), myClassi.getHierachicalValue());
        String groupRegCode = myClassi.hasParent() ? ((MetaCustomAuspraegung)myClassi.getParent()).getHierachicalCode() : "#" + myClassi.getGroup().getName();
        this.indentNewLine();
        this.out.print("((ClassificationGroup)");
        if (this.withinSegment()) {
            this.out.print(PLAUSI_VAR);
            this.out.print(".");
        }
        this.out.print("classificationByCode(\"");
        this.out.print(groupRegCode);
        this.out.print("\")).addClassfication(");
        this.out.print(CLASSI_VAR);
        this.out.print(");");
        this.indentNewLine();
        int i = 0;
        while (i < classification.sizeOfAuspraegungen()) {
            classification.getFromAuspraegungen(i).accept(this);
            ++i;
        }
    }

    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        this.out.print("new RangeSeries(new Range[] {");
        Iterator it = aRangeSeries.ranges();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.print("})");
    }

    public void visitSequence(MetaSequence aRange) {
        this.out.print("new SequenceRange(");
        aRange.first().accept(this);
        this.out.print(", ");
        aRange.second().accept(this);
        this.out.print(", ");
        aRange.last().accept(this);
        this.out.print(")");
    }

    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        this.error(aFieldAccess, "Zeichenketten m\u00fcssen in Hochkommata eingeschlossen werden.");
    }

    public void visitInterval(MetaInterval aRange) {
        this.out.print("new IntervalRange(");
        aRange.first().accept(this);
        this.out.print(", ");
        aRange.last().accept(this);
        this.out.print(", ");
        this.out.print(this.getRuntimeIntervalType(aRange.type()));
        this.out.print(")");
    }

    public void visitProgram(MetaProgram aProgram) {
        aProgram.statements().statementAt(0).accept(this);
    }

    public void visitSignOperator(MetaSignOperator anOperator) {
        if (anOperator.type() == 2) {
            this.out.print("ValueFactory.instance().valueFor(");
        }
        anOperator.operand().accept(this);
        if (anOperator.type() == 2) {
            this.out.print(".asDouble()");
            this.out.print(" * ");
            this.out.print("(-1))");
        }
    }

    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        anAssignment.rightValue().accept(this);
    }

    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        this.out.print("new SingleValueRange(");
        aRange.value().accept(this);
        this.out.print(")");
    }

    protected int getRuntimeIntervalType(int metaType) {
        switch (metaType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 4;
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accessedLiteral().accept(this);
    }

    public void visitNumber(MetaNumber aNumber) {
        this.out.print("new NumberValue(");
        this.out.print(aNumber.value().toString());
        this.out.print(")");
    }

    public void visitString(MetaString aString) {
        this.out.print("new StringValue(\"");
        this.out.print(StringHelper.getEscapedStringValue(aString.value()));
        this.out.print("\")");
    }

    private void preGenerate() {
        this.indentNewLine();
        this.out.print("Classification ");
        this.out.print(CLASSI_VAR);
        this.out.print(";");
        this.indentNewLine();
    }

    private void startNewSegmentIfNecessary() {
        if (this.numOfDeclarations >= this.context.getMaxElementsInSegment(1)) {
            this.numOfDeclarations = 1;
            String className = this.context.getNextPlausiSegmentClassName();
            this.currentFilename = String.valueOf(className) + ".java";
            this.indentNewLine();
            this.out.print(className);
            this.out.print(".");
            this.out.print(CLASSI_REG_METHOD);
            this.out.print("(");
            if (this.withinSegment()) {
                this.out.print(PLAUSI_VAR);
            } else {
                this.out.print("this");
            }
            this.out.print(");");
            this.closeCurrentSegmentIfNecessary();
            this.currentWriter = this.context.createWriter(this.currentFilename);
            this.setOutput(this.currentWriter);
            this.setIndentLevel(0);
            this.out.print("package ");
            this.out.print(this.context.getPlausiPackage());
            this.out.print(";");
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("import ");
            this.out.print("de.statspez.pleditor.generator.runtime.");
            this.out.print("*;");
            this.indentNewLine();
            this.defineClass(className, "public", null);
            this.defineMethod("public static", "void", CLASSI_REG_METHOD, String.valueOf(this.context.getPlausiClassName()) + " " + PLAUSI_VAR);
            this.preGenerate();
        } else {
            ++this.numOfDeclarations;
        }
    }

    private void closeCurrentSegmentIfNecessary() {
        if (this.withinSegment()) {
            this.endMethodDefinition();
            this.endClassDefinition();
            this.context.destroyWriter(this.currentFilename, this.currentWriter);
        }
    }

    private boolean withinSegment() {
        return this.currentFilename != null && this.currentWriter != null;
    }

    private void createBeginClassificationCode(String clazz) {
        this.indentNewLine();
        this.out.print(CLASSI_VAR);
        this.out.print(" = new ");
        this.out.print(clazz);
        this.out.print("(");
    }

    private void createEndClassificationCode(String value, String regCode, String regValue) {
        this.out.print(", ");
        this.out.print("ValueFactory.instance().valueFor(");
        this.out.print("\"");
        if (value != null) {
            value = value.replaceAll("\\\"", "\\\\\"");
        }
        this.out.print(value);
        this.out.print("\"));");
        this.indentNewLine();
        if (this.withinSegment()) {
            this.out.print(PLAUSI_VAR);
            this.out.print(".");
        }
        this.out.print("registerClassification(");
        this.out.print(CLASSI_VAR);
        this.out.print(", \"");
        this.out.print(regCode);
        this.out.print("\"");
        if (regValue != null) {
            this.out.print(", \"");
            this.out.print(regValue.replaceAll("\\\"", "\\\\\""));
            this.out.print("\"");
        }
        this.out.print(");");
    }
}

