/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.MetaCustomMappingElement;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMappingElement;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import java.io.Writer;

public class MappingsCodeGenerator
extends JavaCodeGenerator {
    public static final String HT_VAR_NAME = "__mappings_ht";
    private static final String MAP_DEF_METHOD = "defineMappings";
    private static final String PLAUSI_VAR = "plausi";
    private CodegenContext context;
    private int numOfDeclarations;
    private String currentFilename;
    private Writer currentWriter;
    static /* synthetic */ Class class$0;

    public synchronized void generate(CodegenContext aContext) {
        this.context = aContext;
        this.numOfDeclarations = 0;
        this.currentFilename = null;
        this.currentWriter = null;
        this.preGenerate();
        this.context.getPlausi().accept(this);
        this.closeCurrentSegmentIfNecessary();
    }

    public void visitPlausibilisierung(MetaPlausibilisierung aPlausi) {
        MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)aPlausi;
        this.declareMapping(null, plausi.usedMappings());
        MetaPLMaterial[] usedMaterials = CodegenUtil.getUsedMaterials(plausi);
        if (usedMaterials != null && usedMaterials.length > 0) {
            int i = 0;
            while (i < usedMaterials.length) {
                usedMaterials[i].accept(this);
                ++i;
            }
        }
    }

    public void visitPLMaterial(MetaPLMaterial material) {
        this.declareMapping(material.getName(), material.getMapping());
    }

    public void visitMappingElement(MetaMappingElement element) {
        this.startNewSegmentIfNecessary();
        MetaCustomMappingElement mappingElement = (MetaCustomMappingElement)element;
        this.indentNewLine();
        this.out.print(HT_VAR_NAME);
        this.out.print(".put(");
        this.out.print("\"" + mappingElement.getTBFeldListeAlsName() + "\", ");
        if (mappingElement.getDsbFeldAlsName() != null && mappingElement.getDsbFeldAlsName().length() > 0) {
            this.out.print("\"" + mappingElement.getDsbFeldAlsName() + "\"");
        } else if (mappingElement.getMappingTyp() == 1 && mappingElement.getFeldSatzart() != null && mappingElement.getFeldSatzart().getName() != null && mappingElement.getFeldSatzart().getName().length() > 0) {
            this.out.print("\"" + mappingElement.getFeldSatzart().getName() + "\"");
        } else {
            this.out.print("\"\"");
        }
        this.out.print(");");
    }

    private void preGenerate() {
        this.indentNewLine();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.out.print(clazz.getName());
        this.out.print(" ");
        this.out.print(HT_VAR_NAME);
        this.out.print(";");
        this.indentNewLine();
    }

    private void startNewSegmentIfNecessary() {
        if (this.numOfDeclarations >= this.context.getMaxElementsInSegment(2)) {
            this.numOfDeclarations = 1;
            String className = this.context.getNextPlausiSegmentClassName();
            this.currentFilename = String.valueOf(className) + ".java";
            this.indentNewLine();
            this.indentNewLine();
            this.out.print(className);
            this.out.print(".");
            this.out.print(MAP_DEF_METHOD);
            this.out.print("(");
            if (this.withinSegment()) {
                this.out.print(PLAUSI_VAR);
            } else {
                this.out.print("this");
            }
            this.out.print(", ");
            this.out.print(HT_VAR_NAME);
            this.out.print(");");
            this.closeCurrentSegmentIfNecessary();
            this.currentWriter = this.context.createWriter(this.currentFilename);
            this.setOutput(this.currentWriter);
            this.setIndentLevel(0);
            this.out.print("package ");
            this.out.print(this.context.getPlausiPackage());
            this.out.print(";");
            this.indentNewLine();
            this.defineClass(className, "public", null);
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.context.getPlausiClassName())).append(" ").append(PLAUSI_VAR).append(", ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.util.Hashtable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.defineMethod("public static", "void", MAP_DEF_METHOD, stringBuffer.append(clazz.getName()).append(" ").append(HT_VAR_NAME).toString());
        } else {
            ++this.numOfDeclarations;
        }
    }

    private void closeCurrentSegmentIfNecessary() {
        if (this.withinSegment()) {
            this.endMethodDefinition();
            this.endClassDefinition();
            this.context.destroyWriter(this.currentFilename, this.currentWriter);
        }
    }

    private boolean withinSegment() {
        return this.currentFilename != null && this.currentWriter != null;
    }

    private void declareMapping(String material, MetaMapping aMapping) {
        if (aMapping != null) {
            this.indentNewLine();
            this.out.print(HT_VAR_NAME);
            this.out.print(" = new ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.util.Hashtable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.out.print(clazz.getName());
            this.out.print("();");
            this.visitElements(aMapping.getMappingliste());
            this.indentNewLine();
            if (this.withinSegment()) {
                this.out.print(PLAUSI_VAR);
                this.out.print(".");
            }
            if (material != null) {
                this.out.print("setMappingsForMaterial(");
                this.out.print("\"" + material + "\", ");
                this.out.print(HT_VAR_NAME);
                this.out.print(");");
            } else {
                this.out.print("setPlausiMappings(");
                this.out.print(HT_VAR_NAME);
                this.out.print(");");
            }
        }
    }
}

