/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.mapping;

import de.statspez.pleditor.generator.codegen.mapping.IndexVariableSupplier;
import de.statspez.pleditor.generator.codegen.mapping.MappingRegelGenerator;
import de.statspez.pleditor.generator.codegen.mapping.MappingUtil;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomMappingElement;
import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomRawField;
import de.statspez.pleditor.generator.meta.MetaCustomRawFieldGroup;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaDsbComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMappingElement;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaRawField;
import de.statspez.pleditor.generator.meta.generated.MetaRawFieldGroup;
import de.statspez.pleditor.generator.meta.generated.MetaRawSet;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class MappingProgramCodeGenerator {
    public static final int RAW_TO_TB = 100;
    public static final int TB_TO_RAW = 101;
    public static final int DSB_TO_TB = 102;
    public static final int TB_TO_DSB = 103;
    private HashMap targetVARNames;
    private HashMap sourceVARNames;
    private static final int FORMAT_TB = 1;
    private static final int FORMAT_RAW = 2;
    private static final int FORMAT_DSB = 3;
    private boolean generateMappingElementComments = false;

    public String createMappingProgram(MetaPlausibilisierung aPlausi, int mappingDirection) throws IllegalArgumentException {
        String erg = null;
        erg = this.createMappingProgram(aPlausi, mappingDirection, null, null);
        return erg;
    }

    public String createMappingProgram(MetaPlausibilisierung aPlausi, int mappingDirection, Collection mappingSourceFieldNames, Collection mappingTargetFieldNames) throws IllegalArgumentException {
        String erg = null;
        if (this.checkMappingDirection(mappingDirection)) {
            MappingCodeGenerator mapGen = new MappingCodeGenerator(mappingDirection, mappingSourceFieldNames, mappingTargetFieldNames);
            aPlausi.accept(mapGen);
            erg = mapGen.getMappingCode();
        }
        return erg;
    }

    public String createMappingProgram(MetaPLMaterial aPLMaterial, int mappingDirection) throws IllegalArgumentException {
        String erg = null;
        if (this.checkMappingDirection(mappingDirection)) {
            MappingCodeGenerator mapGen = new MappingCodeGenerator(mappingDirection);
            aPLMaterial.accept(mapGen);
            erg = mapGen.getMappingCode();
        }
        return erg;
    }

    private boolean checkMappingDirection(int mappingDirection) throws IllegalArgumentException {
        boolean erg = false;
        if (mappingDirection != 100 && mappingDirection != 101 && mappingDirection != 102 && mappingDirection != 103) {
            throw new IllegalArgumentException("Die vorgegebene Mappingrichtung wird nicht unterst\u00fctzt. (" + mappingDirection + ")");
        }
        erg = true;
        return erg;
    }

    public MetaProgram getRegelSpezifikation(Object object, int sourceFormat, int targetFormat) {
        MetaProgram regel = null;
        if (object instanceof MetaCustomMappingElement) {
            MetaCustomMappingElement element = (MetaCustomMappingElement)object;
            if (sourceFormat == 1) {
                regel = element.getQuellRegelSpezifikation();
            } else if (targetFormat == 1) {
                regel = element.getZielRegelSpezifikation();
            }
        }
        return regel;
    }

    protected int depth(String path) {
        int depth = 0;
        if (path != null) {
            int i = 0;
            while (i < path.length()) {
                if (path.charAt(i) == '.') {
                    ++depth;
                }
                ++i;
            }
        }
        return depth;
    }

    public boolean isGenerateMappingElementComments() {
        return this.generateMappingElementComments;
    }

    public void setGenerateMappingElementComments(boolean generateMappingElementComments) {
        this.generateMappingElementComments = generateMappingElementComments;
    }

    private class MappingCodeGenerator
    extends AbstractElementVisitor
    implements IndexVariableSupplier {
        private static final String INDENT = "   ";
        private StringBuffer code;
        private ArrayList mappingElementList;
        private MappingListAdapter listAdapter;
        private String einrueckung;
        private int sourceFormat;
        private int targetFormat;
        private DSBFeldHierarchie dsbFeldHierarchie;
        private RAWFeldHierarchie rawFeldHierarchie;
        private TBFeldHierarchie tbFeldHierarchie;
        Collection mappingSourceFieldNames = null;
        Collection mappingTargetFieldNames = null;

        public MappingCodeGenerator(int mappingDirection, Collection mappingSourceFieldNames, Collection mappingTargetFieldNames) {
            this.mappingSourceFieldNames = mappingSourceFieldNames;
            this.mappingTargetFieldNames = mappingTargetFieldNames;
            this.code = new StringBuffer();
            this.mappingElementList = new ArrayList();
            MappingProgramCodeGenerator.this.targetVARNames = new HashMap();
            MappingProgramCodeGenerator.this.sourceVARNames = new HashMap();
            this.setMappingDirection(mappingDirection);
            this.einrueckung = "";
        }

        public MappingCodeGenerator(int mappingDirection) {
            this(mappingDirection, null, null);
        }

        public String getMappingCode() {
            return this.code.toString();
        }

        private void schreiben(String string) {
            this.code.append(string);
        }

        private void umbruch() {
            this.code.append("\n");
        }

        private void einruecken() {
            this.code.append(this.einrueckung);
        }

        private void blockBeginn() {
            this.schreiben(this.einrueckung);
            this.umbruch();
            this.einrueckung = String.valueOf(this.einrueckung) + INDENT;
        }

        private void blockEnde() {
            this.einrueckung = this.einrueckung.substring(INDENT.length());
            this.schreiben(this.einrueckung);
        }

        private void setMappingDirection(int mappingDirection) {
            if (mappingDirection == 100) {
                this.sourceFormat = 2;
                this.targetFormat = 1;
            } else if (mappingDirection == 101) {
                this.sourceFormat = 1;
                this.targetFormat = 2;
            } else if (mappingDirection == 103) {
                this.sourceFormat = 1;
                this.targetFormat = 3;
            } else if (mappingDirection == 102) {
                this.sourceFormat = 3;
                this.targetFormat = 1;
            }
        }

        public void visitPlausibilisierung(MetaPlausibilisierung aPlausi) {
            if (aPlausi != null) {
                MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)aPlausi;
                boolean isSource = false;
                boolean mappingFound = false;
                if ((this.sourceFormat == 2 || this.targetFormat == 2) && plausi.getRawMapping() != null) {
                    if (this.sourceFormat == 2) {
                        isSource = true;
                    }
                    this.rawFeldHierarchie = new RAWFeldHierarchie(isSource);
                    this.rawFeldHierarchie.init(plausi.getRawDataSet());
                    plausi.getRawMapping().accept(this);
                    mappingFound = true;
                } else if ((this.sourceFormat == 3 || this.targetFormat == 3) && plausi.usedMappings() != null) {
                    if (this.sourceFormat == 3) {
                        isSource = true;
                    }
                    this.dsbFeldHierarchie = new DSBFeldHierarchie(isSource);
                    this.dsbFeldHierarchie.init(plausi.usedMappings().getDSB());
                    plausi.usedMappings().accept(this);
                    mappingFound = true;
                }
                if (mappingFound) {
                    this.tbFeldHierarchie = new TBFeldHierarchie(!isSource);
                    this.tbFeldHierarchie.init(plausi.rootThemenbereich());
                    this.generateLoopVARiableDeclarations();
                    this.generateCodeBySourceHierarchy();
                }
            }
        }

        public void visitPLMaterial(MetaPLMaterial aMaterial) {
            if (aMaterial != null && aMaterial instanceof MetaCustomPLMaterial) {
                MetaCustomPLMaterial plMaterial = (MetaCustomPLMaterial)aMaterial;
                boolean isSource = false;
                boolean mappingFound = false;
                if ((this.sourceFormat == 2 || this.targetFormat == 2) && plMaterial.getUsedRawMapping() != null) {
                    if (this.sourceFormat == 2) {
                        isSource = true;
                    }
                    this.rawFeldHierarchie = new RAWFeldHierarchie(isSource);
                    this.rawFeldHierarchie.init(plMaterial.getRawDataSet());
                    plMaterial.getUsedRawMapping().accept(this);
                    mappingFound = true;
                } else if ((this.sourceFormat == 3 || this.targetFormat == 3) && plMaterial.getMapping() != null) {
                    if (this.sourceFormat == 3) {
                        isSource = true;
                    }
                    this.dsbFeldHierarchie = new DSBFeldHierarchie(isSource);
                    this.dsbFeldHierarchie.init(plMaterial.getMapping().getDSB());
                    plMaterial.getMapping().accept(this);
                    mappingFound = true;
                }
                if (mappingFound) {
                    this.tbFeldHierarchie = new TBFeldHierarchie(!isSource);
                    this.tbFeldHierarchie.init(plMaterial.getThemenbereich());
                    this.generateLoopVARiableDeclarations();
                    this.generateCodeBySourceHierarchy();
                }
            }
        }

        private void generateLoopVARiableDeclarations() {
            Iterator it = MappingProgramCodeGenerator.this.targetVARNames.keySet().iterator();
            while (it.hasNext()) {
                String targetVARName = (String)MappingProgramCodeGenerator.this.targetVARNames.get(it.next());
                this.code.append("VAR " + targetVARName + "\n" + targetVARName + " := 1\n");
            }
            it = MappingProgramCodeGenerator.this.sourceVARNames.keySet().iterator();
            while (it.hasNext()) {
                String sourceVARName = (String)MappingProgramCodeGenerator.this.sourceVARNames.get(it.next());
                this.code.append("VAR " + sourceVARName + "\n" + sourceVARName + " := 1\n");
            }
        }

        private String generateLoopVARiableZeroForDirectAncestors(String path, HashMap varNames, String indent) {
            StringBuffer erg = new StringBuffer("");
            int hierarchieStufe = path.split("\\.").length;
            Iterator it = varNames.keySet().iterator();
            while (it.hasNext()) {
                int aktHierarchieStufe;
                String aktPath = (String)it.next();
                if (!aktPath.startsWith(path) || (aktHierarchieStufe = aktPath.split("\\.").length) != hierarchieStufe + 1) continue;
                erg.append(String.valueOf(indent) + varNames.get(aktPath) + " := 1\n");
            }
            return erg.toString();
        }

        private void generateCodeBySourceHierarchy() {
            MapElementComparator comparator = new MapElementComparator(this.sourceFormat);
            Object[] mappingElements = this.mappingElementList.toArray();
            Arrays.sort(mappingElements, comparator);
            this.listAdapter = new MappingListAdapter(mappingElements, this.sourceFormat);
            if (this.listAdapter != null && this.listAdapter.hasNext()) {
                this.generateCodeForHierarchiestufe(0, "");
            }
        }

        private void generateCodeForHierarchiestufe(int stufe, String indent) {
            boolean inHierarchie = true;
            while (this.listAdapter.hasNext() && inHierarchie) {
                MappingRegelGenerator mappingRegelGenerator;
                MetaCustomMappingElement mappingElement;
                int stufeOfNextElement = this.listAdapter.nextDepth();
                if (stufeOfNextElement > stufe) {
                    this.generateCodeForHierarchiestufe(stufe + 1, indent);
                    continue;
                }
                if (stufeOfNextElement < stufe) {
                    inHierarchie = false;
                    continue;
                }
                Object actual = this.listAdapter.next();
                if (!(actual instanceof MetaCustomMappingElement) || (mappingElement = (MetaCustomMappingElement)actual).getMappingTyp() != 0 && mappingElement.getMappingTyp() != 1) continue;
                String targetHierarchyName = this.getHierarchyAsString(mappingElement, this.targetFormat);
                String sourceHierarchyName = this.getHierarchyAsString(mappingElement, this.sourceFormat);
                if (this.mappingTargetFieldNames != null && !this.mappingTargetFieldNames.contains(targetHierarchyName) || this.mappingSourceFieldNames != null && !this.mappingSourceFieldNames.contains(sourceHierarchyName)) continue;
                String subIndent = String.valueOf(indent) + INDENT;
                String preText = "";
                String startText = "";
                String middleText = "";
                String endText = "";
                String postText = "";
                boolean isSubStructure = false;
                MetaProgram regelSpez = MappingProgramCodeGenerator.this.getRegelSpezifikation(mappingElement, this.sourceFormat, this.targetFormat);
                if (mappingElement.getMappingTyp() == 0) {
                    if (regelSpez != null) {
                        mappingRegelGenerator = new MappingRegelGenerator();
                        mappingRegelGenerator.generieren(regelSpez, this, indent);
                        preText = mappingRegelGenerator.getPreMappingCode();
                        postText = mappingRegelGenerator.getPostMappingCode();
                        startText = String.valueOf(startText) + INDENT;
                    }
                    startText = String.valueOf(startText) + indent + this.getHierarchyAsStringWithIndices(targetHierarchyName, MappingProgramCodeGenerator.this.targetVARNames, true) + " := " + this.getHierarchyAsStringWithIndices(sourceHierarchyName, MappingProgramCodeGenerator.this.sourceVARNames, true) + "\n";
                } else if (mappingElement.getMappingTyp() == 1) {
                    if (regelSpez != null) {
                        mappingRegelGenerator = new MappingRegelGenerator();
                        mappingRegelGenerator.generieren(regelSpez, this, subIndent);
                        startText = mappingRegelGenerator.getPreMappingCode();
                        endText = mappingRegelGenerator.getPostMappingCode();
                        subIndent = String.valueOf(subIndent) + INDENT;
                    }
                    String sourceVarName = (String)MappingProgramCodeGenerator.this.sourceVARNames.get(sourceHierarchyName);
                    preText = "";
                    if (sourceVarName != null) {
                        isSubStructure = true;
                        preText = String.valueOf(indent) + "WIEDERHOLE FUER " + MappingProgramCodeGenerator.this.sourceVARNames.get(sourceHierarchyName) + " := 1 BIS " + MappingProgramCodeGenerator.this.sourceVARNames.get(sourceHierarchyName) + " > ANZAHL VON " + this.getHierarchyAsStringWithIndices(sourceHierarchyName, MappingProgramCodeGenerator.this.sourceVARNames, false) + "\n";
                    }
                    String targetVarName = (String)MappingProgramCodeGenerator.this.targetVARNames.get(targetHierarchyName);
                    middleText = this.generateLoopVARiableZeroForDirectAncestors(targetHierarchyName, MappingProgramCodeGenerator.this.targetVARNames, subIndent);
                    postText = "";
                    if (targetVarName != null && sourceVarName != null) {
                        postText = String.valueOf(indent) + targetVarName + " := " + targetVarName + " + 1\n";
                    }
                    if (sourceVarName != null) {
                        postText = String.valueOf(postText) + indent + "ENDE\n";
                    }
                }
                StringBuffer codeBackup = this.code;
                this.code = new StringBuffer();
                if (this.listAdapter.hasSubStructure()) {
                    this.generateCodeForHierarchiestufe(stufe + 1, subIndent);
                }
                StringBuffer subMappingsBuf = this.code;
                this.code = codeBackup;
                String subMappings = subMappingsBuf.toString();
                if (isSubStructure && subMappings.trim().length() == 0) {
                    preText = "";
                    startText = "";
                    subMappings = "";
                    middleText = "";
                    endText = "";
                    postText = "";
                }
                if (MappingProgramCodeGenerator.this.isGenerateMappingElementComments()) {
                    this.code.append(String.valueOf(indent) + "\"" + sourceHierarchyName + " -> " + targetHierarchyName + "\"\n");
                }
                this.code.append(preText);
                this.code.append(startText);
                this.code.append(subMappings);
                this.code.append(middleText);
                this.code.append(endText);
                this.code.append(postText);
            }
        }

        public void visitMapping(MetaMapping aMapping) {
            this.visitElements(aMapping.getMappingliste());
        }

        public void visitMappingElement(MetaMappingElement anElement) {
            this.mappingElementList.add(anElement);
        }

        public String getSourceIndexVariable(String structure) {
            return (String)MappingProgramCodeGenerator.this.sourceVARNames.get(structure);
        }

        public String getTargetIndexVariable(String structure) {
            return (String)MappingProgramCodeGenerator.this.targetVARNames.get(structure);
        }

        private String getHierarchyAsStringWithIndices(String hierarchy, HashMap varNames, boolean withLastIndex) {
            String hierarchyWithIndices = "";
            String aktPath = "";
            String[] path = hierarchy.split("\\.");
            if (path != null) {
                int i = 0;
                while (i < path.length) {
                    if (i > 0) {
                        aktPath = String.valueOf(aktPath) + ".";
                        hierarchyWithIndices = String.valueOf(hierarchyWithIndices) + ".";
                    }
                    aktPath = String.valueOf(aktPath) + path[i];
                    hierarchyWithIndices = String.valueOf(hierarchyWithIndices) + path[i];
                    if (varNames.containsKey(aktPath) && (withLastIndex || i + 1 < path.length)) {
                        hierarchyWithIndices = String.valueOf(hierarchyWithIndices) + "[" + varNames.get(aktPath) + "]";
                    }
                    ++i;
                }
            }
            return hierarchyWithIndices;
        }

        public String getHierarchyAsString(Object object, int dataFormat) {
            String hierarchy = "";
            if (object instanceof MetaCustomMappingElement) {
                MetaCustomMappingElement element = (MetaCustomMappingElement)object;
                if (dataFormat == 2) {
                    if (element.getFeldRaw() != null) {
                        if (element.getFeldRaw() instanceof MetaCustomRawField) {
                            hierarchy = ((MetaCustomRawField)element.getFeldRaw()).hierarchyAsString();
                        } else if (element.getFeldRaw() instanceof MetaCustomRawFieldGroup) {
                            hierarchy = ((MetaCustomRawFieldGroup)element.getFeldRaw()).hierarchyAsString();
                        }
                    } else if (element.getRawSet() != null) {
                        hierarchy = element.getRawSet().getName();
                    }
                } else if (dataFormat == 1) {
                    hierarchy = element.getTBFeldListeAlsName();
                } else if (dataFormat == 3) {
                    if (element.getFeldDSB() != null) {
                        hierarchy = this.dsbFeldHierarchie.getHierarchieFor(element.getFeldDSB());
                    } else if (element.getFeldSatzart() != null) {
                        hierarchy = this.dsbFeldHierarchie.getHierarchieFor(element.getFeldSatzart());
                    }
                }
            }
            if (hierarchy != null) {
                hierarchy = MappingUtil.encodeName(hierarchy);
            }
            return hierarchy;
        }

        public class DSBFeldHierarchie
        extends FieldHierarchie {
            public DSBFeldHierarchie(boolean isSource) {
                super(isSource);
            }

            public void init(MetaDsbObjekt dsb) {
                this.hierarchieFelder = new HashMap();
                this.aktuelleFeldhierarchie = new Stack();
                this.aktuelleHierarchiestufe = 1;
                if (dsb != null) {
                    dsb.accept(this);
                }
            }

            public void visitDsbObjekt(MetaDsbObjekt aDsb) {
                if (aDsb.getComps() != null) {
                    aDsb.getComps().accept(this);
                }
            }

            public void visitDsbComps(MetaDsbComps anObject) {
                this.visitElements(anObject.getCompList());
                this.visitElements(anObject.getSatzList());
            }

            public void visitEinzelfeld(MetaEinzelfeld anObject) {
                while (this.aktuelleHierarchiestufe > anObject.getStufenNr()) {
                    this.aktuelleFeldhierarchie.pop();
                    this.aktuelleHierarchiestufe = (short)(this.aktuelleHierarchiestufe - 1);
                }
                this.hierarchieFelder.put(anObject, this.getFeldHierarchie(anObject.getName()));
                if (this.istStructurTyp(anObject.getTyp())) {
                    this.aktuelleFeldhierarchie.push(anObject.getName());
                    this.aktuelleHierarchiestufe = (short)(anObject.getStufenNr() + 1);
                    if (this.istArrayTyp(anObject.getTyp())) {
                        String path = this.getHierarchieFor(anObject);
                        this.varNames.put(path, this.generateVar(path));
                    }
                }
            }

            public void visitSatzart(MetaSatzart anObject) {
                while (!this.aktuelleFeldhierarchie.isEmpty()) {
                    this.aktuelleFeldhierarchie.pop();
                }
                this.hierarchieFelder.put(anObject, this.getFeldHierarchie(anObject.getName()));
                this.aktuelleFeldhierarchie.push(anObject.getName());
                this.aktuelleHierarchiestufe = 1;
                String path = this.getHierarchieFor(anObject);
                this.varNames.put(path, this.generateVar(path));
                this.visitElements(anObject.getFelder());
                this.aktuelleFeldhierarchie.pop();
                this.aktuelleHierarchiestufe = 1;
            }

            private boolean istArrayTyp(String typ) {
                boolean erg = false;
                if ("Wfgr".equals(typ) || "VKWG".equals(typ)) {
                    erg = true;
                }
                return erg;
            }

            private boolean istStructurTyp(String typ) {
                boolean erg = false;
                if ("Str".equals(typ) || "Wfgr".equals(typ) || "VKWG".equals(typ)) {
                    erg = true;
                }
                return erg;
            }
        }

        public class FieldHierarchie
        extends AbstractElementVisitor {
            protected HashMap hierarchieFelder = null;
            protected Stack aktuelleFeldhierarchie = null;
            protected short aktuelleHierarchiestufe = 1;
            protected HashMap varNames = null;
            private boolean isSource = false;

            public FieldHierarchie(boolean isSource) {
                this.varNames = isSource ? MappingProgramCodeGenerator.this.sourceVARNames : MappingProgramCodeGenerator.this.targetVARNames;
                this.isSource = isSource;
            }

            public String getHierarchieFor(Object feld) {
                String erg = "";
                if (this.hierarchieFelder != null && this.hierarchieFelder.containsKey(feld)) {
                    erg = this.hierarchieFelder.get(feld).toString();
                }
                return erg;
            }

            protected String getFeldHierarchie(String feldname) {
                StringBuffer buf = new StringBuffer();
                if (!this.aktuelleFeldhierarchie.isEmpty()) {
                    Iterator hierIt = this.aktuelleFeldhierarchie.iterator();
                    while (hierIt != null && hierIt.hasNext()) {
                        buf.append(hierIt.next());
                        buf.append('.');
                    }
                }
                buf.append(feldname);
                return buf.toString();
            }

            private String generateTargetVar(String varname) {
                varname = MappingUtil.encodeName(varname);
                return "Z_" + varname.replaceAll("\\.", "_");
            }

            private String generateSourceVar(String varname) {
                varname = MappingUtil.encodeName(varname);
                return "Q_" + varname.replaceAll("\\.", "_");
            }

            protected String generateVar(String varname) {
                String result = "";
                result = this.isSource ? this.generateSourceVar(varname) : this.generateTargetVar(varname);
                return result;
            }
        }

        private class MapElementComparator
        implements Comparator {
            private int dataFormat;

            public MapElementComparator(int dataFormatForSort) {
                this.dataFormat = dataFormatForSort;
            }

            public int compareXXX(Object o1, Object o2) {
                int erg = -1;
                if (o1 instanceof MetaCustomMappingElement && o2 instanceof MetaCustomMappingElement) {
                    int depth2;
                    String pathAndName1 = MappingCodeGenerator.this.getHierarchyAsString(o1, this.dataFormat);
                    String pathAndName2 = MappingCodeGenerator.this.getHierarchyAsString(o2, this.dataFormat);
                    int depth1 = MappingProgramCodeGenerator.this.depth(pathAndName1);
                    erg = depth1 == (depth2 = MappingProgramCodeGenerator.this.depth(pathAndName2)) ? pathAndName1.compareTo(pathAndName2) : depth1 - depth2;
                }
                return erg;
            }

            public int compare(Object o1, Object o2) {
                int erg = -1;
                if (o1 instanceof MetaCustomMappingElement && o2 instanceof MetaCustomMappingElement) {
                    String pathAndName1 = MappingCodeGenerator.this.getHierarchyAsString(o1, this.dataFormat);
                    String pathAndName2 = MappingCodeGenerator.this.getHierarchyAsString(o2, this.dataFormat);
                    erg = pathAndName1.compareTo(pathAndName2);
                }
                return erg;
            }
        }

        private class MappingListAdapter {
            private int aktIndex = -1;
            private Object[] mappingListe;
            private int sourceFormat;

            public MappingListAdapter(Object[] neueMappingListe, int neuesSourceFormat) {
                this.mappingListe = neueMappingListe;
                this.sourceFormat = neuesSourceFormat;
            }

            public boolean hasNext() {
                return this.mappingListe != null && this.aktIndex + 1 < this.mappingListe.length;
            }

            public boolean hasSubStructure() {
                boolean hasSubStructure = false;
                if (this.hasNext()) {
                    Object actual = this.actual();
                    if (actual == null) {
                        hasSubStructure = true;
                    } else {
                        Object next = this.mappingListe[this.aktIndex + 1];
                        String actualPath = MappingCodeGenerator.this.getHierarchyAsString(actual, this.sourceFormat);
                        String nextPath = MappingCodeGenerator.this.getHierarchyAsString(next, this.sourceFormat);
                        if (actualPath != null && nextPath != null && actualPath.length() > 0 && nextPath.length() > 0 && nextPath.startsWith(actualPath)) {
                            hasSubStructure = true;
                        }
                    }
                }
                return hasSubStructure;
            }

            public Object next() {
                Object next = null;
                if (this.hasNext()) {
                    ++this.aktIndex;
                    next = this.mappingListe[this.aktIndex];
                }
                return next;
            }

            public Object actual() {
                Object actual = null;
                if (this.mappingListe != null && this.aktIndex >= 0 && this.aktIndex < this.mappingListe.length) {
                    actual = this.mappingListe[this.aktIndex];
                }
                return actual;
            }

            public int nextDepth() {
                Object next;
                String nextPath;
                int nextDepth = 0;
                if (this.hasNext() && (nextPath = MappingCodeGenerator.this.getHierarchyAsString(next = this.mappingListe[this.aktIndex + 1], this.sourceFormat)) != null && nextPath.length() > 0) {
                    nextDepth = MappingProgramCodeGenerator.this.depth(nextPath);
                }
                return nextDepth;
            }
        }

        public class RAWFeldHierarchie
        extends FieldHierarchie {
            public RAWFeldHierarchie(boolean isSource) {
                super(isSource);
            }

            public void init(MetaRawDataSet anOboject) {
                this.hierarchieFelder = new HashMap();
                this.aktuelleFeldhierarchie = new Stack();
                this.aktuelleHierarchiestufe = 1;
                anOboject.accept(this);
            }

            public void visitRawDataSet(MetaRawDataSet anObject) {
                this.visitElements(anObject.getListOfRawField());
                this.visitElements(anObject.getListOfRawSet());
            }

            public void visitRawSet(MetaRawSet anObject) {
                while (!this.aktuelleFeldhierarchie.isEmpty()) {
                    this.aktuelleFeldhierarchie.pop();
                }
                this.hierarchieFelder.put(anObject, this.getFeldHierarchie(anObject.getName()));
                this.aktuelleFeldhierarchie.push(anObject.getName());
                this.aktuelleHierarchiestufe = 1;
                String path = this.getHierarchieFor(anObject);
                this.varNames.put(path, this.generateVar(path));
                this.visitElements(anObject.getListOfRawField());
                this.aktuelleFeldhierarchie.pop();
                this.aktuelleHierarchiestufe = 1;
            }

            public void visitRawField(MetaRawField anObject) {
            }

            public void visitRawFieldGroup(MetaRawFieldGroup anObject) {
                this.hierarchieFelder.put(anObject, this.getFeldHierarchie(anObject.getName()));
                this.aktuelleFeldhierarchie.push(anObject.getName());
                this.aktuelleHierarchiestufe = (short)(this.aktuelleHierarchiestufe + 1);
                String path = this.getHierarchieFor(anObject);
                this.varNames.put(path, this.generateVar(path));
                this.visitElements(anObject.getListOfRawField());
                this.aktuelleFeldhierarchie.pop();
                this.aktuelleHierarchiestufe = (short)(this.aktuelleHierarchiestufe - 1);
            }
        }

        public class TBFeldHierarchie
        extends FieldHierarchie {
            public TBFeldHierarchie(boolean isSource) {
                super(isSource);
            }

            public void init(MetaThemenbereich themenbereich) {
                this.hierarchieFelder = new HashMap();
                this.aktuelleFeldhierarchie = new Stack();
                this.aktuelleHierarchiestufe = 1;
                themenbereich.accept(this);
            }

            public void visitTBFeld(MetaTBFeld anObject) {
                MetaCustomTBFeld feld = (MetaCustomTBFeld)anObject;
                if (feld.getKlasse() instanceof MetaThemenbereich) {
                    this.hierarchieFelder.put(feld, this.getFeldHierarchie(feld.getName()));
                    this.aktuelleFeldhierarchie.push(feld.getName());
                    this.aktuelleHierarchiestufe = (short)(this.aktuelleHierarchiestufe + 1);
                    if (feld.getListe()) {
                        String path = this.getHierarchieFor(feld);
                        this.varNames.put(path, this.generateVar(path));
                    }
                    this.visitElements(((MetaThemenbereich)feld.getKlasse()).getFelder());
                    this.aktuelleFeldhierarchie.pop();
                    this.aktuelleHierarchiestufe = (short)(this.aktuelleHierarchiestufe - 1);
                }
            }

            public void visitThemenbereich(MetaThemenbereich tb) {
                this.visitElements(tb.getFelder());
            }
        }
    }
}

