/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.semantic;

import de.statspez.pleditor.generator.codegen.semantic.SemanticCheckResult;
import de.statspez.pleditor.generator.codegen.support.AbstractCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.ClassificationRegKeyBuilder;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.masken.MaskeException;
import de.statspez.pleditor.generator.masken.MaskenParserFaktory;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaContextOperator;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachIndexOperator;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForEachStatement;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalOperator;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSelfAccess;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSetStatement;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaSizeTestingOperator;
import de.statspez.pleditor.generator.meta.MetaStatement;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import java.util.Iterator;
import java.util.Stack;

public class SemanticCheck
extends AbstractCodeGenerator {
    private SemanticCheckResult result = null;
    private Scope scopeForReadAccess = null;
    private Scope scopeForWriteAccess = null;
    private boolean withinSetValueAccess = false;
    private Stack scopeStack = null;
    private Stack scopeMapStack = null;
    private NamespaceHelper nsHelper = null;
    private MetaIdentifier lastSymbol = null;
    private SymbolDescriptor lastDescriptor = new GenericSymbolDescriptor();
    private Stack arraysMustHaveIndicesStack = new Stack();
    private boolean arraysMustHaveIndices = true;
    private Stack arraysMustHaveNumericIndicesStack = new Stack();
    private boolean arraysMustHaveNumericIndices = true;
    private boolean arraysMustHaveLessIndicesThanDimensions = false;
    private boolean canHaveSelfAccess = false;
    private Stack structureAccessStack = new Stack();
    private Stack typeStack = null;
    protected boolean returnCalled = false;
    protected boolean breakCalled = false;
    protected boolean breakAllowed = false;
    protected boolean plausiStatementsAllowed = false;
    protected static final int IDENTIFIER_TYPE_UNDEFINED = 0;
    protected static final int IDENTIFIER_TYPE_FUNCTION = 1;
    protected static final int IDENTIFIER_TYPE_CHECK = 2;
    protected static final int IDENTIFIER_TYPE_ABLAUF = 3;
    protected static final int IDENTIFIER_TYPE_MATERIAL = 4;
    protected Stack requestedIdentifiertType = new Stack();
    private boolean mappingContext = false;
    private boolean nextElementInGlobalNamespace = false;
    private NamespaceHelper superNsHelper = new NamespaceHelper();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.semantic.SemanticCheck");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SemanticCheckResult checkProgram(MetaProgram aProgram, Scope aScope) {
        return this.checkProgram(aProgram, aScope, aScope);
    }

    public SemanticCheckResult checkProgram(MetaProgram aProgram, Scope aScopeForReadAccess, Scope aScopeForWriteAccess) {
        this.result = new SemanticCheckResult();
        if (aScopeForReadAccess == aScopeForWriteAccess) {
            this.scopeForReadAccess = this.scopeForWriteAccess = new ScopeImpl(aScopeForWriteAccess);
        } else {
            this.scopeForWriteAccess = new ScopeImpl(aScopeForWriteAccess);
            this.scopeForReadAccess = new ScopeImpl(aScopeForReadAccess);
        }
        this.scopeStack = new Stack();
        this.scopeMapStack = new Stack();
        this.nsHelper = new NamespaceHelper();
        this.typeStack = new Stack();
        this.arraysMustHaveIndices = true;
        this.arraysMustHaveLessIndicesThanDimensions = false;
        this.canHaveSelfAccess = aProgram.isCanHaveSelfAccess();
        this.breakAllowed = false;
        this.plausiStatementsAllowed = aProgram.isPlausiStatementsAllowed();
        aProgram.accept(this);
        this.checkForErrors();
        return this.result;
    }

    public void visitIdentifier(MetaIdentifier anIdentifier) {
        boolean namespaceChanged = false;
        if (this.nsHelper.prettyNamespace().length() > 0 && !this.withinStructureAccess() && this.getScope().isDefined(anIdentifier, "Kontext")) {
            this.nsHelper.startNewNamespace();
            namespaceChanged = true;
        }
        if (!this.getScope().isDefined(anIdentifier, this.nsHelper.namespace())) {
            this.error(anIdentifier, String.valueOf(anIdentifier.toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert (" + this.nsHelper.prettyNamespace() + ").");
        } else {
            SymbolDescriptor refSymbol = this.getScope().symbolDescriptor(anIdentifier, this.nsHelper.namespace());
            if (refSymbol == null) {
                this.error(anIdentifier, String.valueOf(anIdentifier.toString()) + " konnte in diesem Gueltigkeitsbereich nicht ermittelt werden (" + this.nsHelper.prettyNamespace() + ").");
            } else {
                this.result.addVerwendetesSymbole(refSymbol);
                if (refSymbol.isEigenschaft() && this.getRequestedIdentifiertType() != 1) {
                    this.error(anIdentifier, "Die Eigenschaft " + anIdentifier.value() + " muss mit den Schl\u00fcsselworten EIGENSCHAFT oder IST verwendet werden.");
                } else if (refSymbol.isPruefung() && this.getRequestedIdentifiertType() != 2) {
                    this.error(anIdentifier, "Die Pr\u00fcfung " + anIdentifier.value() + " muss mit dem Schl\u00fcsselwort PRUEFE verwendet werden.");
                } else if (refSymbol.isAblauf() && this.getRequestedIdentifiertType() != 3) {
                    this.error(anIdentifier, "Der Ablauf " + anIdentifier.value() + " muss mit den Schl\u00fcsselworten THEMENBEREICH MIT ABLAUF verwendet werden.");
                } else if (refSymbol.isFunction() && !refSymbol.isAblauf() && !refSymbol.isPruefung() && !refSymbol.isEigenschaft() && this.getRequestedIdentifiertType() != 1) {
                    this.error(anIdentifier, "Die Funktion " + anIdentifier.value() + " muss mit den Schl\u00fcsselworten FUNKTION oder & verwendet werden.");
                } else if (refSymbol.isMaterial() && this.getRequestedIdentifiertType() != 4) {
                    this.error(anIdentifier, "Das Material " + anIdentifier.value() + " muss mit dem Schl\u00fcsselwort MATERIAL verwendet werden.");
                }
            }
        }
        this.setLastSym(anIdentifier);
        if (namespaceChanged) {
            this.nsHelper.leaveThisNamespace();
        }
    }

    public void visitNumber(MetaNumber aNumber) {
        this.typeStack.push(this.createSymDescWithType(2));
    }

    public void visitString(MetaString aString) {
        this.typeStack.push(this.createSymDescWithType(4));
    }

    public void visitBoolean(MetaBoolean aBoolean) {
        this.typeStack.push(this.createSymDescWithType(8));
    }

    public void visitDate(MetaDate aDate) {
        aDate.specification().accept(this);
        if (!this.checkType(4)) {
            this.error(aDate, "Ein Datum muss als String spezifiert werden.");
        }
        if (aDate.format() != null) {
            try {
                MaskenParserInterface maskenParser = null;
                maskenParser = MaskenParserFaktory.getInstance().getMaskenParserFuerTyp(2);
                maskenParser.parse(aDate.format());
            }
            catch (MaskeException e) {
                this.error(aDate, e.getMessage());
            }
        }
        this.typeStack.push(this.createSymDescWithType(16));
    }

    public void visitNoValue(MetaNoValue value) {
        SymbolDescriptor sd = this.createSymDescWithType(512);
        sd.setIsEmpty(true);
        this.typeStack.push(sd);
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accessedLiteral().accept(this);
    }

    public void visitSelfAccess(MetaSelfAccess aSelfAccess) {
        if (!this.canHaveSelfAccess) {
            this.error(aSelfAccess, "Die Verwendung des Schl\u00fcsselwortes WERT ist hier nicht erlaubt.");
        }
        this.typeStack.push(this.createSymDescWithType(512));
    }

    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        boolean namespaceChanged = false;
        if (this.nextElementInGlobalNamespace) {
            this.nsHelper.startNewNamespace();
            this.nextElementInGlobalNamespace = false;
            namespaceChanged = true;
        }
        aFieldAccess.accessedField().accept(this);
        if (namespaceChanged) {
            this.nsHelper.leaveThisNamespace();
        }
        if (this.lastDescriptor.isArray() && this.arraysMustHaveIndices) {
            this.error(aFieldAccess, String.valueOf(aFieldAccess.accessedField().toString()) + " ist eine Liste und kann hier nicht ohne Indizes" + " verwendet werden.");
        }
        this.typeStack.push(this.lastDescriptor);
    }

    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        boolean namespaceChanged = false;
        if (this.nextElementInGlobalNamespace) {
            this.nsHelper.startNewNamespace();
            this.nextElementInGlobalNamespace = false;
            namespaceChanged = true;
        }
        anArrayAccess.accessedArray().accept(this);
        if (namespaceChanged) {
            this.nsHelper.leaveThisNamespace();
        }
        this.newStructureAccessLevel(false);
        boolean wrongNumOfIndices = false;
        if (!this.lastDescriptor.isArray()) {
            this.error(anArrayAccess, String.valueOf(anArrayAccess.accessedArray().toString()) + " ist keine Liste.");
            wrongNumOfIndices = true;
        } else if (anArrayAccess.numberOfIndices() != this.lastDescriptor.dimensions()) {
            if (anArrayAccess.numberOfIndices() < this.lastDescriptor.dimensions() && this.arraysMustHaveIndices) {
                this.error(anArrayAccess, String.valueOf(anArrayAccess.accessedArray().toString()) + " erfordert " + this.lastDescriptor.dimensions() + " Indizes.");
                wrongNumOfIndices = true;
            } else if (anArrayAccess.numberOfIndices() > this.lastDescriptor.dimensions()) {
                this.error(anArrayAccess, String.valueOf(anArrayAccess.accessedArray().toString()) + " hat zuviele Indizes (max." + this.lastDescriptor.dimensions() + " zulaessig).");
                wrongNumOfIndices = true;
            }
        } else if (this.arraysMustHaveLessIndicesThanDimensions) {
            this.error(anArrayAccess, String.valueOf(anArrayAccess.accessedArray().toString()) + " hat zuviele Indizes (max." + (this.lastDescriptor.dimensions() - 1) + " zulaessig).");
            wrongNumOfIndices = true;
        }
        SymbolDescriptor lastDescriptorBefore = this.lastDescriptor;
        this.typeStack.push(this.lastDescriptor);
        if (!wrongNumOfIndices) {
            SymbolDescriptor arraySymbolDescriptor = this.lastDescriptor;
            boolean currentWithinSetValueAccess = this.withinSetValueAccess;
            this.withinSetValueAccess = false;
            int i = 0;
            while (i < anArrayAccess.numberOfIndices()) {
                MetaFactor index = anArrayAccess.indexAt(i);
                NamespaceHelper currentNs = this.nsHelper;
                this.nsHelper = this.superNsHelper;
                try {
                    if (index.adaptedObject() instanceof MetaForEachIndexOperator) {
                        if (this.arraysMustHaveNumericIndices) {
                            this.error(anArrayAccess, "Indexdefinition [ALLE] darf nur in Zusammenhang mit hierarchischen Funktionen verwendet werden.");
                        }
                    } else if (index.adaptedObject() instanceof MetaWithOperator) {
                        if (this.arraysMustHaveNumericIndices) {
                            this.error(anArrayAccess, "Indexdefinition [MIT ...] darf nur in Zusammenhang mit hierarchischen Funktionen verwendet werden.");
                        } else {
                            this.nsHelper = currentNs;
                            this.nsHelper.enterSubNamespace(anArrayAccess.accessedArray().value());
                            index.accept(this);
                            this.nsHelper.leaveSubNamespace();
                        }
                    } else if (index.adaptedObject() instanceof MetaRangeSeries) {
                        if (this.arraysMustHaveNumericIndices) {
                            this.error(anArrayAccess, "Indexdefinition [Reihe] darf nur in Zusammenhang mit hierarchischen Funktionen verwendet werden.");
                        } else {
                            index.accept(this);
                        }
                    } else if (index.adaptedObject() instanceof MetaLiteralAccess) {
                        MetaLiteralAccess mac = (MetaLiteralAccess)index.adaptedObject();
                        if (mac.accessedLiteral() instanceof MetaNumber) {
                            MetaNumber mn = (MetaNumber)mac.accessedLiteral();
                            if (mn.value().intValue() < 1) {
                                this.error(index, "Index muss gr\u00f6\u00dfer oder gleich 1 sein.");
                            } else if ((double)mn.value().intValue() != mn.value()) {
                                this.error(index, "Index muss eine ganze Zahl sein.");
                            } else if (arraySymbolDescriptor.dimension(i) > 0 && mn.value().intValue() > arraySymbolDescriptor.dimension(i)) {
                                this.error(index, "Index " + mn.value().intValue() + " \u00fcbersteigt die definierte Dimension (" + arraySymbolDescriptor.dimension(i) + ").");
                            }
                        }
                    } else if (index.adaptedObject() instanceof MetaSignOperator) {
                        MetaLiteralAccess mac;
                        MetaSignOperator mso = (MetaSignOperator)index.adaptedObject();
                        if (mso.type() == 2 && mso.operand().adaptedObject() instanceof MetaLiteralAccess && (mac = (MetaLiteralAccess)mso.operand().adaptedObject()).accessedLiteral() instanceof MetaNumber) {
                            this.error(index, "Index muss gr\u00f6\u00dfer oder gleich 1 sein.");
                        }
                    } else {
                        index.accept(this);
                        this.typeStack.pop();
                    }
                }
                finally {
                    this.nsHelper = currentNs;
                }
                ++i;
            }
            this.withinSetValueAccess = currentWithinSetValueAccess;
        }
        this.lastDescriptor = lastDescriptorBefore;
        this.leaveStructureAccessLevel();
    }

    public void visitStructureAccess(MetaStructureAccess anAccess) {
        Stack<MetaValueAccess> structureHelpStack = new Stack<MetaValueAccess>();
        structureHelpStack.push(anAccess.selectedElement());
        MetaValueAccess structureAccess = anAccess.structureAccess();
        while (structureAccess instanceof MetaStructureAccess) {
            MetaStructureAccess subStructureAccess = (MetaStructureAccess)structureAccess;
            structureHelpStack.push(subStructureAccess.selectedElement());
            structureAccess = subStructureAccess.structureAccess();
        }
        structureHelpStack.push(structureAccess);
        this.newStructureAccessLevel(true);
        boolean namespaceChanged = false;
        if (this.nextElementInGlobalNamespace) {
            this.nsHelper.startNewNamespace();
            this.nextElementInGlobalNamespace = false;
            namespaceChanged = true;
        }
        int namespaceCount = 0;
        boolean tmpArraysMustHaveLessIndicesThanDimensions = this.arraysMustHaveLessIndicesThanDimensions;
        while (!structureHelpStack.empty()) {
            MetaElement structureElement = (MetaElement)structureHelpStack.pop();
            if (tmpArraysMustHaveLessIndicesThanDimensions) {
                this.arraysMustHaveLessIndicesThanDimensions = structureHelpStack.empty();
            }
            structureElement.accept(this);
            if (structureElement instanceof MetaFieldAccess) {
                MetaFieldAccess fa = (MetaFieldAccess)structureElement;
                this.nsHelper.enterSubNamespace(fa.accessedField().value());
                ++namespaceCount;
            } else if (structureElement instanceof MetaArrayAccess) {
                MetaArrayAccess aa = (MetaArrayAccess)structureElement;
                this.nsHelper.enterSubNamespace(aa.accessedArray().value());
                ++namespaceCount;
            } else {
                this.error(structureElement, String.valueOf(structureElement.toString()) + " ist innerhalb einer Struktur nicht erlaubt.");
            }
            if (structureHelpStack.empty()) continue;
            this.typeStack.pop();
        }
        this.arraysMustHaveLessIndicesThanDimensions = tmpArraysMustHaveLessIndicesThanDimensions;
        int i = 0;
        while (i < namespaceCount) {
            this.nsHelper.leaveSubNamespace();
            ++i;
        }
        if (namespaceChanged) {
            this.nsHelper.leaveThisNamespace();
        }
        this.leaveStructureAccessLevel();
    }

    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        Iterator it = aRangeSeries.ranges();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            if (this.checkType(64)) continue;
            this.error(aRangeSeries, String.valueOf(this.lastSymbol.toString()) + " kann nicht Bestandteil einer Wertereihe sein.");
        }
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsRange(true);
        this.typeStack.push(typeDesc);
    }

    public void visitClassificationReference(MetaClassificationReference aReference) {
        ClassificationRegKeyBuilder keyBuilder = new ClassificationRegKeyBuilder();
        aReference.accept(keyBuilder);
        MetaIdentifier scopeSym = new MetaIdentifier(keyBuilder.regKey());
        if (!this.getScope().isDefined(scopeSym, "Kontext")) {
            this.error(aReference, String.valueOf(scopeSym.toString()) + " ist nicht in diesem G\u00fcltigkeitsbereich definiert.");
        } else {
            SymbolDescriptor refSymbol = this.getScope().symbolDescriptor(scopeSym, "Kontext");
            if (refSymbol == null) {
                this.error(scopeSym, String.valueOf(scopeSym.toString()) + " konnte in diesem G\u00fcltigkeitsbereich nicht ermittelt werden.");
            } else {
                this.result.addVerwendetesSymbole(refSymbol);
            }
        }
        this.setLastSym(scopeSym);
        this.typeStack.push(this.lastDescriptor);
    }

    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        aRange.value().accept(this);
        this.typeStack.pop();
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsRange(true);
        this.typeStack.push(typeDesc);
    }

    public void visitSequence(MetaSequence aSequence) {
        aSequence.first().accept(this);
        if (!this.checkType(2)) {
            this.error(aSequence, "Startwert der Sequenz muss numerisch sein.");
        }
        aSequence.second().accept(this);
        if (!this.checkType(2)) {
            this.error(aSequence, "Zweiter Wert der Sequenz muss numerisch sein.");
        }
        aSequence.last().accept(this);
        if (!this.checkType(2)) {
            this.error(aSequence, "Endwert der Sequenz muss numerisch sein.");
        }
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsRange(true);
        this.typeStack.push(typeDesc);
    }

    public void visitInterval(MetaInterval anInterval) {
        anInterval.first().accept(this);
        if (!this.checkType(18)) {
            this.error(anInterval, "Ung\u00fcltiger Startwert des Intervalls (Zahl oder Datum erwartet).");
        }
        anInterval.last().accept(this);
        if (!this.checkType(18)) {
            this.error(anInterval, "Ung\u00fcltiger Endwert des Intervalls (Zahl oder Datum erwartet).");
        }
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsRange(true);
        this.typeStack.push(typeDesc);
    }

    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        NamespaceHelper currentNs = this.nsHelper;
        this.nsHelper = new NamespaceHelper();
        try {
            if (!this.getScope().isDefined(anAccess.material(), this.nsHelper.namespace())) {
                this.error(anAccess, "Kein Material mit dem Namen '" + anAccess.material().value() + "' in diesem G\u00fcltigkeitsbereich definiert (" + this.nsHelper.prettyNamespace() + ").");
            } else {
                MetaTestingOperator condition;
                this.requestedIdentifiertType.push(new Integer(4));
                anAccess.material().accept(this);
                this.requestedIdentifiertType.pop();
                this.newStructureAccessLevel(true);
                NamespaceHelper tmpNs = this.nsHelper;
                this.nsHelper = currentNs;
                Iterator it = anAccess.selectionConditions();
                while (it.hasNext()) {
                    condition = (MetaTestingOperator)it.next();
                    condition.secondOperand().accept(this);
                    if (this.checkNotReferencesTb()) continue;
                    this.error(condition.secondOperand(), "Der lesende Zugriff auf ein Strukturfeld ist nicht erlaubt.");
                }
                this.nsHelper = tmpNs;
                this.nsHelper.enterSubNamespace(anAccess.material().value());
                it = anAccess.selectedFields();
                while (it.hasNext()) {
                    MetaValueAccess selectedField = (MetaValueAccess)it.next();
                    selectedField.accept(this);
                    if (this.checkNotReferencesTb()) continue;
                    this.error(selectedField, "Der lesende Zugriff auf ein Strukturfeld ist nicht erlaubt.");
                }
                it = anAccess.selectionConditions();
                while (it.hasNext()) {
                    condition = (MetaTestingOperator)it.next();
                    condition.firstOperand().accept(this);
                    if (this.checkNotReferencesTb()) continue;
                    this.error(condition.firstOperand(), "Der lesende Zugriff auf ein Strukturfeld ist nicht erlaubt.");
                }
                this.nsHelper.leaveSubNamespace();
                this.leaveStructureAccessLevel();
            }
            this.setLastSym(anAccess.material());
            this.typeStack.push(this.lastDescriptor);
        }
        finally {
            this.nsHelper = currentNs;
        }
    }

    public void visitStatementSequence(MetaStatementSequence aSequence) {
        this.beginNewScope();
        this.returnCalled = false;
        this.breakCalled = false;
        int i = 0;
        while (i < aSequence.numberOfStatements()) {
            aSequence.statementAt(i).accept(this);
            if (this.returnCalled && i < aSequence.numberOfStatements() - 1) {
                this.error(aSequence.statementAt(i + 1), "Spezifikationskode nicht erreichbar. Die R\u00fcckgabe-Anweisung darf nur am Ende einer Funktion verwendet werden.");
            }
            if (this.breakCalled && i < aSequence.numberOfStatements() - 1) {
                this.error(aSequence.statementAt(i + 1), "Spezifikationskode nach ABBRUCH-Anweisung nicht erreichbar.");
            }
            ++i;
        }
        this.leaveCurrentScope();
    }

    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        this.withinSetValueAccess = true;
        anAssignment.leftValue().accept(this);
        SymbolDescriptor targetSym = this.lastDescriptor;
        this.withinSetValueAccess = false;
        anAssignment.rightValue().accept(this);
        SymbolDescriptor sd = (SymbolDescriptor)this.typeStack.pop();
        boolean shouldCheckType = true;
        if (this.mappingContext && (sd.isString() && targetSym.isDate() || sd.isDate() && targetSym.isString())) {
            shouldCheckType = false;
        }
        if (targetSym.fieldReferencesTb() || sd.fieldReferencesTb()) {
            if (targetSym.fieldReferencesTb()) {
                this.error(anAssignment, "Einem Strukturfeld darf kein Wert zugewiesen werden.");
            }
            if (sd.fieldReferencesTb()) {
                this.error(anAssignment, "Ein Strukturfeld darf nicht als Wert zugewiesen werden.");
            }
        } else if (shouldCheckType && !targetSym.isAssignableFrom(sd)) {
            this.error(anAssignment, String.valueOf(anAssignment.leftValue().toString()) + " ist nicht kompatibel zum Typ des zugewiesenen Wertes.");
        } else if (targetSym.isPolymorphic()) {
            sd.transferType(targetSym);
        }
    }

    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
        Iterator it = anAssignment.leftValues();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            this.lastDescriptor.setType(512);
            this.typeStack.pop();
        }
        if (anAssignment.rightValue().value() instanceof MetaRangeSeries) {
            MetaRangeSeries mrs = (MetaRangeSeries)anAssignment.rightValue().value();
            if (mrs.numberOfRanges() < anAssignment.numberOfLeftValues()) {
                boolean containsOnlySingleValues = true;
                it = mrs.ranges();
                while (it.hasNext()) {
                    MetaSingleValueRange msvr;
                    MetaElement me = (MetaElement)it.next();
                    if (me instanceof MetaSequence) {
                        containsOnlySingleValues = false;
                        break;
                    }
                    if (!(me instanceof MetaSingleValueRange) || !((msvr = (MetaSingleValueRange)me).value().adaptedObject() instanceof MetaMaterialAccess)) continue;
                    containsOnlySingleValues = false;
                    break;
                }
                if (containsOnlySingleValues) {
                    this.error(anAssignment, "Die zugewiesene Reihe enth\u00e4lt weniger Werte als die Anzahl der Felder.");
                }
            }
        } else if (anAssignment.rightValue().value() instanceof MetaFactor) {
            MetaFactor mf = (MetaFactor)anAssignment.rightValue().value();
            if (!(mf.adaptedObject() instanceof MetaMaterialAccess)) {
                this.error(anAssignment, "Ein einzelner Wert kann nicht mehreren Feldern zugewiesen werden.");
            }
        } else {
            this.error(anAssignment, "Ein einzelner Wert kann nicht mehreren Feldern zugewiesen werden.");
        }
        anAssignment.rightValue().accept(this);
        this.typeStack.pop();
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        aStatement.condition().accept(this);
        if (!this.checkType(8)) {
            this.error(aStatement, "Die WENN-Bedingung ergibt keinen boolschen Wert.");
        }
        aStatement.ifTrue().accept(this);
        boolean ifTrueReturnCalled = this.returnCalled;
        boolean ifTrueBreakCalled = this.breakCalled;
        aStatement.ifFalse().accept(this);
        boolean ifFalseReturnCalled = this.returnCalled;
        boolean ifFalseBreakCalled = this.breakCalled;
        this.returnCalled = ifTrueReturnCalled && ifFalseReturnCalled;
        this.breakCalled = ifTrueBreakCalled && ifFalseBreakCalled;
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        MetaStatement stat;
        aStatement.startAssignment().accept(this);
        aStatement.endCondition().accept(this);
        if (!this.checkType(8)) {
            this.error(aStatement.endCondition(), "Die Abbruch-Bedingung einer Zahlschleife muss ein boolscher Wert sein.");
        }
        aStatement.stepExpression().accept(this);
        boolean prevBreakAllowed = this.breakAllowed;
        this.breakAllowed = true;
        aStatement.loopBody().accept(this);
        this.breakAllowed = prevBreakAllowed;
        int numOfStat = aStatement.loopBody().numberOfStatements();
        if (numOfStat > 0 && (stat = aStatement.loopBody().statementAt(numOfStat - 1)) != null && stat instanceof MetaReturnStatement) {
            this.error(stat, "Die R\u00fcckgabe-Anweisung darf nur am Ende einer Funktion verwendet werden.");
        }
        this.returnCalled = false;
        this.breakCalled = false;
    }

    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.beginNewScope();
        this.checkForEachStatement(aStatement);
        boolean prevBreakAllowed = this.breakAllowed;
        this.breakAllowed = true;
        aStatement.loopBody().accept(this);
        this.breakAllowed = prevBreakAllowed;
        this.leaveCurrentScope();
        this.returnCalled = false;
        this.breakCalled = false;
    }

    public void visitForEachCheck(MetaForEachCheck aStatement) {
        this.beginNewScope();
        this.checkForEachStatement(aStatement);
        aStatement.condition().accept(this);
        this.leaveCurrentScope();
    }

    public void visitBreakStatement(MetaBreakStatement aStatement) {
        if (!this.breakAllowed) {
            this.error(aStatement, "Die ABBRUCH-Anweisung ist nur innerhalb einer Schleife erlaubt.");
        } else {
            this.breakCalled = true;
        }
    }

    public void visitWhileLoop(MetaWhileLoop aStatement) {
        aStatement.condition().accept(this);
        if (!this.checkType(8)) {
            this.error(aStatement, "Die Abbruch-Bedingung ergibt keinen booleschen Wert.");
        }
        boolean prevBreakAllowed = this.breakAllowed;
        this.breakAllowed = true;
        aStatement.loopBody().accept(this);
        this.breakAllowed = prevBreakAllowed;
        this.returnCalled = false;
        this.breakCalled = false;
    }

    public void visitPrintStatement(MetaPrintStatement aStatement) {
        int i = 0;
        while (i < aStatement.numberOfElements()) {
            MetaElement element = aStatement.elementAt(i);
            element.accept(this);
            if (!this.checkNotReferencesTb()) {
                this.error(element, "Ein Strukturfeld kann nicht ausgegeben werden.");
            }
            ++i;
        }
        if (aStatement.leftValue() != null) {
            aStatement.leftValue().accept(this);
            if (!this.checkNotReferencesTb()) {
                this.error(aStatement.leftValue(), "Die Ausgabe in ein Strukturfeld ist nicht erlaubt.");
            }
        }
    }

    public void visitPruefeStatement(MetaPruefeStatement aStatement) {
        if (!this.plausiStatementsAllowed) {
            this.error(aStatement, "Der Aufruf einer Pr\u00fcfung ist hier nicht erlaubt.");
        }
        this.requestedIdentifiertType.push(new Integer(2));
        aStatement.function().accept(this);
        this.requestedIdentifiertType.pop();
        if (!this.lastDescriptor.isPruefung()) {
            this.error(aStatement, String.valueOf(aStatement.function().toString()) + " ist keine Pr\u00fcfung.");
        }
        this.typeStack.push(this.lastDescriptor);
    }

    public void visitAblaufStatement(MetaAblaufStatement aStatement) {
        if (!this.plausiStatementsAllowed) {
            this.error(aStatement, "Der Aufruf eines Ablaufs ist hier nicht erlaubt.");
        }
        this.requestedIdentifiertType.push(new Integer(3));
        aStatement.function().accept(this);
        this.requestedIdentifiertType.pop();
        SymbolDescriptor ablaufDesc = this.lastDescriptor;
        if (!ablaufDesc.isAblauf()) {
            this.error(aStatement, String.valueOf(aStatement.function().toString()) + " ist kein Ablauf.");
        }
        if (aStatement.numberOfParameters() != ablaufDesc.numberOfFunctionParameters()) {
            this.error(aStatement, "Ung\u00fcltige Anzahl von Parametern (" + ablaufDesc.numberOfFunctionParameters() + " gefordert, " + aStatement.numberOfParameters() + " gefunden).");
        } else {
            int i = 0;
            while (i < aStatement.numberOfParameters()) {
                if (ablaufDesc.functionParameterAt(i).isArray()) {
                    this.allowArraysWithoutIndices();
                }
                aStatement.parameterAt(i).accept(this);
                if (ablaufDesc.functionParameterAt(i).isArray()) {
                    this.revertToPreviousArraysWithoutIndices();
                }
                ++i;
            }
        }
    }

    public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
        if (!this.plausiStatementsAllowed) {
            this.error(aStatement, "Der Aufruf einer Feldpr\u00fcfung ist hier nicht erlaubt.");
        }
        if (aStatement.isStandalone()) {
            this.allowArraysWithoutIndices();
        }
        aStatement.field().accept(this);
        if (aStatement.isStandalone()) {
            this.revertToPreviousArraysWithoutIndices();
        }
        if (!this.checkTbFieldAndNotReferencesTb()) {
            this.error(aStatement, String.valueOf(aStatement.field().toString()) + " ist kein (einfaches) Feld.");
        }
        this.lastDescriptor = new GenericSymbolDescriptor();
        this.lastDescriptor.setType(8);
        this.typeStack.push(this.lastDescriptor);
    }

    public void visitReturnStatement(MetaReturnStatement aStatement) {
        aStatement.returnValue().accept(this);
        this.returnCalled = true;
    }

    public void visitFunctionCall(MetaFunctionCall aStatement) {
        this.requestedIdentifiertType.push(new Integer(1));
        boolean namespaceChanged = false;
        if (this.nextElementInGlobalNamespace) {
            this.nsHelper.startNewNamespace();
            this.nextElementInGlobalNamespace = false;
            namespaceChanged = true;
        }
        aStatement.function().accept(this);
        if (namespaceChanged) {
            this.nsHelper.leaveThisNamespace();
        }
        this.requestedIdentifiertType.pop();
        SymbolDescriptor funcDesc = this.lastDescriptor;
        if (!(funcDesc.isFunction() || funcDesc.isPruefung() || funcDesc.isEigenschaft())) {
            this.error(aStatement, String.valueOf(aStatement.function().toString()) + " ist keine Funktion.");
        } else if (aStatement.numberOfParameters() != funcDesc.numberOfFunctionParameters()) {
            this.error(aStatement, "Ung\u00fcltige Anzahl von Parametern (" + funcDesc.numberOfFunctionParameters() + " gefordert, " + aStatement.numberOfParameters() + " gefunden).");
        } else {
            int i = 0;
            while (i < aStatement.numberOfParameters()) {
                MetaFactor parameter = aStatement.parameterAt(i);
                SymbolDescriptor sd = funcDesc.functionParameterAt(i);
                if (sd.isArray()) {
                    this.allowArraysWithoutIndices();
                }
                parameter.accept(this);
                if (!this.checkNotReferencesTb()) {
                    this.error(parameter, "Ein Strukturfeld kann nicht als Parameter an eine Funktion \u00fcbergeben werden.");
                }
                if (sd.isArray()) {
                    this.revertToPreviousArraysWithoutIndices();
                }
                ++i;
            }
        }
        this.typeStack.push(this.createSymDescWithType(512));
    }

    public void visitProgram(MetaProgram aProgram) {
        this.visitElements(aProgram.parameters());
        aProgram.statements().accept(this);
        if (aProgram.isHasToReturnValue()) {
            if (!this.returnCalled) {
                this.error("Liefert keinen Wert (Schl\u00fcsselwort RUECKGABE fehlt).", aProgram.endLine(), aProgram.endColumn());
            }
        } else if (this.returnCalled) {
            this.error("Darf keinen Wert zur\u00fcckliefern.", aProgram.endLine(), aProgram.endColumn());
        }
    }

    public void visitProgramParameter(MetaProgramParameter aParameter) {
        SymbolDescriptor sd = new GenericSymbolDescriptorFactory().createSymbolDescriptor(aParameter);
        this.getScope().define(aParameter.name(), this.nsHelper.namespace(), sd);
    }

    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        Iterator it = aDeclaration.identifiers();
        while (it.hasNext()) {
            this.declareLocalVariable((MetaIdentifier)it.next());
        }
    }

    public void visitMathOperator(MetaMathOperator anOperator) {
        anOperator.firstOperand().accept(this);
        if (!this.checkType(2)) {
            this.error(anOperator, "Erster Operand ist nicht numerisch.");
        }
        anOperator.secondOperand().accept(this);
        if (!this.checkType(2)) {
            this.error(anOperator, "Zweiter Operand ist nicht numerisch.");
        }
        this.typeStack.push(this.createSymDescWithType(2));
    }

    public void visitSignOperator(MetaSignOperator anOperator) {
        anOperator.operand().accept(this);
        if (!this.checkType(2)) {
            this.error(anOperator, "Der Operand ist nicht numerisch.");
        }
        this.typeStack.push(this.createSymDescWithType(2));
    }

    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        anOperator.operand().accept(this);
        if (!this.checkType(8)) {
            this.error(anOperator, "Der Operand ist kein boolscher Wert.");
        }
        this.typeStack.push(this.createSymDescWithType(8));
    }

    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        anOperator.firstOperand().accept(this);
        if (!this.checkType(8)) {
            this.error(anOperator, "Erster Operand ist kein boolscher Wert.");
        }
        anOperator.secondOperand().accept(this);
        if (!this.checkType(8)) {
            this.error(anOperator, "Zweiter Operand ist kein boolscher Wert.");
        }
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsBoolean(true);
        this.typeStack.push(typeDesc);
    }

    public void visitTestingOperator(MetaTestingOperator anOperator) {
        anOperator.firstOperand().accept(this);
        if (!this.checkNotReferencesTb()) {
            this.error(anOperator, "Strukturfelder k\u00f6nnen nicht verglichen werden.");
        }
        anOperator.secondOperand().accept(this);
        SymbolDescriptor sd = (SymbolDescriptor)this.typeStack.peek();
        if (!this.checkNotReferencesTb()) {
            this.error(anOperator, "Strukturfelder k\u00f6nnen nicht verglichen werden.");
        }
        if (!(anOperator.type() != 7 || sd.isRange() || sd.isArray() || sd.isMaterial() || sd.isScalar() || sd.isFunction() || sd.isClassification() || sd.isClassificationGroup())) {
            this.error(anOperator, "Rechtes Element kann nicht als Aufz\u00e4hlung verwendet werden.");
        }
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsBoolean(true);
        this.typeStack.push(typeDesc);
    }

    public void visitTypeCheck(MetaTypeCheck typeCheck) {
        typeCheck.value().accept(this);
        this.typeStack.pop();
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsBoolean(true);
        this.typeStack.push(typeDesc);
    }

    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        this.allowArraysWithoutIndices();
        this.allowArraysWithConditionalIndices();
        anOperator.operand().accept(this);
        this.revertToPreviousArraysWithoutIndices();
        this.revertToPreviousArraysWithConditionalIndices();
        SymbolDescriptor sd = (SymbolDescriptor)this.typeStack.pop();
        if (!sd.isArray()) {
            this.error(anOperator, "Der Operand ist keine Liste.");
        }
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsNumeric(true);
        this.typeStack.push(typeDesc);
    }

    public void visitSizeTestingOperator(MetaSizeTestingOperator anOperator) {
        this.allowArraysWithoutIndices();
        this.allowArraysWithConditionalIndices();
        anOperator.secondOperand().accept(this);
        this.revertToPreviousArraysWithoutIndices();
        this.revertToPreviousArraysWithConditionalIndices();
        SymbolDescriptor sd = (SymbolDescriptor)this.typeStack.pop();
        if (!sd.isArray()) {
            this.error(anOperator, "Der Operand ist keine Liste.");
        }
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsBoolean(true);
        this.typeStack.push(typeDesc);
    }

    public void visitHierarchicalOperator(MetaHierarchicalOperator anOperator) {
        this.allowArraysWithConditionalIndices();
        anOperator.operand().accept(this);
        this.revertToPreviousArraysWithConditionalIndices();
        if (!this.checkType(2)) {
            this.error(anOperator, "Der Operand ist nicht numerisch.");
        }
        GenericSymbolDescriptor typeDesc = new GenericSymbolDescriptor();
        typeDesc.setIsNumeric(true);
        this.typeStack.push(typeDesc);
    }

    public void visitContextOperator(MetaContextOperator anOperator) {
        this.nextElementInGlobalNamespace = true;
        anOperator.operand().accept(this);
    }

    public void visitWithOperator(MetaWithOperator anOperator) {
        anOperator.operand().accept(this);
        if (!this.checkType(8)) {
            this.error(anOperator, "Der Operand ist kein boolscher Wert.");
        }
    }

    public void visitSetStatement(MetaSetStatement aSetStatemnt) {
        boolean tmp = this.arraysMustHaveLessIndicesThanDimensions;
        if (aSetStatemnt.getType() == MetaSetStatement.APPEND) {
            this.allowArraysWithoutIndices();
            this.arraysMustHaveLessIndicesThanDimensions = true;
        }
        this.allowArraysWithConditionalIndices();
        aSetStatemnt.getFactor().accept(this);
        if (aSetStatemnt.getType() == MetaSetStatement.APPEND) {
            this.revertToPreviousArraysWithoutIndices();
            this.arraysMustHaveLessIndicesThanDimensions = tmp;
        }
        this.revertToPreviousArraysWithConditionalIndices();
        if (!this.lastDescriptor.fieldReferencesTb()) {
            this.error(aSetStatemnt.getFactor(), "Der Operand ist keine Struktur.");
        }
        if (!this.lastDescriptor.isArray()) {
            this.error(aSetStatemnt.getFactor(), "Der Operand ist keine Liste.");
        }
    }

    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        this.allowArraysWithConditionalIndices();
        aStatement.value().accept(this);
        this.revertToPreviousArraysWithConditionalIndices();
        Stack<MetaElement> structureHelpStack = new Stack<MetaElement>();
        MetaElement anAccess = (MetaElement)((Object)aStatement.value().adaptedObject());
        while (anAccess instanceof MetaStructureAccess) {
            MetaStructureAccess structureAccess = (MetaStructureAccess)anAccess;
            structureHelpStack.push(structureAccess.selectedElement());
            anAccess = structureAccess.structureAccess();
        }
        structureHelpStack.push(anAccess);
        int namespaceCount = 0;
        while (!structureHelpStack.empty()) {
            MetaElement structureElement = (MetaElement)structureHelpStack.pop();
            if (structureElement instanceof MetaFieldAccess) {
                MetaFieldAccess fa = (MetaFieldAccess)structureElement;
                this.nsHelper.enterSubNamespace(fa.accessedField().value());
                this.superNsHelper.enterSubNamespace(fa.accessedField().value());
                ++namespaceCount;
                continue;
            }
            if (!(structureElement instanceof MetaArrayAccess)) continue;
            MetaArrayAccess aa = (MetaArrayAccess)structureElement;
            this.nsHelper.enterSubNamespace(aa.accessedArray().value());
            this.superNsHelper.enterSubNamespace(aa.accessedArray().value());
            ++namespaceCount;
        }
        boolean prevBreakAllowed = this.breakAllowed;
        this.breakAllowed = true;
        aStatement.loopBody().accept(this);
        this.breakAllowed = prevBreakAllowed;
        int i = 0;
        while (i < namespaceCount) {
            this.nsHelper.leaveSubNamespace();
            this.superNsHelper.leaveSubNamespace();
            ++i;
        }
        this.returnCalled = false;
        this.breakCalled = false;
    }

    public void setMappingContext(boolean mappingContext) {
        this.mappingContext = mappingContext;
    }

    private void beginNewScope() {
        if (!$assertionsDisabled && this.getScope() == null) {
            throw new AssertionError((Object)"kein aktuelles Scope");
        }
        if (this.scopeForReadAccess == this.scopeForWriteAccess) {
            ScopeImpl newScope = new ScopeImpl(this.getScope());
            this.scopeStack.push(this.getScope());
            this.scopeForReadAccess = newScope;
            this.scopeForWriteAccess = newScope;
        } else {
            ScopeImpl newScopeForWriteAcces = new ScopeImpl(this.scopeForWriteAccess);
            ScopeImpl newScopeForReadAcces = new ScopeImpl(this.scopeForReadAccess);
            this.scopeStack.push(this.scopeForReadAccess);
            this.scopeMapStack.push(this.scopeForWriteAccess);
            this.scopeForReadAccess = newScopeForReadAcces;
            this.scopeForWriteAccess = newScopeForWriteAcces;
        }
    }

    private void leaveCurrentScope() {
        if (!$assertionsDisabled && this.scopeStack.empty()) {
            throw new AssertionError((Object)"top-level Scope bereits erreicht");
        }
        if (this.scopeForReadAccess == this.scopeForWriteAccess) {
            this.scopeForWriteAccess = this.scopeForReadAccess = (Scope)this.scopeStack.pop();
        } else {
            this.scopeForReadAccess = (Scope)this.scopeStack.pop();
            this.scopeForWriteAccess = (Scope)this.scopeMapStack.pop();
        }
    }

    private void setLastSym(MetaIdentifier symbolId) {
        this.lastSymbol = symbolId;
        if (this.getScope().isDefined(symbolId, this.nsHelper.namespace())) {
            this.lastDescriptor = this.getScope().symbolDescriptor(symbolId, this.nsHelper.namespace());
        } else {
            this.lastDescriptor = new GenericSymbolDescriptor();
            this.lastDescriptor.setType(0);
        }
    }

    private void declareLocalVariable(MetaIdentifier id) {
        GenericSymbolDescriptor sd = new GenericSymbolDescriptor();
        sd.setIsPolymorphic(true);
        sd.setType(0);
        sd.setIsLokaleVariable(true);
        try {
            this.getScope().define(id, this.nsHelper.namespace(), sd);
        }
        catch (IllegalArgumentException exc) {
            this.error(id, exc.getMessage());
        }
        if (this.scopeForReadAccess != this.scopeForWriteAccess) {
            this.withinSetValueAccess = !this.withinSetValueAccess;
            try {
                this.getScope().define(id, this.nsHelper.namespace(), sd);
            }
            catch (IllegalArgumentException exc) {
                this.error(id, exc.getMessage());
            }
            this.withinSetValueAccess = !this.withinSetValueAccess;
        }
    }

    private void allowArraysWithoutIndices() {
        this.arraysMustHaveIndicesStack.push(new Boolean(this.arraysMustHaveIndices));
        this.arraysMustHaveIndices = false;
    }

    private void revertToPreviousArraysWithoutIndices() {
        this.arraysMustHaveIndices = (Boolean)this.arraysMustHaveIndicesStack.pop();
    }

    private void allowArraysWithConditionalIndices() {
        this.arraysMustHaveNumericIndicesStack.push(new Boolean(this.arraysMustHaveNumericIndices));
        this.arraysMustHaveNumericIndices = false;
    }

    private void revertToPreviousArraysWithConditionalIndices() {
        this.arraysMustHaveNumericIndices = (Boolean)this.arraysMustHaveNumericIndicesStack.pop();
    }

    private void newStructureAccessLevel(boolean start) {
        this.structureAccessStack.push(new Boolean(start));
    }

    private void leaveStructureAccessLevel() {
        this.structureAccessStack.pop();
    }

    private boolean withinStructureAccess() {
        if (this.structureAccessStack.isEmpty()) {
            return false;
        }
        return (Boolean)this.structureAccessStack.peek();
    }

    private boolean checkType(int expectedMask) {
        if (!$assertionsDisabled && this.typeStack.empty()) {
            throw new AssertionError((Object)"keine Typen auf dem Stack");
        }
        SymbolDescriptor sd = (SymbolDescriptor)this.typeStack.pop();
        return sd.checkType(expectedMask);
    }

    private boolean checkNotReferencesTb() {
        if (!$assertionsDisabled && this.typeStack.empty()) {
            throw new AssertionError((Object)"keine Typen auf dem Stack");
        }
        SymbolDescriptor sd = (SymbolDescriptor)this.typeStack.pop();
        return !sd.fieldReferencesTb();
    }

    private boolean checkTbFieldAndNotReferencesTb() {
        if (!$assertionsDisabled && this.typeStack.empty()) {
            throw new AssertionError((Object)"keine Typen auf dem Stack");
        }
        SymbolDescriptor sd = (SymbolDescriptor)this.typeStack.pop();
        return sd.isTbField() && !sd.fieldReferencesTb();
    }

    private SymbolDescriptor createSymDescWithType(int typeMask) {
        GenericSymbolDescriptor sd = new GenericSymbolDescriptor();
        sd.setType(typeMask);
        sd.setIsEmpty(false);
        return sd;
    }

    private void checkForEachStatement(MetaForEachStatement aStatement) {
        int i = 0;
        while (i < aStatement.numberOfVariables()) {
            if (!this.getScope().isDefined(aStatement.variableAt(i), this.nsHelper.namespace())) {
                this.declareLocalVariable(aStatement.variableAt(i));
            }
            SymbolDescriptor sd = this.getScope().symbolDescriptor(aStatement.variableAt(i), this.nsHelper.namespace());
            sd.setType(512);
            ++i;
        }
        this.visitElements(aStatement.variables());
        this.allowArraysWithoutIndices();
        aStatement.value().accept(this);
        this.revertToPreviousArraysWithoutIndices();
        Iterator it = aStatement.restrictions().iterator();
        while (it.hasNext()) {
            MetaElement e = (MetaElement)it.next();
            if (e == null) continue;
            e.accept(this);
        }
    }

    private int getRequestedIdentifiertType() {
        int result = 0;
        if (this.requestedIdentifiertType.size() > 0) {
            result = (Integer)this.requestedIdentifiertType.peek();
        }
        return result;
    }

    private Scope getScope() {
        return this.withinSetValueAccess ? this.scopeForWriteAccess : this.scopeForReadAccess;
    }
}

