/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.ui;

import de.statspez.pleditor.generator.compare2.CompareResult;
import de.statspez.pleditor.generator.compare2.ComparedNode;
import de.statspez.pleditor.generator.compare2.SatzInterfaceCompare;
import de.statspez.pleditor.generator.compare2.pdf.PdfConfig;
import de.statspez.pleditor.generator.compare2.pdf.PdfGenerator;
import de.statspez.pleditor.generator.compare2.ui.CETreeTableModel;
import de.statspez.pleditor.generator.compare2.ui.DataChangeEvent;
import de.statspez.pleditor.generator.compare2.ui.DataChangeListener;
import de.statspez.pleditor.generator.compare2.ui.PLErrorDialog;
import de.statspez.pleditor.generator.compare2.ui.TableColorRenderer;
import de.statspez.pleditor.generator.compare2.ui.TreeColorRenderer;
import de.statspez.pleditor.generator.compare2.ui.TreeTable;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class CompareEditor
extends JPanel {
    private static final long serialVersionUID = -3886835011768468732L;
    public static final Color COLOR_DIFFERENCES = new Color(208, 227, 255);
    private static final Color COLOR_CHANGES = new Color(255, 204, 153);
    private static final Color COLOR_PLACEHOLDER = Color.getHSBColor(0.0f, 0.0f, 0.9f);
    private static final Color COLOR_MARK = Color.red;
    private JToolBar toolBar;
    private JPanel toolPanel;
    private JLabel label;
    private JPopupMenu jPopupMenu;
    private TreeTable table;
    private CETreeTableModel treeTableModel;
    private ValueToLeftAction valueToLeftAction;
    private ToNextDifferenceAction toNextDifferenceAction;
    private ToPrevDifferenceAction toPrevDifferenceAction;
    private CopyToLeftAction copyToLeftAction;
    private CreateSatzAction createSatzAction;
    private DeleteElementAction deleteElementAction;
    private CompareResult compareResult;
    private boolean hauptsatzProtected = false;
    private boolean isDeleteElementActionAktiv = false;
    private TableColorRenderer tableRenderer;
    private Color colorForDifferences;
    private Color colorForChanges;
    private Color colorForPlaceholder;
    private Color colorForMark;
    private final List listenerList = new ArrayList();
    private FeldDeskriptorInterface[] errorFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CompareEditor(MetaCustomPlausibilisierung plausi, SatzInterface satz1, SatzInterface satz2, boolean hauptsatzProtected, boolean deleteElementActionActive, int displayOption) {
        this(new SatzInterfaceCompare().compare(plausi, satz1, satz2), hauptsatzProtected, deleteElementActionActive);
    }

    public CompareEditor(boolean hauptsatzProtected, boolean deleteElementActionActive) {
        super(new BorderLayout());
        this.colorForChanges = COLOR_CHANGES;
        this.colorForDifferences = COLOR_DIFFERENCES;
        this.setColorForPlaceholder(COLOR_PLACEHOLDER);
        this.colorForMark = COLOR_MARK;
        this.setHauptsatzProtected(hauptsatzProtected);
        this.setDeleteElementActionAktiv(deleteElementActionActive);
    }

    public CompareEditor(CompareResult compareResult, boolean hauptsatzProtected, boolean deleteElementActionActive) {
        this(hauptsatzProtected, deleteElementActionActive);
        this.setCompareResult(compareResult);
        this.buildAndAssembleUiComponents();
        this.addListSelectionListener();
        this.addColumnModelListener();
        this.addTreeModelListener();
        this.updateDifferingUI();
    }

    private void buildAndAssembleUiComponents() {
        this.treeTableModel = new CETreeTableModel(this.compareResult.getRootNode(), this.hauptsatzProtected);
        this.table = new TreeTable(this.treeTableModel, this);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setSelectionMode(0);
        this.table.getTree().getSelectionModel().setSelectionMode(1);
        this.table.setGridColor(SystemColor.control);
        this.table.setRowHeight(18);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.tableRenderer = new TableColorRenderer(this);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.table.setDefaultRenderer(clazz, this.tableRenderer);
        this.table.setTreeCellRenderer(new TreeColorRenderer());
        this.label = new JLabel();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)scrollPane, "Center");
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.valueToLeftAction = new ValueToLeftAction();
        this.copyToLeftAction = new CopyToLeftAction();
        this.createSatzAction = new CreateSatzAction();
        this.deleteElementAction = new DeleteElementAction();
        this.toNextDifferenceAction = new ToNextDifferenceAction();
        this.toPrevDifferenceAction = new ToPrevDifferenceAction();
        this.toolBar.add(this.createToolBarButton(this.toNextDifferenceAction));
        this.toolBar.add(this.createToolBarButton(this.toPrevDifferenceAction));
        if (!this.hauptsatzProtected) {
            this.toolBar.add(this.createToolBarButton(this.valueToLeftAction));
            this.toolBar.add(this.createToolBarButton(this.copyToLeftAction));
            this.toolBar.add(this.createToolBarButton(this.createSatzAction));
            if (this.isDeleteElementActionAktiv) {
                this.toolBar.add(this.createToolBarButton(this.deleteElementAction));
            }
        }
        this.addPopupMenu(this.hauptsatzProtected);
        this.toolPanel = new JPanel(new BorderLayout());
        this.toolPanel.add((Component)this.label, "Center");
        this.toolPanel.add((Component)this.toolBar, "East");
        this.label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add((Component)this.toolPanel, "North");
    }

    private void addListSelectionListener() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                CompareEditor.this.actionSelectionChanged();
            }
        });
    }

    private void addColumnModelListener() {
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnSelectionChanged(ListSelectionEvent e) {
                CompareEditor.this.actionSelectionChanged();
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnAdded(TableColumnModelEvent e) {
            }
        });
    }

    private void addTreeModelListener() {
        this.treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeStructureChanged(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
            }

            public void treeNodesChanged(TreeModelEvent e) {
                TreeTable treeTable = CompareEditor.this.table;
                JTree tree = treeTable.getTree();
                TreePath treePathForRow = tree.getPathForRow(CompareEditor.this.table.getSelectedRow());
                if (treePathForRow != null) {
                    ComparedNode selectedNode = (ComparedNode)treePathForRow.getLastPathComponent();
                    CompareEditor.this.updateDifferingUI();
                    CompareEditor.this.fireDataChangeEvent(selectedNode.getHauptsatz(), selectedNode.getFeldDeskriptor());
                }
            }
        });
    }

    private void actionSelectionChanged() {
        if (this.table.getSelectedRow() >= 0) {
            this.table.scrollRectToVisible(this.table.getCellRect(this.table.getSelectedRow(), 0, true));
            ComparedNode selectedNode = (ComparedNode)this.table.getTree().getPathForRow(this.table.getSelectedRow()).getLastPathComponent();
            this.setEnabledActions(selectedNode);
        } else {
            this.setEnabledActions(null);
        }
    }

    private void setEnabledActions(ComparedNode selectedNode) {
        this.deleteElementAction.setEnabled(false);
        if (this.createSatzAction != null) {
            this.createSatzAction.setEnabled(false);
        }
        if (selectedNode == null || !this.isSelecedColumnVergleichssatz()) {
            if (this.valueToLeftAction != null) {
                this.valueToLeftAction.setEnabled(false);
            }
            if (this.copyToLeftAction != null) {
                this.copyToLeftAction.setEnabled(false);
            }
            if (selectedNode != null && !this.isHauptsatzProtected() && selectedNode.isNDimensional() && selectedNode.hasHauptsatz() && selectedNode.getFeldDeskriptor().getIndizes() == null) {
                this.createSatzAction.setEnabled(true);
            }
            if (this.deleteElementAction != null && !this.isHauptsatzProtected() && selectedNode != null && selectedNode.isNDimensional() && selectedNode.hasHauptsatz() && !selectedNode.isRootKnoten() && selectedNode.isStrukturknoten() && selectedNode.getFeldDeskriptor().getIndizes() != null) {
                this.deleteElementAction.setEnabled(true);
            }
        } else {
            if (this.valueToLeftAction != null) {
                if (selectedNode.getChildCount() > 0) {
                    if (selectedNode.hasDifferentValues() || this.compareResult.getDifferingCount(selectedNode) > 0) {
                        this.valueToLeftAction.setEnabled(true);
                    } else if (!selectedNode.hasHauptsatz() || !selectedNode.hasValueSomeVergleichssatz()) {
                        this.valueToLeftAction.setEnabled(true);
                    } else {
                        this.valueToLeftAction.setEnabled(false);
                    }
                } else if (selectedNode.hasDifferentValues()) {
                    if (selectedNode.getParent() != null) {
                        if (selectedNode.getParent().hasHauptsatz() && selectedNode.getParent().hasSatzByVergleichssatzNr(this.getSelectedVergleichsatzNummer())) {
                            this.valueToLeftAction.setEnabled(true);
                        } else {
                            this.valueToLeftAction.setEnabled(false);
                        }
                    }
                } else {
                    this.valueToLeftAction.setEnabled(false);
                }
            }
            if (this.copyToLeftAction != null) {
                boolean enabled = selectedNode.isNDimensional() && selectedNode.hasSatzByVergleichssatzNr(this.getSelectedVergleichsatzNummer()) && selectedNode.getFeldDeskriptor().getIndizes() != null;
                this.copyToLeftAction.setEnabled(enabled);
            }
            if (this.createSatzAction != null) {
                this.createSatzAction.setEnabled(false);
            }
            if (this.deleteElementAction != null) {
                this.deleteElementAction.setEnabled(false);
            }
        }
    }

    private boolean isSelecedColumnVergleichssatz() {
        int selectedColumn = this.table.getSelectedColumn();
        return selectedColumn > 1;
    }

    private boolean isSelecedColumnHauptsatz() {
        int selectedColumn = this.table.getSelectedColumn();
        return selectedColumn == 1;
    }

    private int getSelectedVergleichsatzNummer() {
        int selectedColumn = this.table.getSelectedColumn();
        return selectedColumn - 1;
    }

    private void updateDifferingUI() {
        int count = this.compareResult.getDifferingCount(this.compareResult.getRootNode());
        if (count == 0) {
            this.label.setText("Kein Unterschied");
        } else {
            this.label.setText(String.valueOf(count) + " Unterschied" + (count > 1 ? "e" : ""));
        }
        this.toNextDifferenceAction.setEnabled(count > 0);
        this.toPrevDifferenceAction.setEnabled(count > 0);
    }

    public void setNameForColumn(int spaltenIndex, String name) {
        TableColumn column = this.table.getColumnModel().getColumn(spaltenIndex);
        column.setHeaderValue(name);
    }

    public void setColorForDifferences(Color color) {
        this.colorForDifferences = color;
    }

    public void setColorForChanges(Color color) {
        this.colorForChanges = color;
    }

    public Color getColorForChanges() {
        return this.colorForChanges;
    }

    public Color getColorForDifferences() {
        return this.colorForDifferences;
    }

    public Color getColorForPlaceholder() {
        return this.colorForPlaceholder;
    }

    public void setColorForPlaceholder(Color colorForPlaceholder) {
        this.colorForPlaceholder = colorForPlaceholder;
    }

    public void setColorForMark(Color color) {
        this.colorForMark = color;
    }

    public Color getColorForMark() {
        return this.colorForMark;
    }

    public void setToolBarVisible(boolean visible) {
        this.toolPanel.setVisible(visible);
    }

    public ToNextDifferenceAction getToNextDifferenceAction() {
        return this.toNextDifferenceAction;
    }

    public ToPrevDifferenceAction getToPrevDifferenceAction() {
        return this.toPrevDifferenceAction;
    }

    public ValueToLeftAction getValueToLeftAction() {
        return this.valueToLeftAction;
    }

    public CopyToLeftAction getCopyToLeftAction() {
        return this.copyToLeftAction;
    }

    public CreateSatzAction getCreateNodeAction() {
        return this.createSatzAction;
    }

    public DeleteElementAction getDeleteElementAction() {
        return this.deleteElementAction;
    }

    public void goToDifference(boolean stepForward) {
        TreePath selectedPath = this.table.getTree().getPathForRow(this.table.getSelectedRow());
        if (selectedPath == null) {
            selectedPath = new TreePath(this.compareResult.getRootNode().getPath());
        }
        ComparedNode selectedNode = (ComparedNode)selectedPath.getLastPathComponent();
        ComparedNode nextDifferingNode = stepForward ? this.compareResult.getNextDifferingNode(selectedNode) : this.compareResult.getPrevDifferingNode(selectedNode);
        if (nextDifferingNode == null) {
            nextDifferingNode = this.compareResult.getRootNode();
        } else {
            TreePath nextPath = new TreePath(nextDifferingNode.getPath());
            this.table.getTree().setSelectionPath(nextPath);
            Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(nextPath.getParentPath());
            if (expandedDescendants != null) {
                while (expandedDescendants.hasMoreElements()) {
                    this.table.getTree().expandPath(expandedDescendants.nextElement());
                }
            }
            this.table.getSelectionModel().setSelectionInterval(this.table.getTree().getRowForPath(nextPath), this.table.getTree().getRowForPath(nextPath));
        }
    }

    public void goToPreviousDifference() {
        ComparedNode selectedNode;
        ComparedNode nextDifferingNode;
        TreePath selectedPath = this.table.getTree().getPathForRow(this.table.getSelectedRow());
        if (selectedPath == null) {
            selectedPath = new TreePath(this.compareResult.getRootNode().getPath());
        }
        if ((nextDifferingNode = this.compareResult.getPrevDifferingNode(selectedNode = (ComparedNode)selectedPath.getLastPathComponent())) == null) {
            nextDifferingNode = this.compareResult.getRootNode();
        } else {
            TreePath nextPath = new TreePath(nextDifferingNode.getPath());
            this.table.getTree().setSelectionPath(nextPath);
            Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(nextPath.getParentPath());
            if (expandedDescendants != null) {
                while (expandedDescendants.hasMoreElements()) {
                    this.table.getTree().expandPath(expandedDescendants.nextElement());
                }
            }
            this.table.getSelectionModel().setSelectionInterval(this.table.getTree().getRowForPath(nextPath), this.table.getTree().getRowForPath(nextPath));
        }
    }

    public void transferSelectedValue() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            TreePath selectedPath = this.table.getTree().getPathForRow(selectedRow);
            ComparedNode selectedNode = (ComparedNode)selectedPath.getLastPathComponent();
            String valueOld = "";
            String valueNew = "";
            if (selectedNode != null) {
                if (selectedNode.getChildCount() > 0) {
                    String question = !selectedNode.hasSatzByVergleichssatzNr(this.getSelectedVergleichsatzNummer()) ? "Soll die ausgew\u00e4hlte Struktur im Hauptsatz gel\u00f6scht werden?" : "Sollen alle Unterschiede der ausgew\u00e4hlten Struktur in den Hauptsatz \u00fcbernommen werden?";
                    if (JOptionPane.showOptionDialog(this, question, "Achtung!", 1, 3, null, null, null) == 0) {
                        selectedNode.transferValue(this.getSelectedVergleichsatzNummer());
                        Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(selectedPath.getParentPath());
                        selectedNode.getParent().readValuesOfTree();
                        this.treeTableModel.nodeChanged(selectedNode);
                        if (expandedDescendants != null) {
                            while (expandedDescendants.hasMoreElements()) {
                                this.table.getTree().expandPath(expandedDescendants.nextElement());
                            }
                        }
                        if (selectedNode.isRemoved() && this.table.getRowCount() <= selectedRow) {
                            --selectedRow;
                        }
                        this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                        this.fireDataChangeEvent(this.compareResult.getRootNode().getHauptsatz(), selectedNode.getFeldDeskriptor());
                    }
                } else {
                    valueOld = selectedNode.getDisplayvalueOfHauptsatz();
                    selectedNode.transferValue(this.getSelectedVergleichsatzNummer());
                    Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(selectedPath.getParentPath());
                    selectedPath = new TreePath(selectedNode.getPath());
                    this.treeTableModel.nodeChanged(selectedNode);
                    if (expandedDescendants != null) {
                        while (expandedDescendants.hasMoreElements()) {
                            this.table.getTree().expandPath(expandedDescendants.nextElement());
                        }
                    }
                    this.table.getSelectionModel().setSelectionInterval(this.table.getTree().getRowForPath(selectedPath), this.table.getTree().getRowForPath(selectedPath));
                    valueNew = selectedNode.getDisplayvalueOfHauptsatz();
                    this.fireDataChangeEvent(((ComparedNode)this.treeTableModel.getRoot()).getHauptsatz(), valueOld, valueNew, selectedNode.getFeldDeskriptor());
                }
                this.updateDifferingUI();
            }
        }
    }

    public void copySelectedStrukturWithValue() throws NoSuchFieldException {
        String question;
        TreePath selectedPath;
        ComparedNode selectedNode;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0 && (selectedNode = (ComparedNode)(selectedPath = this.table.getTree().getPathForRow(selectedRow)).getLastPathComponent()) != null && selectedNode.getChildCount() > 0 && JOptionPane.showOptionDialog(this, question = "Soll die ausgew\u00e4hlte Struktur des Vergleichssatz in den Hauptsatz als neue Struktur hinzugef\u00fcgt werden?", "Achtung!", 1, 3, null, null, null) == 0) {
            selectedNode.copyValue(this.getSelectedVergleichsatzNummer());
            this.updateDifferingUI();
            Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(selectedPath.getParentPath());
            this.treeTableModel.nodeChanged(selectedNode);
            if (expandedDescendants != null) {
                while (expandedDescendants.hasMoreElements()) {
                    this.table.getTree().expandPath(expandedDescendants.nextElement());
                }
            }
            if (selectedNode.isRemoved() && this.table.getRowCount() <= selectedRow) {
                --selectedRow;
            }
            this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            this.fireDataChangeEvent(this.compareResult.getRootNode().getHauptsatz(), selectedNode.getFeldDeskriptor());
        }
    }

    public void appendSatzOnSelectedStruktur() throws NoSuchFieldException {
        TreePath selectedPath;
        ComparedNode selectedNode;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0 && (selectedNode = (ComparedNode)(selectedPath = this.table.getTree().getPathForRow(selectedRow)).getLastPathComponent()) != null) {
            ComparedNode newNode = selectedNode.appendSatz();
            newNode.setChanged(true);
            this.updateDifferingUI();
            Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(selectedPath.getParentPath());
            this.treeTableModel.nodeChanged(selectedNode);
            if (expandedDescendants != null) {
                while (expandedDescendants.hasMoreElements()) {
                    this.table.getTree().expandPath(expandedDescendants.nextElement());
                }
            }
            if (selectedNode.isRemoved() && this.table.getRowCount() <= selectedRow) {
                --selectedRow;
            }
            this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            this.fireDataChangeEvent(this.compareResult.getRootNode().getHauptsatz(), selectedNode.getFeldDeskriptor());
        }
    }

    public void deleteSelectedStruktur() {
        TreePath selectedPath;
        ComparedNode selectedNode;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0 && (selectedNode = (ComparedNode)(selectedPath = this.table.getTree().getPathForRow(selectedRow)).getLastPathComponent()) != null && selectedNode.isStrukturknoten() && selectedNode.isNDimensional() && selectedNode.getFeldDeskriptor().getIndizes() != null) {
            selectedNode.deleteThisStrukturknoten();
            Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(selectedPath.getParentPath());
            this.treeTableModel.nodeChanged(selectedNode);
            if (expandedDescendants != null) {
                while (expandedDescendants.hasMoreElements()) {
                    this.table.getTree().expandPath(expandedDescendants.nextElement());
                }
            }
            if (selectedNode.isRemoved() && this.table.getRowCount() <= selectedRow) {
                --selectedRow;
            }
            this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            this.fireDataChangeEvent(this.compareResult.getRootNode().getHauptsatz(), selectedNode.getFeldDeskriptor());
        }
    }

    private Component createToolBarButton(Action action) {
        JButton button = new JButton(action);
        button.setDisabledIcon((Icon)action.getValue("disabledIcon"));
        return button;
    }

    public void addPopupMenu(boolean hauptsatzProtected) {
        this.jPopupMenu = new JPopupMenu();
        if (this.compareResult.getDifferingCount(this.compareResult.getRootNode()) > 0) {
            this.jPopupMenu.add(this.getToNextDifferenceAction().getJMenuItem());
            this.jPopupMenu.add(this.getToPrevDifferenceAction().getJMenuItem());
        }
        if (!hauptsatzProtected) {
            this.jPopupMenu.add(this.getValueToLeftAction().getJMenuItem());
            this.jPopupMenu.add(this.getCopyToLeftAction().getJMenuItem());
            this.jPopupMenu.add(this.getCreateNodeAction().getJMenuItem());
            if (this.isDeleteElementActionAktiv) {
                this.jPopupMenu.add(this.getDeleteElementAction().getJMenuItem());
            }
        }
        MouseAdapter mousListener = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && CompareEditor.this.table.getSelectedRow() >= 0) {
                    CompareEditor.this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.table.addMouseListener(mousListener);
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void fireDataChangeEvent(SatzInterface changedDataSet, String valueOld, String valueNew, FeldDeskriptorImpl feldDescriptor) {
        int i = 0;
        while (i < this.listenerList.size()) {
            DataChangeListener listener = (DataChangeListener)this.listenerList.get(i);
            listener.dataChangedEvent(new DataChangeEvent(changedDataSet, valueOld, valueNew, feldDescriptor));
            ++i;
        }
    }

    public void fireDataChangeEvent(SatzInterface changedDataSet, FeldDeskriptorImpl feldDescriptor) {
        int i = 0;
        while (i < this.listenerList.size()) {
            DataChangeListener listener = (DataChangeListener)this.listenerList.get(i);
            listener.dataChangedEvent(new DataChangeEvent(changedDataSet, feldDescriptor));
            ++i;
        }
    }

    public void setCompareResult(CompareResult compareResult) {
        if (this.table != null) {
            this.table.clearSelection();
            List paths = this.getExpandedNodesAsStrings();
            this.compareResult = compareResult;
            this.treeTableModel.root = this.compareResult.getRootNode();
            this.treeTableModel.nodeChanged((ComparedNode)this.treeTableModel.getRoot());
            this.setExpandedNodesAsStrings(paths);
        } else {
            this.compareResult = compareResult;
            this.buildAndAssembleUiComponents();
            this.addListSelectionListener();
            this.addColumnModelListener();
            this.addTreeModelListener();
        }
        this.updateDifferingUI();
    }

    public void expandAll() {
        this.table.expandAll();
    }

    private List getExpandedNodesAsStrings() {
        ArrayList<String> list = new ArrayList<String>();
        TreePath rootTreePath = new TreePath(this.compareResult.getRootNode());
        Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(rootTreePath);
        if (expandedDescendants != null) {
            while (expandedDescendants.hasMoreElements()) {
                TreePath treePath = expandedDescendants.nextElement();
                String string = this.getTreePathAsString(treePath);
                if (string == null) continue;
                list.add(string);
            }
        }
        return list;
    }

    private void setExpandedNodesAsStrings(List list) {
        ArrayList allPaths = new ArrayList();
        this.getAllPaths(this.compareResult.getRootNode(), allPaths);
        int i = 0;
        while (i < allPaths.size()) {
            TreePath tmp = (TreePath)allPaths.get(i);
            String str = this.getTreePathAsString(tmp);
            if (str != null && list.contains(str)) {
                this.table.getTree().expandPath(tmp);
            }
            ++i;
        }
    }

    private String getTreePathAsString(TreePath treePath) {
        ComparedNode comparedNode = (ComparedNode)treePath.getLastPathComponent();
        String result = comparedNode != null && comparedNode.getFeldDeskriptor() != null ? comparedNode.getFeldDeskriptor().hierarchyAsString() : null;
        return result;
    }

    private void getAllPaths(ComparedNode parent, List allPaths) {
        ComparedNode child = null;
        if (parent.getChildCount() > 0) {
            int childcount = parent.getChildCount();
            int i = 0;
            while (i < childcount) {
                child = parent.getChild(i);
                allPaths.add(new TreePath(parent.getChild(i).getPath()));
                this.getAllPaths(child, allPaths);
                ++i;
            }
        }
    }

    public boolean isHauptsatzProtected() {
        return this.hauptsatzProtected;
    }

    public void setHauptsatzProtected(boolean hauptsatzProtected) {
        this.hauptsatzProtected = hauptsatzProtected;
        if (this.treeTableModel != null) {
            this.treeTableModel.setHauptsatzProtected(hauptsatzProtected);
        }
    }

    public boolean isDeleteElementActionAktiv() {
        return this.isDeleteElementActionAktiv;
    }

    public void setDeleteElementActionAktiv(boolean isDeleteElementActionAktiv) {
        this.isDeleteElementActionAktiv = isDeleteElementActionAktiv;
    }

    public void markFields(FeldDeskriptorInterface[] errorFields) {
        this.errorFields = errorFields;
        if (this.table != null) {
            if (this.table.getSelectedRow() >= 0) {
                this.table.clearSelection();
            }
            this.table.repaint();
        }
        if (errorFields != null && errorFields.length > 0) {
            int row = this.getRowFor(errorFields[0]);
            Rectangle rectangle = this.table.getCellRect(row, 1, true);
            this.table.scrollRectToVisible(rectangle);
        }
    }

    public boolean isMarkField(FeldDeskriptorImpl feldDeskriptorImpl) {
        boolean isMarkField = false;
        if (this.errorFields != null && feldDeskriptorImpl != null) {
            int i = 0;
            while (i < this.errorFields.length && !isMarkField) {
                isMarkField = this.isGleich(this.errorFields[i], feldDeskriptorImpl);
                ++i;
            }
        }
        return isMarkField;
    }

    public void selectField(FeldDeskriptorInterface feldDeskriptor) {
        int row;
        if (this.table.getSelectedRow() >= 0) {
            this.table.clearSelection();
        }
        if ((row = this.getRowFor(feldDeskriptor)) != -1) {
            TreePath path = this.table.getTree().getPathForRow(row);
            this.table.getTree().expandPath(path);
            this.table.getSelectionModel().setSelectionInterval(row, row);
            if (!this.hauptsatzProtected) {
                Object value;
                Component component;
                this.table.editCellAt(row, 1);
                TableCellEditor editor = this.table.getCellEditor();
                if (editor != null && (component = editor.getTableCellEditorComponent(this.table, value = this.table.getValueAt(row, 1), true, row, 1)) != null) {
                    component.requestFocus();
                    if (component instanceof JTextComponent) {
                        ((JTextComponent)component).selectAll();
                    }
                }
            }
        }
    }

    private boolean isGleich(FeldDeskriptorInterface feldDeskriptor1, FeldDeskriptorInterface feldDeskriptor2) {
        int[] indizes2;
        int[] indizes1;
        boolean gleich = false;
        String feldNameTB1 = feldDeskriptor1.getFeldNameTB();
        String feldNameTB2 = feldDeskriptor2.getFeldNameTB();
        if (feldNameTB1 != null && feldNameTB2 != null && feldNameTB1.equals(feldNameTB2) && Arrays.equals(indizes1 = feldDeskriptor1.getIndizes(), indizes2 = feldDeskriptor2.getIndizes())) {
            if (feldDeskriptor1.getVorgaenger() == null && feldDeskriptor2.getVorgaenger() == null) {
                gleich = true;
            } else if (feldDeskriptor1.getVorgaenger() != null && feldDeskriptor2.getVorgaenger() != null) {
                gleich = this.isGleich(feldDeskriptor1.getVorgaenger(), feldDeskriptor2.getVorgaenger());
            }
        }
        return gleich;
    }

    private int getRowFor(FeldDeskriptorInterface feldDeskriptor) {
        int result = -1;
        int rowCount = this.table.getModel().getRowCount();
        int row = 0;
        while (row < rowCount) {
            TreePath path = this.table.getTree().getPathForRow(row);
            ComparedNode node = (ComparedNode)path.getLastPathComponent();
            FeldDeskriptorImpl feldDeskriptor2 = node.getFeldDeskriptor();
            if (feldDeskriptor2 != null && this.isGleich(feldDeskriptor, feldDeskriptor2)) {
                result = row;
                break;
            }
            ++row;
        }
        return result;
    }

    public ComparedNode findComparedNode(FeldDeskriptorInterface feldDeskriptor) {
        ComparedNode result = null;
        int rowCount = this.table.getModel().getRowCount();
        int row = 0;
        while (row < rowCount) {
            TreePath path = this.table.getTree().getPathForRow(row);
            ComparedNode node = (ComparedNode)path.getLastPathComponent();
            FeldDeskriptorImpl tmpFeldDeskriptor = node.getFeldDeskriptor();
            if (tmpFeldDeskriptor != null && this.isGleich(feldDeskriptor, tmpFeldDeskriptor)) {
                result = node;
                break;
            }
            ++row;
        }
        return result;
    }

    public void setHauptsatzValue(Object value, ComparedNode node) {
        int rowCount = this.table.getModel().getRowCount();
        int row = 0;
        while (row < rowCount) {
            TreePath path = this.table.getTree().getPathForRow(row);
            ComparedNode tmpNode = (ComparedNode)path.getLastPathComponent();
            if (tmpNode == node) {
                this.table.setValueAt(value, row, 1);
                break;
            }
            ++row;
        }
    }

    public void showErrorDialog(PlausiFehler fehler, boolean useFullNames) {
        if (fehler == null) {
            throw new IllegalArgumentException("PlausiFehler nicht vorgegeben!");
        }
        PLErrorDialog dlg = null;
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor != null && windowAncestor instanceof Frame) {
            dlg = new PLErrorDialog((Frame)windowAncestor, this, fehler, useFullNames);
        } else if (windowAncestor != null) {
            dlg = new PLErrorDialog((Dialog)windowAncestor, this, fehler, useFullNames);
        }
        if (dlg != null) {
            Point locationOnScreen = this.getLocationOnScreen();
            dlg.setLocation(locationOnScreen.x, locationOnScreen.y);
            dlg.showFehler();
        }
    }

    public void flush() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        this.requestFocus();
    }

    public void printPdf(PdfConfig pdfConfig, OutputStream out) {
        PdfGenerator pdfGenerator = new PdfGenerator();
        String[] columnName = new String[this.table.getColumnModel().getColumnCount()];
        int col = 0;
        while (col < columnName.length) {
            TableColumn column = this.table.getColumnModel().getColumn(col);
            columnName[col] = (String)column.getHeaderValue();
            ++col;
        }
        pdfGenerator.generate(out, this.compareResult, columnName, pdfConfig);
    }

    private class CopyToLeftAction
    extends JMenuItemAction {
        private static final long serialVersionUID = 3223816708389324405L;

        public CopyToLeftAction() {
            this.putValue("ShortDescription", "Struktur zum Hauptsatz hinzuf\u00fcgen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/add_l.gif")));
            this.putValue("disabledIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/add_l_d.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                CompareEditor.this.copySelectedStrukturWithValue();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private class CreateSatzAction
    extends JMenuItemAction {
        private static final long serialVersionUID = -5202782016287424442L;

        public CreateSatzAction() {
            this.putValue("ShortDescription", "Satz zur selektierten Struktur anlegen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare2/ui/images/append.gif")));
            this.putValue("disabledIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare2/ui/images/append_d.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                CompareEditor.this.appendSatzOnSelectedStruktur();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private class DeleteElementAction
    extends JMenuItemAction {
        private static final long serialVersionUID = -533265843529762177L;

        public DeleteElementAction() {
            this.putValue("ShortDescription", "Selektierten Satz l\u00f6schen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare2/ui/images/remove_l.gif")));
            this.putValue("disabledIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare2/ui/images/remove_l_d.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            CompareEditor.this.deleteSelectedStruktur();
            CompareEditor.this.repaint();
        }
    }

    private abstract class JMenuItemAction
    extends AbstractAction {
        private static final long serialVersionUID = -6233944096745233208L;

        private JMenuItemAction() {
        }

        public JMenuItem getJMenuItem() {
            JMenuItem jMenuItem = new JMenuItem(this);
            jMenuItem.setText((String)this.getValue("ShortDescription"));
            return jMenuItem;
        }
    }

    private class ToNextDifferenceAction
    extends JMenuItemAction {
        private static final long serialVersionUID = 1806705138235092328L;

        public ToNextDifferenceAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/next_nav.gif")));
            this.putValue("ShortDescription", "Zum n\u00e4chsten Unterschied springen");
        }

        public void actionPerformed(ActionEvent event) {
            CompareEditor.this.goToDifference(true);
        }
    }

    private class ToPrevDifferenceAction
    extends JMenuItemAction {
        private static final long serialVersionUID = 1L;
        private Icon icon;

        public ToPrevDifferenceAction() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.statspez.pleditor.generator.compare2.ui.CompareEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.icon = new ImageIcon(clazz.getResource("/de/statspez/pleditor/generator/compare/ui/images/prev_nav.gif"));
            this.putValue("SmallIcon", this.icon);
            this.putValue("ShortDescription", "Zum vorherigen Unterschied springen");
        }

        public void actionPerformed(ActionEvent event) {
            CompareEditor.this.goToDifference(false);
        }
    }

    private class ValueToLeftAction
    extends JMenuItemAction {
        private static final long serialVersionUID = 3223816708389324405L;

        public ValueToLeftAction() {
            this.putValue("ShortDescription", "Werte in den Hauptsatz \u00fcbernehmen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/copy_l.gif")));
            this.putValue("disabledIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/copy_l_d.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            CompareEditor.this.transferSelectedValue();
        }
    }
}

