/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser.speclanguage.ui;

import de.statspez.pleditor.generator.parser.speclanguage.ui.HighlightScanner;
import de.statspez.pleditor.generator.parser.speclanguage.ui.SyntaxSegment;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PLSyntaxTextAreaUI
extends BasicTextAreaUI {
    public static final Color DEFAULT_COLOR = Color.black;
    public static final Color COMMENT_COLOR = Color.gray;
    public static final Color NUMBER_COLOR = Color.orange.darker();
    public static final Color STRING_COLOR = Color.green.darker();
    public static final Color MISC_SYMBOL_COLOR = Color.red.darker();
    public static final Color OPERATOR_SYMBOL_COLOR = Color.red.darker();
    public static final Color OPERATOR_KEYWORD_COLOR = Color.red.darker();
    public static final Color KEYWORD_COLOR = Color.blue;
    private Vector syntax = null;
    private Color defaultColor = DEFAULT_COLOR;
    private Color commentColor = COMMENT_COLOR;
    private Color numberColor = NUMBER_COLOR;
    private Color stringColor = STRING_COLOR;
    private Color miscSymbolColor = MISC_SYMBOL_COLOR;
    private Color operatorSymbolColor;
    private Color operatorKeywordColor = OPERATOR_KEYWORD_COLOR;
    private Color keywordColor;

    public PLSyntaxTextAreaUI() {
        this.operatorSymbolColor = OPERATOR_SYMBOL_COLOR;
        this.keywordColor = KEYWORD_COLOR;
    }

    public void setOperatorKeywordColor(Color operatorKeywordColor) {
        this.operatorKeywordColor = operatorKeywordColor;
    }

    public void setOperatorSymbolColor(Color operatorSymbolColor) {
        this.operatorSymbolColor = operatorSymbolColor;
    }

    public void setKeywordColor(Color keywordColor) {
        this.keywordColor = keywordColor;
    }

    public void setMiscSymbolColor(Color miscSymbolColor) {
        this.miscSymbolColor = miscSymbolColor;
    }

    public void setStringColor(Color stringColor) {
        this.stringColor = stringColor;
    }

    public void setNumberColor(Color numberColor) {
        this.numberColor = numberColor;
    }

    public void setCommentColor(Color commentColor) {
        this.commentColor = commentColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public static ComponentUI createUI(JComponent c) {
        return new PLSyntaxTextAreaUI();
    }

    public View create(Element element) {
        return new PLSyntaxPlainView(element);
    }

    private void addSyntaxSegment(SyntaxSegment segment) {
        if (!this.syntax.isEmpty()) {
            SyntaxSegment previousSegment = (SyntaxSegment)this.syntax.lastElement();
            previousSegment.setNext(segment);
        }
        this.syntax.add(segment);
    }

    private synchronized void updateSyntax() {
        this.syntax.clear();
        HighlightScanner scanner = new HighlightScanner(new StringReader(this.getComponent().getText()));
        try {
            SyntaxSegment s;
            while ((s = scanner.next_segment()) != null) {
                this.addSyntaxSegment(s);
                if (!scanner.isEofReached()) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SyntaxSegment getSyntaxSegment(int offset) throws BadLocationException {
        if (this.syntax == null) {
            this.syntax = new Vector();
            this.updateSyntax();
        }
        if (this.syntax.isEmpty()) {
            return null;
        }
        return this.getSyntaxSegment(offset, 0, this.syntax.size() - 1);
    }

    private SyntaxSegment getSyntaxSegment(int offset, int startIndex, int endIndex) {
        SyntaxSegment startSegment = (SyntaxSegment)this.syntax.get(startIndex);
        if (offset <= startSegment.getOffsetEnd()) {
            return startSegment;
        }
        if (startIndex == endIndex) {
            return null;
        }
        SyntaxSegment endSegment = (SyntaxSegment)this.syntax.get(endIndex);
        if (offset >= endSegment.getOffsetStart() && offset <= endSegment.getOffsetEnd()) {
            return endSegment;
        }
        if (offset > endSegment.getOffsetEnd()) {
            return null;
        }
        if (startIndex + 1 == endIndex) {
            if (offset <= endSegment.getOffsetEnd()) {
                return endSegment;
            }
            return null;
        }
        int middleIndex = startIndex + (endIndex - startIndex) / 2;
        SyntaxSegment middleSegment = (SyntaxSegment)this.syntax.get(middleIndex);
        if (offset >= middleSegment.getOffsetStart() && offset <= middleSegment.getOffsetEnd()) {
            return middleSegment;
        }
        if (offset < middleSegment.getOffsetStart()) {
            return this.getSyntaxSegment(offset, startIndex + 1, middleIndex);
        }
        return this.getSyntaxSegment(offset, middleIndex + 1, endIndex);
    }

    private class PLSyntaxPlainView
    extends PlainView {
        public PLSyntaxPlainView(Element element) {
            super(element);
        }

        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (PLSyntaxTextAreaUI.this.syntax == null) {
                PLSyntaxTextAreaUI.this.syntax = new Vector();
            }
            PLSyntaxTextAreaUI.this.updateSyntax();
            super.insertUpdate(e, a, f);
            PLSyntaxTextAreaUI.this.getComponent().repaint();
        }

        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (PLSyntaxTextAreaUI.this.syntax == null) {
                PLSyntaxTextAreaUI.this.syntax = new Vector();
            }
            PLSyntaxTextAreaUI.this.updateSyntax();
            super.removeUpdate(e, a, f);
            PLSyntaxTextAreaUI.this.getComponent().repaint();
        }

        protected int drawSelectedText(Graphics g, int x, int y, int startOffset, int endOffset) throws BadLocationException {
            if (!PLSyntaxTextAreaUI.this.getComponent().getCaret().isSelectionVisible()) {
                return this.drawText(g, x, y, startOffset, endOffset);
            }
            return super.drawSelectedText(g, x, y, startOffset, endOffset);
        }

        protected int drawUnselectedText(Graphics g, int x, int y, int startOffset, int endOffset) throws BadLocationException {
            return this.drawText(g, x, y, startOffset, endOffset);
        }

        private int drawText(Graphics g, int x, int y, int startOffset, int endOffset) throws BadLocationException {
            Segment segment = new Segment();
            this.getDocument().getText(startOffset, endOffset - startOffset, segment);
            FontMetrics fontMetrics = g.getFontMetrics();
            int nextX = x;
            char[] txt = segment.array;
            int i = segment.offset;
            int n = segment.offset + segment.count;
            SyntaxSegment syntaxSegment = null;
            while (i < n) {
                if (txt[i] == '\t') {
                    x = nextX = (int)this.nextTabStop(nextX, i);
                    ++i;
                    continue;
                }
                if (txt[i] == '\n' || txt[i] == '\r') {
                    x = nextX;
                    ++i;
                    continue;
                }
                int offset = i - segment.offset + startOffset;
                if (syntaxSegment != null) {
                    if (offset > syntaxSegment.getOffsetEnd()) {
                        syntaxSegment = syntaxSegment.getNext();
                    }
                } else {
                    syntaxSegment = PLSyntaxTextAreaUI.this.getSyntaxSegment(offset);
                }
                if (syntaxSegment != null && offset >= syntaxSegment.getOffsetStart() && offset <= syntaxSegment.getOffsetEnd()) {
                    switch (syntaxSegment.getType()) {
                        case 1: {
                            g.setColor(PLSyntaxTextAreaUI.this.commentColor);
                            break;
                        }
                        case 2: {
                            g.setColor(PLSyntaxTextAreaUI.this.numberColor);
                            break;
                        }
                        case 3: {
                            g.setColor(PLSyntaxTextAreaUI.this.stringColor);
                            break;
                        }
                        case 4: {
                            g.setColor(PLSyntaxTextAreaUI.this.miscSymbolColor);
                            break;
                        }
                        case 5: {
                            g.setColor(PLSyntaxTextAreaUI.this.operatorSymbolColor);
                            break;
                        }
                        case 6: {
                            g.setColor(PLSyntaxTextAreaUI.this.operatorKeywordColor);
                            break;
                        }
                        case 7: {
                            g.setColor(PLSyntaxTextAreaUI.this.keywordColor);
                            break;
                        }
                        default: {
                            g.setColor(PLSyntaxTextAreaUI.this.defaultColor);
                            break;
                        }
                    }
                } else {
                    g.setColor(PLSyntaxTextAreaUI.this.defaultColor);
                }
                int length = n - i;
                if (syntaxSegment != null) {
                    length = offset >= syntaxSegment.getOffsetStart() && offset <= syntaxSegment.getOffsetEnd() ? Math.min(length, syntaxSegment.getOffsetEnd() - offset + 1) : Math.min(length, syntaxSegment.getOffsetStart() - offset);
                }
                g.drawChars(txt, i, length, x, y);
                x = nextX += fontMetrics.charsWidth(txt, i, length);
                i += length;
            }
            return nextX;
        }
    }
}

