/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;

public class BooleanValue
extends Value {
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    public static final String TRUE_STRING = "WAHR";
    public static final String FALSE_STRING = "FALSCH";
    private Boolean myValue = null;

    public BooleanValue(boolean value) {
        this.myValue = new Boolean(value);
    }

    public double asDouble() throws ValueConversionException {
        if (!this.asBoolean()) {
            return 0.0;
        }
        return 1.0;
    }

    public long asLong() throws ValueConversionException {
        return (long)this.asDouble();
    }

    public boolean asBoolean() throws ValueConversionException {
        return this.myValue;
    }

    public String asString() throws ValueConversionException {
        if (this.myValue.booleanValue()) {
            return TRUE_STRING;
        }
        return FALSE_STRING;
    }

    protected int operatorLevel() {
        return 2;
    }

    protected boolean eqImpl(Value aValue) {
        return this.asBoolean() == aValue.asBoolean();
    }

    protected boolean ltImpl(Value aValue) {
        return this.asDouble() < aValue.asDouble();
    }

    protected boolean leImpl(Value aValue) {
        return this.asDouble() <= aValue.asDouble();
    }

    protected boolean gtImpl(Value aValue) {
        return this.asDouble() > aValue.asDouble();
    }

    protected boolean geImpl(Value aValue) {
        return this.asDouble() >= aValue.asDouble();
    }

    protected boolean neImpl(Value aValue) {
        return this.asBoolean() ^ aValue.asBoolean();
    }

    protected boolean containsImpl(Value aValue) {
        return this.eq(aValue);
    }
}

