/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test.runtime;

import com.sun.xml.internal.messaging.saaj.packaging.mime.util.LineInputStream;
import de.statspez.pleditor.generator.test.runtime.RuntimeInfos;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;

public class RuntimeInfosUtil {
    private static final int CSV_FIELD_COUNT = 5;
    private static final int CSV_COLUMN_NAME = 0;
    private static final int CSV_COLUMN_GESAMTDAUER = 1;
    private static final int CSV_COLUMN_DURCHSCHNITDAUER = 2;
    private static final int CSV_COLUMN_AUFRUFANZAHL = 3;
    private static final int CSV_COLUMN_LAUFZEITWERTE = 4;
    private static RuntimeInfosUtil runtimeInfosUtil = null;

    private RuntimeInfosUtil() {
    }

    public static RuntimeInfosUtil instance() {
        if (runtimeInfosUtil == null) {
            runtimeInfosUtil = new RuntimeInfosUtil();
        }
        return runtimeInfosUtil;
    }

    public RuntimeInfos loadRuntimeInfos(InputStream csvInputStream) throws Exception {
        RuntimeInfos runtimeMap = new RuntimeInfos();
        LineInputStream in = new LineInputStream(csvInputStream);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String[] values = line.split(";");
                if (values[0].startsWith("#")) continue;
                String name = null;
                String laufzeitwerte = null;
                int i = 0;
                while (i < values.length) {
                    switch (i) {
                        case 3: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 4: {
                            laufzeitwerte = values[i];
                            break;
                        }
                        case 0: {
                            name = values[i];
                            break;
                        }
                    }
                    ++i;
                }
                if (name == null || laufzeitwerte == null) continue;
                String[] array = laufzeitwerte.trim().split(" ");
                int i2 = 0;
                while (i2 < array.length) {
                    try {
                        Long laufzeit = new Long(array[i2]);
                        runtimeMap.fuegeLaufzeitHinzu(name, laufzeit);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++i2;
                }
            }
            RuntimeInfos runtimeInfos = runtimeMap;
            return runtimeInfos;
        }
        finally {
            in.close();
        }
    }

    public void storeRuntimeInfos(OutputStream csvOutputStream, RuntimeInfos runtimeInfos) throws IOException {
        Iterator keys = runtimeInfos.gibProgrammNamen().iterator();
        csvOutputStream.write(this.generateCsvHeaderZeile().getBytes());
        while (keys.hasNext()) {
            String name = (String)keys.next();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < 5) {
                switch (i) {
                    case 3: {
                        buf.append(runtimeInfos.gibAufrufAnzahl(name));
                        break;
                    }
                    case 2: {
                        buf.append(runtimeInfos.gibDurchschnittdauer(name));
                        break;
                    }
                    case 1: {
                        buf.append(runtimeInfos.gibGesamtdauer(name));
                        break;
                    }
                    case 4: {
                        buf.append(runtimeInfos.gibLaufzeitwerte(name));
                        break;
                    }
                    case 0: {
                        buf.append(name);
                        break;
                    }
                }
                if (i != 4) {
                    buf.append(';');
                }
                ++i;
            }
            buf.append(System.getProperty("line.separator"));
            csvOutputStream.write(buf.toString().getBytes());
        }
    }

    public void toSetFrequencyInProperties(Properties properties, RuntimeInfos runtimeInfos) {
        Iterator it = runtimeInfos.gibProgrammNamen().iterator();
        String keyPrefix = "program.";
        while (it != null && it.hasNext()) {
            String programName = (String)it.next();
            Iterator frequencyIDs = runtimeInfos.gibFrequencyIDs(programName).iterator();
            while (frequencyIDs != null && frequencyIDs.hasNext()) {
                String frequencyID = (String)frequencyIDs.next();
                Long frequency = runtimeInfos.gibFrequenz(programName, frequencyID);
                if (frequency == null) continue;
                properties.put(String.valueOf(keyPrefix) + programName + "." + frequencyID, frequency.toString());
            }
        }
        keyPrefix = "datastructure.";
        it = runtimeInfos.gibDatastructureKeys();
        while (it != null && it.hasNext()) {
            String key = (String)it.next();
            Long frequency = runtimeInfos.gibDatastructureFrequenz(key);
            if (frequency == null) continue;
            properties.put(String.valueOf(keyPrefix) + key, frequency.toString());
        }
    }

    private String generateCsvHeaderZeile() {
        StringBuffer buf = new StringBuffer();
        buf.append("#");
        int i = 0;
        while (i < 5) {
            switch (i) {
                case 3: {
                    buf.append("Anzahl der Aufrufe");
                    break;
                }
                case 2: {
                    buf.append("Durchschnittdauer");
                    break;
                }
                case 1: {
                    buf.append("Gesamtdauer");
                    break;
                }
                case 4: {
                    buf.append("Die Laufzeitwerte");
                    break;
                }
                case 0: {
                    buf.append("Name");
                    break;
                }
            }
            if (i != 4) {
                buf.append(';');
            }
            ++i;
        }
        buf.append(System.getProperty("line.separator"));
        return buf.toString();
    }
}

